/*
 * Created on 05/07/2011
 * 
 * Copyright 2011 Senior Sistemas Ltda. All rights reserved.
 */

/**
 * Classe utilizada para agrupar funes utilitrias e atributos globais para a
 * gerao e aplicao de estilos.
 * 
 * @author Ramon Fernando Weiss
 */
StyleHelper = {

    /**
     * Utilizado na criao de classes CSS para o controle de estilos.
     * 
     * @param className
     *            O nome da classe CSS a ser adicionada.
     * @param cssClass
     *            Os atributos da classe, em formato JSON.
     */
    createClass : function(className, cssClass) {
        var CSS = document.getElementById(className);
        if (CSS) {
            var oldCssClass = Ext.isIE ? CSS.styleSheet.cssText : CSS.innerHTML;
            cssClass = this.makeCSS(oldCssClass, cssClass);
            Ext.util.CSS.removeStyleSheet(className);
        }
        Ext.util.CSS.createStyleSheet(cssClass, className);
    },

    /**
     * Cria um css para ser adicionado no browser.
     * Verifica as diferenas entre as novas clases e as existentes. 
     * Sobrescreve as classes que ja existem e adiciona as que ainda nao existem.
     * 
     * @param styleSheet classes de css ja existentes no browser.
     * @param cssClass novas classes de css que sero adicionadas.
     * @returns {String} css que sera adicionado no broser.
     */
    makeCSS : function(styleSheet, cssClass) {
        var oldCSS = this.getClassName(styleSheet);
        var newCSS = this.getClassName(cssClass);
        for ( var j = 0; j < newCSS.length; j++) {
            for ( var i = 0; i < oldCSS.length; i++) {
                if (oldCSS[i].indexOf(newCSS[j]) > -1 && oldCSS[i].length == newCSS[j].length) {
                    var old = this.getClass(styleSheet)[i];
                    var newc = this.getClass(cssClass)[j];
                    styleSheet = styleSheet.replace(old, newc);
                    break;
                }
                if (i == (oldCSS.length - 1)) {
                    styleSheet += this.getClass(cssClass)[j] + "} ";
                }
            }
        }
        return styleSheet;
    },

    /**
     * Recupera as classe existentes no css passado como parmetro. 
     * 
     * @param css do qual se quer obter as classes 
     * @return um array com todas as classes deste css
     */
    getClass : function(css) {
        return css.match(/\.[^}]*/g);
    },

    /**
     * Recupera o nome de todas as classes existentes no css passado como parmetro. 
     * 
     * @param css do qual se quer obter o nome das classes.
     * @return um array com o nome de todas as classes deste css. 
     */
    getClassName : function(css) {
        return css.match(/\.[^ ]*[^png]*{/g);
    },
    
    /**
     * Utilizado para alterar o tema aplicado na pgina.
     * @param themeName nome do tema a ser aplicado.
     * @param fingerprint Identificador da data de alterao do tema para fins de controle de cache.
     */
    changeTheme : function(themeName, fingerprint) {
        theme_css_resource.href = "resources/" + fingerprint + "/css/" + themeName + "/theme.css";
    },

    getActiveTheme : function() {
        var i, a, links = document.getElementsByTagName("link"), len = links.length;
        for (i = 0; i < len; i++) {
            a = links[i];
            if (a.getAttribute("rel").indexOf("style") != -1 && a.getAttribute("title") && !a.disabled) {
                return a.getAttribute("title");
            }
        }
        return null;
    }

};