/**
 * Classe que rene mtodos utilitrios de seleo de texto em campos editveis.
 * 
 * @author Joao.Maas
 */
SelectionUtil = {

    /**
     * Objeto de seleo "default", representa a ausncia de informaes<br>
     * sobre a seleo de texto
     */
    defaultSelection : {
        selectionStart : -1,
        selectionEnd : -1,
        beforeText : "",
        text : "",
        afterText : "",
        compValue : ""
    },

    /**
     * Mtodo que retorna infomaes sobre posicionamento do caret e seleo de texto em campos tipo texto.<br>
     * Informaes fornecidas:<br>
     * selectionStart : posio inicial da seleo do texto;<br>
     * selectionEnd : posio final da seleo do texto;<br>
     * beforeText : texto que encontra-se antes a seleo do texto;<br>
     * text : texto selecionado;<br>
     * afterText : texto que encontra-se aps a seleo do texto;<br>
     * compValue : texto completo do componente;<br>
     * 
     * Caso no for possvel extrair as iformaes do componente passado como parmetro, retorna um objeto "default".
     * 
     * 
     * @param {Ext.form.TextField}
     *            textField um componente EXT que extenda Ext.form.TextField
     * 
     * @return {json} Objeto com as informaes de seleo de texto. {<br>
     *         selectionStart : {Number},<br>
     *         selectionEnd : {Number},<br>
     *         beforeText : {String},<br>
     *         text : {String},<br>
     *         afterText : {String},<br>
     *         compValue : {String}<br> }<br>
     * 
     * @public
     */
    getSelection : function(textField) {
    	if(document.activeElement.id === textField.id) {
    	    var domElement = textField.getEl().dom;
    	    
	        if (Ext.isIE) {
	            var start = 0;
	            var end = 0;
	            var normalizedValue;
	            var range;
	            var textInputRange;
	            var len;
	            var endRange;

    	        if (typeof domElement.selectionStart == "number" && typeof domElement.selectionEnd == "number") {
    	            start = domElement.selectionStart;
    	            end = domElement.selectionEnd;
    	        } else {
    	            range = document.selection.createRange();
    
    	            if (range && range.parentElement() == domElement) {
    	                len = domElement.value.length;
    	                normalizedValue = domElement.value.replace(/\r\n/g, "\n");
    
    	                // Create a working TextRange that lives only in the input
    	                textInputRange = domElement.createTextRange();
    	                textInputRange.moveToBookmark(range.getBookmark());
    
    	                // Check if the start and end of the selection are at the very end
    	                // of the input, since moveStart/moveEnd doesn't return what we want
    	                // in those cases
    	                endRange = domElement.createTextRange();
    	                endRange.collapse(false);
    
    	                if (textInputRange.compareEndPoints("StartToEnd", endRange) > -1) {
    	                    start = end = len;
    	                } else {
    	                    start = -textInputRange.moveStart("character", -len);
    	                    start += normalizedValue.slice(0, start).split("\n").length - 1;
    
    	                    if (textInputRange.compareEndPoints("EndToEnd", endRange) > -1) {
    	                        end = len;
    	                    } else {
    	                        end = -textInputRange.moveEnd("character", -len);
    	                        end += normalizedValue.slice(0, end).split("\n").length - 1;
    	                    }
    	                }
    	            }
    	        }
	        
    	        return {
    	                selectionStart : start,
    	                selectionEnd : end,
    	                beforeText : domElement.value.substring(0, start),
    	                text : domElement.value.substring(start, end),
    	                afterText : domElement.value.substring(end),
    	                compValue : textField.getValue()
    	            };
	        } else {
	            if (domElement.selectionEnd != null && domElement.selectionStart != null) {
	                if (domElement.selectionEnd >= domElement.selectionStart) {
	                    return {
	                        selectionStart : domElement.selectionStart,
	                        selectionEnd : domElement.selectionEnd,
	                        beforeText : domElement.value.substr(0, domElement.selectionStart),
	                        text : domElement.value.substr(domElement.selectionStart, domElement.selectionEnd - domElement.selectionStart),
	                        afterText : domElement.value.substr(domElement.selectionEnd),
	                        compValue : textField.getValue()
	                    };
	                }
	            }
	        }
    	}
        return this.defaultSelection;
    },

    /**
     * Mtodo que retorna o texto selecionado em campos tipo texto.
     * 
     * Caso no for possvel extrair o texto selecionado do componente passado como parmetro, retorna "".
     * 
     * @param {Ext.form.TextField}
     *            textField um componente EXT que extenda Ext.form.TextField
     * 
     * @return {String} texto selecionado no campo passado como parmetro
     * @public
     */
    getSelectedText : function(textField) {
        var selection = this.getSelection(textField);
        return selection.text;
    },


    /**
     * Mtodo que conta quantas quebras de linha possuem na String passada como parmetro
     * 
     * @private
     */
    getBreakLineCount : function(value) {
        var match = value.match(/\n/gi);
        if (match != null) {
            return match.length;
        }
        return 0;
    }
};