Ext.namespace('Ext.ux.senior.form');

/**
 * Agrupador de RadioButtons.
 */
Ext.ux.senior.form.RadioGroup = Ext.extend(Ext.Component, {

    initComponent : function() {
        this.radios = new Ext.util.MixedCollection();
        
        Ext.ux.senior.form.RadioGroup.superclass.initComponent.call(this, arguments);
        this.on('beforedestroy', function(){
            this.radios.clear();
        }, this);
    },

    /**
     * Retorna qual RadioButton deste RadioGroup est selecionado.
     * @returns RadioButton selecionado. <code>undefined</code> caso nenhum esteja selecionado.
     */
    getChecked : function() {
        for ( var i = 0; i < this.radios.getCount(); i++) {
            var radio = this.radios.itemAt(i);
            if (radio.checked || radio.el.dom.checked) {
                return radio;
            }
        }
    },
    
    /**
     * Retorna todos os RadioButtons.
     * @returns {Ext.util.MixedCollection}
     */
    getAll : function(){
        return this.radios;
    },

    /**
     * Adiciona um RadioButton a este RadioGroup.
     * @param radio
     */
    add : function(radio) {
        if (Ext.isArray(radio)) {
            Ext.each(radio, function(radio) {
                this.add(radio);
            }, this);
        } else {
            this.radios.add(radio);
        }
    },

    /**
     * Remove um RadioButton.
     * @param radio
     */
    remove : function(radio) {
        this.radios.remove(radio);
    }

});
Ext.reg('seniorradiogroup', Ext.ux.senior.form.RadioGroup);
