Ext.namespace('Ext.ux.senior.form');

/**
 * Componente RadioButton
 * 
 * @class Ext.ux.senior.form.RadioButton
 * @extends Ext.form.RadioButton
 */
Ext.ux.senior.form.RadioButton = Ext.extend(Ext.form.Radio, {

    initComponent : function() {
        if (this.boxLabel == '&#160;') {
            this.boxLabel = '';
        }
        Ext.ux.senior.form.RadioButton.superclass.initComponent.call(this, arguments);

        if (Ext.isIE7 || (Ext.isIE && document.documentMode == 7)) {
            this.on('afterRender', this.afterRenderRadioButton, this, {
                buffer : 10
            });
        }

        this.on('afterrender', this.afterRender, this);
    },

    /**
     * Radio herda o css do checkbox
     * @override
     */
    render : function(ct, position) {
        Ext.ux.senior.form.RadioButton.superclass.render.call(this, ct, position);
        /* quando no existir a descrio do checkbox, no exibir a tag label que contm a descrio. */
        var description = this.container.select('label').elements[0];
        if (description != null && description.innerHTML === "&nbsp;") {
            description.style.display = 'none';
        }
        var divEl = Ext.get(this.el.findParent('.x-form-check-wrap'));
        divEl.addClass('ux-checkbox-dirty-position');
    },

    afterRenderRadioButton : function() {
        this.el.repaint();
    },

    afterRender : function() {
        this.radioGroup = Ext.getCmp(this.name + '-rg');
        if (!this.radioGroup) {
            this.radioGroup = new Ext.ux.senior.form.RadioGroup({
                id : this.name + '-rg'
            });
        }
        this.radioGroup.add(this);

        this.radioGroup.checked = this.checked;

        this.el.on('click', this.onClick, this);
        
        if (this.customStyle) {
            this.setStyle(this.customStyle);
            delete this.customStyle;
        } 

        //tudo por causa do readOnly do RadioButton, assim o RadioGroup ir controlar qual radiobutton ser checado 
        this.el.dom.onclick = function() {
            return false;
        };
    },

    eventMapping : function() {
        return {
            check : this.prepareChangedEventData
        };
    },

    /**
     * Dados para serem envidados para servidor no evento check
     */
    prepareChangedEventData : function() {
        return {
            type : 'changed',
            value : this.checked
        };
    },

    /**
     * Sobrescreve o onClick para prevenir que o valor seja editado
     * quando ele est readOnly.
     * 
     * @override
     */
    onClick : function(e) {
        if (this.readOnly) {
            var checkedRadio = this.radioGroup.getChecked();
            var allRadios = this.radioGroup.getAll();
            for ( var i = 0; i < allRadios.getCount(); i++) {
                var radio = allRadios.itemAt(i);
                radio.el.dom.checked = (radio == checkedRadio);
            }
            this.el.dom.checked = this.checked;
        } else {
            Ext.ux.senior.form.RadioButton.superclass.onClick.call(this);
            this.fireEvent('click', this, e);
        }
    },

    internalSetValue : function(v) {
        var checked = this.checked;
        this.checked = (v === true || v === 'true' || v == '1' || String(v).toLowerCase() == 'on');
        if (this.rendered) {
            this.el.dom.checked = this.checked;
            this.el.dom.defaultChecked = this.checked;
        }
        if (checked != this.checked) {
            if (this.handler) {
                this.handler.call(this.scope || this, this, this.checked);
            }
        }
        return this;
    },

    /**
     * atribui um label
     */
    setLabel : function(textLabel) {
        var labelSeparator = this.ownerCt.labelSeparator;
        this.label.update(textLabel + labelSeparator);
    },

    /**
     * Retorna o elemento que possui o estilo desejado.
     * @param scope o escopo e a propriedade separados por um '$', ex: checkbox$font-color.
     * @returns o elemento que possui o estilo passado no escopo.
     * @override
     */
    getStyleEl : function(scope) {
        var split = scope.split('$');
        var styleScope = split[0];
        var property = split[1];

        if (styleScope == 'radio' && property.indexOf('border') > -1) {
            return this.getEl();
        } else if (styleScope == 'label') {
            return this.label;
        }

        return Ext.get(this.getEl().parent('div'));
    },

    markInvalid : function() {
        var textEl = this.container.child('label');
        if (textEl) {
            textEl.addClass('invalid-field');
        }
    },

    clearInvalid : function() {
        var textEl = this.container.child('label');
        if (textEl) {
            textEl.removeClass('invalid-field');
        }
    },
    //Propriedade para controle do nome de radiobuttons
    realName : "",

    getRealName : function() {
        return this.realName;
    },

    setRealName : function(realName) {
        this.realName = realName;
    }

});

Ext.reg('seniorradio', Ext.ux.senior.form.RadioButton);
