Ext.namespace('Ext.ux.senior');

/**
 * UC-FRC-0080 - Operar Painel.xucs REQ0001 - collapsible REQ0002 - title,
 * eventos expand collpse REQ0009 - add REQ0008 - layout REQ0010 - widht,
 * height, setWidth, setHeight REQ0013 - autoScroll REQ0014 - title, setTitle
 * REQ0015 - setTitle(titulo, css) REQ0011 - irrelevante REQ0012 - irrelevante
 * 
 * @author Daniel.Pereira
 */
Ext.ux.senior.Panel = Ext.extend(Ext.Panel, {

    /**
     * @cfg {Boolean} hasIncorrectChildren
     */

    animCollapse : false,
    border : false,
    loaded: false,

    /**Classe que mostra a imagem da 'cobrinha' de erro*/
    ERROR_CLASS : 'invalid-field',

    /** Seletor para obter o elemento HTML do titulo do painel. */
    TITLE : 'span.x-panel-header-text',

    /** Seletor para obter o elemento HTML do header do painel */
    HEADER : 'div.x-panel-header',

    /** Seletor para obter o elemento HTML do boto de collapse/expande do painel.*/
    COLLAPSE_BUTTON : 'div.x-tool',

    /** Guarda os estilos que no foram aplicados no collapsedEl do borderLayout por ele ainda no ter sido criado, 
     * para aplicar mais tarde quando o collapsedEl for criado. 
     */
    stylesToApply : [],

    stylesTextToApply : [],

    hideOriginalBarOnSlide : false,

    /**
     * @override
     */
    initComponent : function() {
        this.initialConfig.animFloat = false;

        /**
         * Sempre que um painel estivar em tabgroup, deve possuir um ttulo,
         * para no renderizar incorretamente. Isso somente acontece quando for
         * utilizado um cardLayout. obs.: No  possivel adicionar este mtodo
         * no render porque somente  executado quando a aba  clicada.
         */

        var block = SProfilerManager.start("Panel -> initComponent()");
        if (this.ownerCt != null && this.ownerCt.xtype == "seniortabpanel") {
            if (this.title == "" || this.title == null) {
                this.setTitle("&nbsp;");
            } else {
                this.setTitle(this.title.replace(" ", "&nbsp;"));
            }
        }
        Ext.ux.senior.Panel.superclass.initComponent.call(this, arguments);

        SProfilerManager.stop(block);
    },

    render : function(container, position) {
        var block = SProfilerManager.start("Panel -> render()");

        var ret = Ext.ux.senior.Panel.superclass.render.call(this, container, position);

        SProfilerManager.stop(block);
        return ret;
    },

    doLayout : function(shallow, force) {
        var block = SProfilerManager.start("Panel -> doLayout()");

        Ext.ux.senior.Panel.superclass.doLayout.call(this, shallow, force);

        SProfilerManager.stop(block);
    },

    /**
     * Mtodo que adiciona o ttulo a um panel que est em modo collapse, caso
     * esse panel esteja no norte ou sul de um BorderLayout
     * 
     * @private
     */
    setCollapsedTitle : function() {
        if (this.collapsible) {
            var region = this.region;
            if (region == 'north' || region == 'south') {
                var ct = this.ownerCt;
                ct.on('afterlayout', function() {
                    this.createCollapsedTitle(ct, region);
                }, this);
            }
        }
    },

    /**
     * Cria um ttulo para o panel, caso no existe um
     * 
     * @private
     */
    createCollapsedTitle : function(ct, region) {
        var regionEl = ct.layout[region];

        if (!this.collapsedTitleEl) {
            if (regionEl.collapsedEl) {
                this.collapsedTitleEl = regionEl.collapsedEl.createChild({
                    tag : 'span',
                    cls : 'x-senior-collapsed-title',
                    html : this.title
                });
                /*  inserido esse estilo, pois quando existe titulo em um panel "collapsado",
                 * e seu pai possue as propriedades "font-size" e "font-family" com os valores
                 * iguais a de seus filhos, o titulo fica desalinhado. */
                regionEl.collapsedEl.addClass('x-senior-parent-collapsed-title');

                this.setTitle = Ext.Panel.prototype.setTitle.createSequence(function(title) {
                    this.collapsedTitleEl.update(title);
                });
            }
        }
        var collpsdEl = regionEl ? regionEl.collapsedEl : null;

        /*
         * Tarefa 228402
         * Contorno para bug do ext.
         * Est nos bugs criados pela senior na seo de bugs do sencha para o ext 3.3.
         * 
         * Isso  para o ext conseguir calcular certo o tamanho dos componentes no collapse.
         */
        if (collpsdEl && collpsdEl.dom && collpsdEl.dom.style.height == "0px") {
            collpsdEl.dom.style.height = null;
        }
    },

    /**
     * Define se a tbar ir ser exibida ou no.
     * 
     * @author Anderson.Borba
     * @param {boolean}
     *            showToolbar true caso deva exibir a tbar
     * @public
     */
    showToolbar : function(showToolbar) {
        var tbar = this.getTopToolbar();
        if (showToolbar) {
            tbar.show();
        } else {
            tbar.hide();
        }
    },

    /**
     * @override
     */
    onRender : function() {
        Ext.ux.senior.Panel.superclass.onRender.apply(this, arguments);
        if (this.collapsible) {
            var toggle = this.tools.toggle;
            toggle.addClass('x-collapse-left');
            this.setCollapsedTitle();
        }
        this.alignTitle();

        if (this.hasIncorrectChildren) {
            this.setHasIncorrectChildren(this.hasIncorrectChildren);
        }
    },

    /**
     * Alinha o texto do ttulo conform configurao
     * 
     * @private
     */
    alignTitle : function() {
        if (this.header) {
            if (this.titleAlignment == "RIGHT") {
                this.header.addClass("x-panel-title-right");
            } else if (this.titleAlignment == "CENTER") {
                this.header.addClass("x-panel-title-center");
            } else {
                this.header.addClass("x-panel-title-left");
            }
        }
    },

    /**
     * @plugin EventManagerPlugin
     */
    eventMapping : function() {
        return {
            collapse : this.prepareChangeEventData,
            expand : this.prepareChangeEventData
        };
    },

    /**
     * 
     */
    expand : function(p, eOpts) {
        var mustDoLayout = this.collapsed && !this.loaded;
        Ext.ux.senior.Panel.superclass.expand.call(this, p, eOpts);
        
        if (mustDoLayout) {
            this.loaded = true;
            this.doLayout();
        }
    },
    
    /**
     * @private
     */
    prepareChangeEventData : function() {
        return {
            type : 'collapse',
            value : this.collapsed
        };
    },

    setLabel : function(textLabel) {
        var labelSeparator = this.ownerCt.labelSeparator;
        this.label.update(textLabel + labelSeparator);
    },

    /**
     * Retorna o Elemento que possou o Estilo desejado.
     */
    getStyleEl : function(scope) {
        var styleScope = scope.split("$")[0];
        var property = scope.split("$")[1];
        var el;
        if (styleScope == "panel.header") {
            if (property.indexOf('font') > -1) {
                el = this.getEl().child(this.TITLE);
            } else if (this.getCollapseEl() && this.collapsed === true) {
                el = this.getCollapseEl();
            } else {
                el = this.getEl().child(this.HEADER);
            }
        } else {
            el = this.getEl().child('div.x-panel-body');
        }
        return el;
    },

    /**
     * Atualiza o estilo do fundo do header do painel
     * @param classes as classes que sero aplicadas ou removidas
     * @param toAddClass se  para aplicar a classe <code>true</code>, se  para remover <code>false</code>
     * @private
     */
    updateHeaderBackgroundStyle : function(classes, toAddClass) {
        var elements = [];

        var collapsedEl = this.getCollapseEl();

        elements[0] = this.getEl().child(this.HEADER); //imagem de fundo
        elements[1] = this.getEl().child(this.COLLAPSE_BUTTON);//boto collapse

        if (collapsedEl) {
            elements[2] = collapsedEl.child(this.COLLAPSE_BUTTON);//boto collapse do border layout
            elements[3] = collapsedEl;//header do painel collapse no border layout
        } else {
            this.on('collapse', this.applyCollapsedElStyles, this, {
                single : true
            });
            this.stylesToApply = classes;
        }

        for ( var j = 0; j < elements.length; j++) {
            if (elements[j]) {
                if (toAddClass) {
                    elements[j].addClass(classes[j]);
                } else {
                    elements[j].removeClass(classes[j]);
                }
            }

        }

    },

    updateHeaderTransitionStyle : function(classes, toAddClass) {
        var elements = [];

        var collapsedEl = this.getCollapseEl();

        elements[0] = this.getEl().child(this.HEADER); //imagem de fundo
        elements[1] = this.getEl().child(this.COLLAPSE_BUTTON);//boto collapse

        if (collapsedEl) {
            elements[2] = collapsedEl.child(this.COLLAPSE_BUTTON);//boto collapse do border layout
            elements[3] = collapsedEl;//header do painel collapse no border layout
        } else {
            this.on('collapse', this.applyCollapsedElStyles, this, {
                single : true
            });
            this.stylesToApply = classes;
        }

        for ( var j = 0; j < elements.length; j++) {
            if (elements[j]) {
                if (toAddClass) {
                    elements[j].addClass(classes[0]);
                } else {
                    elements[j].removeClass(classes[0]);
                }
            }

        }

    },

    /**
     * Atualiza o estilo da fonte do titulo do painel
     * @param classes as classes que sero aplicadas ou removidas
     * @param toAddClass se  para aplicar a classe <code>true</code>, se  para remover <code>false</code>
     * @private
     */
    updateTitleFontStyle : function(classes, toAddClass) {
        var titleEl = this.getEl().child(this.TITLE);

        if (toAddClass) {
            this.applyClasses(titleEl, classes);
            if (this.collapsedTitleEl) {
                this.applyClasses(this.collapsedTitleEl, classes);
            } else {
                this.on('collapse', this.applyCollapsedElStylesText, this, {
                    single : true
                });
                this.stylesTextToApply = this.stylesTextToApply.concat(classes);
            }
        } else {
            this.removeClasses(titleEl, classes);
            if (this.collapsedTitleEl) {
                this.removeClasses(this.collapsedTitleEl, classes);
            }
        }
    },

    /**
     * Atualiza o estilo da borda do header do painel
     * @param classes as classes que sero aplicadas ou removidas
     * @param toAddClass se  para aplicar a classe <code>true</code>, se  para remover <code>false</code>
     * @private
     */
    updateHeaderBorderStyle : function(classes, toAddClass) {
        var borderEl = this.getEl().child(this.HEADER);

        if (toAddClass) {
            this.applyClasses(borderEl, classes);
            if (this.getCollapseEl()) {
                this.applyClasses(this.getCollapseEl(), classes);
            }
        } else {
            this.removeClasses(borderEl, classes);
            if (this.getCollapseEl()) {
                this.removeClasses(this.getCollapseEl(), classes);
            }
        }

    },

    /**
     * Sobrescrito do Component.js, pois o painel manipula o estilo de uma forma diferente, por ter diferentes elementos dependendo do layout do painel.
     * @override
     */
    manipulateStyle : function(arrayStyle, toAddClass) {
        for ( var i = 0; i < arrayStyle.length; i++) {
            var style = arrayStyle[i];
            var elements = [];
            var scope = style.scope.split('$');
            var styleScope = scope[0];
            var property = scope[1];

            if (styleScope == 'panel.header') {
                if (property == 'background') {
                    this.updateHeaderBackgroundStyle(style.cls, toAddClass);
                } else if (property == 'transition') {
                    this.updateHeaderTransitionStyle(style.cls, toAddClass);
                } else if (property.indexOf('border') > -1) {
                    this.updateHeaderBorderStyle(style.cls, toAddClass);
                } else if (property.indexOf('font') > -1) {
                    this.updateTitleFontStyle(style.cls, toAddClass);
                }
            } else {

                var styleEl = this.getStyleEl(style.scope);
                if (toAddClass) {
                    this.applyClasses(styleEl, style.cls);
                } else {
                    this.removeClasses(styleEl, style.cls);
                }
            }

        }

    },

    /**
     * Aplica classes css de um determinado elemento.
     * @param element o elemento onde classes sero aplicadas
     * @param classes um array das classes a serem aplicadas
     * @private
     */
    applyClasses : function(element, classes) {
        for ( var j = 0; j < classes.length; j++) {
            element.addClass(classes[j]);
        }
    },

    /**
     * Remove classes css de um determinado elemento.
     * @param element o elemento cujas classes sero removidas
     * @param classes um array das classes a serem removidas
     * @private
     */
    removeClasses : function(element, classes) {
        for ( var j = 0; j < classes.length; j++) {
            element.removeClass(classes[j]);
        }
    },

    /**
     * Aplica ou remove a imagem da 'cobrinha' de erro do titulo do painel, conforme o seu estado
     * e de acordo se ele tem ou no filhos com erro.
     * @param hasIncorrectChildren <code>true</code> se possuir filhos com erro, do contrrio <code>false</code>
     */
    setHasIncorrectChildren : function(hasIncorrectChildren) {
        this.hasIncorrectChildren = hasIncorrectChildren;
        
        if(this.rendered){
        
            var titleEl = this.getEl().child(this.TITLE);
    
            if (this.collapsible) {
                if (this.collapsed && this.hasIncorrectChildren) {
                    titleEl.addClass(this.ERROR_CLASS);
                    if (this.collapsedTitleEl) {
                        this.collapsedTitleEl.addClass(this.ERROR_CLASS);
                    }
    
                } else {
                    titleEl.removeClass(this.ERROR_CLASS);
                    if (this.collapsedTitleEl) {
                        this.collapsedTitleEl.removeClass(this.ERROR_CLASS);
                    }
                }
    
            }
        }

    },

    /**
     * Retorna o elemento do header do painel do BorderLayout quando o painel est em modo collapse
     * @returns 
     */
    getCollapseEl : function() {
        return Ext.get(this.getId() + '-xcollapsed');
    },

    /**
     * Aplica estilo do collapsedEl do painel no borderLayout, isso  necessrio porque o header collapsedel ainda no existe 
     * quando o painel j  renderizado com estilo customizado.
     */
    applyCollapsedElStyles : function() {
        if (this.stylesToApply.length > 0) {
            this.updateHeaderBackgroundStyle(this.stylesToApply, true);
            this.stylesToApply = [];
        }
    },

    /**
     * 
     */
    applyCollapsedElStylesText : function() {
        if (this.stylesTextToApply.length > 0) {
            this.updateTitleFontStyle(this.stylesTextToApply, true);
            this.stylesTextToApply = [];
        }
    },

    /**
     * Define se vai mostrar ou esconder o boto de collapsar/expandir um painel. 
     * @param show true para mostrar o boto.
     */
    setShowCollapseButton : function(show) {
        this.tools.toggle[show ? "removeClass" : "addClass"]("x-senior-displaynone");

        var collapsedEl = this.getCollapseEl();
        if (collapsedEl) { // caso esteja em um BorderLayout...
            collapsedEl.child(this.COLLAPSE_BUTTON)[show ? "removeClass" : "addClass"]("x-senior-displaynone");
        }
    }

});

Ext.reg('seniorpanel', Ext.ux.senior.Panel);
