Ext.namespace('Ext.ux.senior');

/**
 * Componente Link, descrio do componente no caso de uso: UC-FRC-0076 - Operar Button.xucs, tipo Link Button
 * 
 * @author Jean.Kirchner
 */
Ext.ux.senior.Link = Ext.extend(Ext.BoxComponent, {

    template : null,
    iconEl : null,
    linkEl : null,

    /**
     * @private
     */
    buildTemplate : function() {
        if (!Ext.ux.senior.Link.template) {
            Ext.ux.senior.Link.template = new Ext.Template("<table cellspacing='0' class='senior-link' id={id}>", "<tbody>", "<tr><td><div></div></td>",
                    "<td class='senior-link-content'><a>{text}</a></td></tr>", "</tbody></table>");
            Ext.ux.senior.Link.template.compile();
        }
        this.template = Ext.ux.senior.Link.template;
    },

    /**
     * @override
     */
    initComponent : function() {
        Ext.ux.senior.Button.superclass.initComponent.call(this, arguments);
        this.buildTemplate();

        this.addEvents('click');
    },

    /**
     * @override
     */
    onRender : function(ct, position) {

        /**
         * Como no utilizamos um autoEl, temos que saber inserir no componente parent
         */
        if (position) {
            this.el = this.template.insertBefore(position, {
                id : this.id,
                text : this.text
            }, true);
        } else {
            this.el = this.template.append(ct, {
                id : this.id,
                text : this.text
            }, true);
        }

        /* Acha os elementos para futuras manipulaes */
        this.iconEl = this.el.child('td').child('div');
        this.linkEl = this.el.child('a');
        this.mon(this.el, {
            scope : this,
            focus : this.onFocus,
            blur : this.onBlur
        });

        this.setIcon(this.icon);

        this.el.on('click', this.onClick, this);
    },

    /**
     * @override
     */
    afterRender : function() {
        Ext.ux.senior.Link.superclass.afterRender.apply(this);
    },

    /**
     * @private
     * Adiciona ao redor do link um retngulo pontilhado para apresentar visualmente o foco no link
     */
    onFocus : function() {
        this.el.setStyle('border', '1px dotted black');
    },

    /**
     * @private
     * Remove do link, que estava focado, o retngulo pontilhado que representa visualmente o foco no link
     */
    onBlur : function() {
        this.el.setStyle('border', '1px dotted transparent');
    },

    /**
     * Preparo de dados para enviar para o servidor
     * @plugin EventManagerPlugin
     */
    eventMapping : function() {
        return {
            click : this.prepareClickData
        };
    },

    /**
     * @event click
     */
    prepareClickData : function() {
        return {
            type : 'clicked',
            target : -1
        };
    },

    /**
     * Eventos do componente
     * @event this.el.click
     */
    onClick : function(ev) {
        /* para click de link no ser processado, e dar um reload na pgina */
        ev.stopEvent();
        
        if (this.blockIntf) {
            this.blockInterface();
        }
        
        this.fireEvent('click', this, ev);
    },

    /**
     * Bloqueia a inteface
     * 
     * @private
     */
    blockInterface : function() {
        ScreenManager.blockScreen("Processando...", true);
    },
    
    /**
     * @public
     */
    setIcon : function(uri) {
        if (uri && uri != "") {
            this.iconEl.setStyle('background-image', 'url(' + uri + ')');
            this.iconEl.addClass('senior-link-icon');
        } else {
            this.iconEl.setStyle('background-image', '');
            this.iconEl.removeClass('senior-link-icon');
        }
    },

    /**
     * @public
     */
    setText : function(text) {
        this.linkEl.update(text);
    },
    
    getStyleEl : function(scope) {
    	var property = scope.split("$");
    	if (property[1].indexOf("font") > -1) {
    		return this.getEl().child('td.senior-link-content a');
    	}
        return Ext.ux.senior.Link.superclass.getStyleEl.call(this, scope);
    }

});

Ext.reg('seniorlink', Ext.ux.senior.Link);
