Ext.namespace('Ext.ux.senior');

/**
 * Componente imagem, descrio do componente no caso de uso: 
 * 
 * UC-FRC-0067 - Operar Imagem.xucs
 * 
 * No momento mapeamento de areas e upload conforme requisitos no sero suportados.
 * 
 * @author Jean.Kirchner
 */
Ext.ux.senior.Image = Ext.extend(Ext.BoxComponent, {

    autoEl : {
        tag : 'div'
    },
    /* Quando a imagem esta sem permisso de leitura*/
    imageLocked : false,
    image : null,
    
    internalImageWidth : 0,
    internalImageHeight : 0,

    /**
     * Construtores
     * 
     * @override
     */
    initComponent : function() {
        Ext.ux.senior.Button.superclass.initComponent.call(this, arguments);
        this.addEvents('load', 'click');
    },

    /**
     * @plugin EventManagerPlugin
     */
    eventMapping : function() {
        return {
            click : this.prepareClickData
        };
    },

    /**
     * @event click
     */
    prepareClickData : function() {
        return {
            type : 'clicked'
        };
    },

    /**
     * Eventos
     * 
     * @override
     */
    onRender : function() {
        Ext.ux.senior.Image.superclass.onRender.apply(this, arguments);

        var template = new Ext.Template('<img id="{id}" src="{uri}" style="vertical-align: top; {dimensions}">');
        template.compile();
        this.image = template.append(this.el, {id: this.getId() + '_image', uri: this.getImageURI(), dimensions: this.getImageDimensions()}, true);
        
        this.internalImageWidth = -1;
        this.internalImageHeight = -1;
        
        this.forceLoadImageIE9();
        
        if (this.imageLocked) {
            this.addClass('x-locked-image');
        } else {            
            this.image.on('load', this.onLoad, this);
            this.el.on('click', this.onClick, this);
    
            this.updateStretchState();
            this.updateAltText(this.altText);
        }
    },

    forceLoadImageIE9 : function() {
        // No IE9, caso a imagem esteja dentro de uma DIV com "display: none" ela  carregada, porm o width e height no so calculados, ficando 0.
        // Por isso carregamos uma nova imagem em memria para ter o tamanho certo calculo
        // Tarefa 414698
        if (Ext.isIE9) {
            var img = new Image();
            img.imageComponent = this;
            img.onload = function() {
                this.imageComponent.internalImageWidth = img.width;
                this.imageComponent.internalImageHeight = img.height;
                this.imageComponent.updateDivSize();
            };
            img.src = this.getImageURI();
        }
    },
    
    /**
     * @event this.el.load
     */
    onLoad : function() {
        this.fireEvent('load', this, arguments[0]);
        this.updateDivSize();
    },
    
    onShow : function() {
        Ext.ux.senior.Image.superclass.onShow.apply(this, arguments);
        this.updateDivSize();
    },

    /**
     * @event this.el.click
     */
    onClick : function() {
        this.fireEvent('click', this, arguments[0]);
    },

    /**
     * @event resize
     */
    onResize : function(width, height) {
        this.updateImageSize(width, height);
    },

    /**
     * @public
     */
    updateImageURI : function(src) {
        this.imageURI = src;
        if (this.rendered) {
            this.image.dom.src = this.getImageURI();
            this.forceLoadImageIE9();
        }
    },
    
    getImageURI : function() {
        if (!!this.imageURI) {
            return this.imageURI;
        } else {
            return Ext.BLANK_IMAGE_URL;
        }
    },
    
    updateDivSize : function() {
        if (!Ext.isIE9) {
            this.internalImageWidth = this.image.dom.width;
            this.internalImageHeight = this.image.dom.height;
        }
        if (!this.width || ((!this.isStretch) && this.width > this.internalImageWidth)) {
            this.el.setWidth(this.internalImageWidth);              
        }
        if (!this.height || ((!this.isStretch) && this.height > this.internalImageHeight)) {
            this.el.setHeight(this.internalImageHeight);              
        }
    },
    
    needStretch : function() {
        return this.isStretch && !this.imageLocked;
    },

    /**
     * @public
     */
    updateStretchState : function() {
        if (!this.needStretch()) {
            this.el.dom.style.overflow = "hidden";
        }
    },
    
    updateImageSize : function(width, height) {
        if (this.needStretch()) {
            if (width) {
                this.image.setWidth(width);              
            }
            if (height) {
                this.image.setHeight(height);
            }    
        }
    },
    
    getImageDimensions : function() {
        var result = '';
        if (this.needStretch()) {
            if (this.width) {
                result = 'width: ' + this.width + 'px; ';              
            }
            if (this.height) {
                result += 'height: ' + this.height + 'px; ';
            }    
        }
        return result;
    },
    
    updateAltText : function(text) {
        if (this.altText) {
            this.image.dom.alt = this.altText;
        }
    },

    getStyleEl : function(scope, toAdd) {
        var styleScope = scope.split('$')[0];

        if (styleScope == "label") {
            return this.label;
        }
        return Ext.ux.senior.Image.superclass.getStyleEl.call(this, scope);

    }

});

Ext.reg('seniorimage', Ext.ux.senior.Image);
