Ext.namespace('Ext.ux.senior');

/**
 * @author Janana Mendona
 */
Ext.ux.senior.GroupBox = Ext.extend(Ext.form.FieldSet, {

            initCollapsed : false,
            loaded : false,
        
            /**
             * @Override
             */
            render : function(container, position) {
                var ret = Ext.ux.senior.GroupBox.superclass.render.call(this, container, position);

                //Informa que o groupbox iniciou colapsado
                this.initCollapsed = this.collapsed;
            
                return ret;
            },
            
			getStyleEl : function(scope) {
				// scope  formado pelo escopo$propriedade, ex:
				// groupbox$font-color.
				var property = scope.split("$");
				if (property[1].indexOf('font') > -1) {
					return this.getEl().child('legend');
				} else {
					return Ext.ux.senior.GroupBox.superclass.getStyleEl.call(
							this, scope);
				}
			},

			/**
			 * @plugin EventManagerPlugin
			 */
			eventMapping : function() {
				return {
					collapse : this.prepareChangeEventData,
					expand : this.prepareChangeEventData
				};
			},
		    
			/**
		     * 
		     * @param p
		     * @param eOpts
		     */
		    expand : function(p, eOpts) {
		        Ext.ux.senior.Panel.superclass.expand.call(this, p, eOpts);
		        if (this.initCollapsed && !this.loaded) {
		            this.doLayout();
		            this.loaded = true;
		        }
		    },
		    
			/**
			 * @private
			 */
			prepareChangeEventData : function() {
				return {
					type : 'collapse',
					value : this.collapsed
				};
			}

		});
Ext.reg('seniorgroupbox', Ext.ux.senior.GroupBox);