Ext.namespace('Ext.ux.senior');

/**
 * DatePicker Senior<br>
 * 
 * Esta implementao atende alguns requisitos e caso de uso conforme segue: UC-FRC-0085 - Operar Calendrio <br>
 * 
 * Ext.ux.senior.DatePicker: <br>
 * REQ0001, REQ0002, REQ0003, REQ0004, REQ0008, REQ0013, REQ0014, REQ0016, REQ0019, REQ0012, REQ0017 <br>
 * 
 * Ext.DatePicker: <br>
 * REQ0020, REQ0009, REQ0010, REQ0015
 * 
 * Prov funcionalidades para mudanas na estrutura do DatePicker do ext, para atender os requisitos conforme acima.
 * 
 * Ao fazer alteraes e atualizaes deste componente, sempre deve-se chamar o mtodo #refresh ao final
 * 
 * @author Jean.Kirchner
 */
Ext.ux.senior.DatePicker = Ext.extend(Ext.DatePicker, {

    firstDayToShow : null,
    stylesToUpdate : null,
    realValue : null,
    readOnly : false,
    selectedDates : null,
    changedDays : null,
    focusedDateAux : null,
    showNavigation : false,
    selectionMode : "SINGLE",
    maxDate : null,
    minDate : null,

    /**
     * Inicializao de componente
     * 
     * @protected
     * @override
     */
    initComponent : function() {
        this.realValue = this.value;
        this.stylesToUpdate = {};
        this.selectedDates = [];
        this.changedDays = [];

        Ext.ux.senior.DatePicker.superclass.initComponent.call(this, arguments);

        this.value = this.realValue == null ? null : this.value;

        /* Adiciona eventos de navegao no calendrio */
        this.addEvents('prevMonth', 'nextMonth', 'prevYear', 'nextYear', 'navigate');

        this.setStyles(this.styles);
        if ((this.selections == null || this.selections.length == 0) && this.value != null) {
            this.selections[0] = this.dateFormat(this.value);
        }
        this.setSelections(this.selections);
        this.setChangedDates(this.changedDates);

        delete this.styles;
        delete this.selections;

        this.on('select', this.onSelect, this);
    },

    /**
     * @protected
     * @override
     */
    onRender : function(ct, pos) {

        Ext.ux.senior.DatePicker.superclass.onRender.call(this, ct, pos);
        this.doc = Ext.isIE ? Ext.getBody() : Ext.getDoc();
        this.doc.on('mousedown', this.mimicBlur, this);
        
        this.removeClickRepeaters();
        this.on('enable', this.removeClickRepeaters, this);

        /* Selees de dias */
        this.updateStyles();

        this.keyNav.left = this.leftDayNav;
        this.keyNav.right = this.rightDayNav;
        this.keyNav.up = this.upDayNav;
        this.keyNav.down = this.downDayNav;

        this.el.on('keydown', function(evt) {
            this.mimicBlur(evt);
        }, this);

        this.setNavigationBarStyle();

        var classLinks = this.el.query('.x-date-picker .x-unselectable');
        Ext.each(classLinks, function(item, index) {
            item.removeAttribute("href");
        });
    },
    
    removeClickRepeaters : function() {
        var prevMonth = this.el.child('td.x-date-left a');
        var nextMonth = this.el.child('td.x-date-right a');

        prevMonth.removeAllListeners();
        nextMonth.removeAllListeners();
        prevMonth.on('click', this.showPrevMonth, this);
        nextMonth.on('click', this.showNextMonth, this);
    },

    /**
     * Informa a data atual para este calendrio
     * 
     * @override
     * @public
     */
    setValue : function(value) {
        if (this.readOnly) {
            return;
        }

        this.value = value != null ? value.clearTime(true) : value;

        /* no altera o ms */
        this.mpSelYear = value != null ? this.value.getFullYear() : this.mpSelYear;
        this.mpSelMonth = value != null ? this.value.getMonth() : this.mpSelMonth;
        this.realValue = value != null ? this.value : null;

        if (value == null && this.activeDate == null) {
            this.activeDate = this.dateRefStart;
        }
    },

    /**
     * Informa se o calendrio  readOnly
     * 
     * @pubilc
     */
    setReadOnly : function(value) {
        this.readOnly = value;
    },

    /**
     * Informa se o calendrio pode navegar entre meses e anos
     * 
     * @public
     */
    setShowNavigation : function(value) {
        this.showNavigation = value;
        this.setNavigationBarStyle();
    },

    /**
     * @private
     * Altera o estilo da barra de navegao do calendrio para apresentar visualmente que a barra est habilitada ou desabilitada.
     */
    setNavigationBarStyle : function() {
        if (!this.showNavigation) {
            this.el.child('td.x-date-middle').parent().addClass(this.disabledClass);
        } else {
            this.el.child('td.x-date-middle').parent().removeClass(this.disabledClass);
        }
    },

    /**
     * Retorna o valor da data deste calendrio
     * 
     * @override
     * @public
     */
    getValue : function() {
        return this.realValue;
    },

    /**
     * Funo chamada pelo ext, quando vai mostrar a lista para escolher meses e anos.
     * 
     * @override
     */
    showMonthPicker : function() {
        this.focusedDateAux = this.focusedDate;
        if (this.showNavigation) {
            Ext.ux.senior.DatePicker.superclass.showMonthPicker.call(this, arguments);
        }
    },

    /**
     * Para disparar evento
     * 
     * @override
     * @protected
     */
    showPrevMonth : function(e, me, isCorrectDate) {
        if (isCorrectDate && this.focused) {
            this.fireEvent('prevMonth', e);
        } else {
            if (this.showNavigation) {
                this.focused = this.activeDate.add(Date.MONTH, -1);
                this.fireEvent('prevMonth', e);
            }
        }
    },
    /**
     * Para disparar evento
     * 
     * @override
     * @protected
     */
    showNextMonth : function(e, me, isCorrectDate) {
        if (isCorrectDate && this.focused) {
            this.fireEvent('nextMonth', e);
        } else {
            if (this.showNavigation) {
                this.focused = this.activeDate.add(Date.MONTH, 1);
                this.fireEvent('nextMonth', e);
            }
        }
    },

    /**
     * Para disparar evento
     * 
     * @override
     * @protected
     */
    showPrevYear : function() {
        if (this.showNavigation) {
            this.focused = this.activeDate.add(Date.YEAR, -1);
            this.fireEvent('prevYear');
        }
    },

    /**
     * Para disparar evento
     * 
     * @override
     * @protected
     */
    showNextYear : function() {
        if (this.showNavigation) {
            this.focused = this.activeDate.add(Date.YEAR, 1);
            this.fireEvent('nextYear');
        }
    },

    /**
     * @overide, sobrescripto para cancelar o evento de seleo ms/ano
     */
    onMonthClick : function(e, t) {
        e.stopEvent();
        var el = new Ext.Element(t), pn;
        if (el.is('button.x-date-mp-cancel')) {
            this.hideMonthPicker(false);
        } else if (el.is('button.x-date-mp-ok')) {
            var d = new Date(this.mpSelYear, this.mpSelMonth, (this.activeDate || this.value).getDate());
            if (d.getMonth() != this.mpSelMonth) {
                /* 'fix' the JS rolling date conversion if needed */
                d = new Date(this.mpSelYear, this.mpSelMonth, 1).getLastDateOfMonth();
            }
            this.update(d);
            this.hideMonthPicker(true);
        } else if ((pn = el.up('td.x-date-mp-month', 2))) {
            this.mpMonths.removeClass('x-date-mp-sel');
            pn.addClass('x-date-mp-sel');
            this.mpSelMonth = pn.dom.xmonth;
        } else if ((pn = el.up('td.x-date-mp-year', 2))) {
            this.mpYears.removeClass('x-date-mp-sel');
            pn.addClass('x-date-mp-sel');
            this.mpSelYear = pn.dom.xyear;
        } else if (el.is('a.x-date-mp-prev')) {
            this.updateMPYear(this.mpyear - 10);
        } else if (el.is('a.x-date-mp-next')) {
            this.updateMPYear(this.mpyear + 10);
        }
    },

    /**
     * @overide, sobrescrito para cancelar o evento de seleo ms/ano
     */
    onMonthDblClick : function(e, t) {
        e.stopEvent();
        var el = new Ext.Element(t), pn;
        if ((pn = el.up('td.x-date-mp-month', 2))) {
            this.update(new Date(this.mpSelYear, pn.dom.xmonth, (this.activeDate || this.value).getDate()));
            this.hideMonthPicker(true);
        } else if ((pn = el.up('td.x-date-mp-year', 2))) {
            this.update(new Date(pn.dom.xyear, this.mpSelMonth, (this.activeDate || this.value).getDate()));
            this.hideMonthPicker(true);
        }
    },

    /**
     * Para disparar evento
     * 
     * @override
     * @protected
     */
    hideMonthPicker : function(pressOK) {
        Ext.ux.senior.DatePicker.superclass.hideMonthPicker.call(this, arguments);
        if (pressOK) {
            var d = new Date(this.mpSelYear, this.mpSelMonth, 1);
            this.fireEvent('navigate', d);
        } else {
            this.updateVisibleDays(this.focusedDateAux);
        }
    },

    /**
     * @override
     * @protected
     */
    update : function(date, preventFocus) {
        /* this.activeDate = date != null ? date : this.dateRefStart; */
        this.activeDate = this.getFocusDate(date);
        date = date != null ? date : this.activeDate;
        this.cells.removeClass('x-date-selected');
        this.updateVisibleDays(date, preventFocus);
    },

    /**
     * Encontrar a data focada. Caso for <code>null</code>, Verifica se existe uma data selecionada no ms, caso no existir seta o primeiro dia do ms como focado.
     * 
     * @private
     */
    getFocusDate : function(date) {
        var dateRet = null;
        if (date != null) {
            dateRet = date;
        } else {
            var selectedDates = this.getSelectionsDays();
            var newDate = null;
            for ( var i = 0; i < selectedDates.length; i++) {
                newDate = Date.parseDate(selectedDates[i], "j/n/Y");
                if (this.dateRefStart <= newDate && this.dateRefEnd >= newDate) {
                    dateRet = newDate;
                    break;
                }
            }
            if (dateRet == null) {
                dateRet = this.dateRefStart;
            }
        }
        return dateRet;
    },

    /**
     * Verifica se a data passada est alterada. 
     * @private
     */
    isChangedDate : function(date) {
        for ( var i = 0; i < this.changedDays.length; i++) {
                if (this.isSameDate(this.convertDate(this.changedDays[i]), date)) {
                return true;
            }
        }
        return false;
    },

    /**
     * REQ0013, REQ0016
     * 
     * @param date Data que deve passar a ser ativa no calendrio.
     * @param preventFocus Se for <code>true</code> indica que no deve focar o elemento da data ativa.
     * 
     * @private
     */
    updateVisibleDays : function(date, preventFocus) {
        /* se a data ativa no nos dias que aparecem no calendrio seta a data refStart */
        if (this.activeDate && !(this.dateRefStart <= this.activeDate && this.dateRefEnd >= this.activeDate)) {
            if (this.focused && !(this.dateRefStart <= this.focused && this.dateRefEnd >= this.focused)) {
                this.activeDate = this.focused;
            }
            this.activeDate = date;
        }

        /*
         * Se ainda no foi renderizado no tem o que ser atualizado
         */
        if (!this.rendered) {
            return;
        }

        /*
         * Atualiza o ttulo conforme mscara configurada no servidor
         */
        var month = this.monthNames[this.activeDate.getMonth()];
        var year = this.activeDate.getFullYear();
        var title = this.title.replace("${MONTH}", month).replace("${YEAR}", year);

        // O CSS "text-overflow: ellipsis" no funciona em botes no Chrome.
        // Mas funciona em uma div dentro de um boto.
        if (Ext.isChrome || Ext.isSafari) {
            title = '<div class="x-datepicker-text-size">' + title + '</div>';
        }

        this.mbtn.setText(title, false);
        this.mbtn.btnEl.addClass('x-datepicker-text-size');

        /*
         * Se no tiver dia de referncia inicial no atualiza o calendrio
         */
        if (!this.firstDayToShow) {
            return;
        }

        var isVisible = this.isVisible();
        var today = new Date();
        var min = this.minDate ? this.minDate.clearTime(true) : Number.NEGATIVE_INFINITY;
        var max = this.maxDate ? this.maxDate.clearTime(true) : Number.POSITIVE_INFINITY;
        var ddMatch = this.disabledDatesRE;
        var ddText = this.disabledDatesText;
        var ddays = this.disabledDays ? this.disabledDays.join('') : false;
        var ddaysText = this.disabledDaysText;
        var format = this.format;
        var selected = this.value != null ? this.value : null;
        var focused = date;

        /* funo para atualizao de estilos */
        var setCellClass = function(cal, cell, incDate, preventFocus) {
            cell.title = '';

            var currentDate = incDate.clearTime(true);

            /* Joga o valor da data na clula */
            var first = cell.firstChild;
            first.dateValue = currentDate;

            cell = Ext.get(cell);

            /*
             * Se for a clula do dia de hoje, coloca um marcador
             */
            if (cal.isSameDate(currentDate, today)) {
                cell.addClass('x-date-today');
                cell.title = cal.todayText;
            }

            /*
             * Se for a clula do dia selecionado, adiciona estilo de selecionado
             */
            if ((selected && cal.isSameDate(currentDate, selected)) || (cal.selectedDates && cal.selectedDates.indexOf(incDate.format('j/n/Y')) != -1)) {
                cell.addClass('x-date-senior-selected');
            }

            /* se for a data focada */
            if (cal.isSameDate(currentDate, focused)) {
                if (!preventFocus) {
                    cell.addClass('x-date-selected');
                    cal.focusedDate = focused;
                    if (isVisible) {
                        /*
                         * Como mudamos a ordem das clulas pelo dateRef, ns mesmos somos obrigados a setar o foco no cara certo. O 50, no  nenhum
                         * nmero mgico, e sim o mesmo nmero que o ext utiliza para setar o foco, mas se colocarmos menor, o nosso vai ser feito antes,
                         * e vai prevalecer o foco do Ext. OU seja, com isto, vai existir um bug, que quando o usurio navegar e apertar o enter para
                         * selecionar a data antes dos 50 milisegundos, ou no vai selecionar nenhuma (bug do ext por causa deste timeout), ou vai
                         * selecionar o do ext, ou executar antes (pois mudamos o foco depois de renderizar, e o ext coloca foco logo aps a seleo, o
                         * seja, da tempo para o erro acontecer).
                         */
                        Ext.fly(first).focus(50);
                    }
                }
            }

            /*Se a data est alterada, adiciona a classe css que contm a imagem do 'doritos'.*/
            if (cal.isChangedDate(currentDate)) {
                cell.addClass('x-date-changed');
            }

            /*
             * Desabilita as datas menor que o mnimo configurado
             */
            if (currentDate < min) {
                cell.addClass('x-date-disabled');
                cell.title = cal.minText;
                return;
            } else {
                cell.removeClass('x-date-disabled');
            }

            /*
             * Desabilita as datas maior que o mximo configurado
             */
            if (currentDate > max) {
                cell.addClass('x-date-disabled');
                cell.title = cal.maxText;
                return;
            } else {
                cell.removeClass('x-date-disabled');
            }

            /* Se for para desabilitar os dias */
            if (ddays) {
                if (ddays.indexOf(incDate.getDay()) != -1) {
                    cell.title = ddaysText;
                    cell.addClass('x-date-disabled');
                }
            }
        };

        var cells = this.cells.elements;
        var textEls = this.textNodes;

        /* Pega o dia da semana */
        var day = this.firstDayToShow.getDay();

        /* coloca para o primeiro dia da semana */
        var incDate = this.firstDayToShow.add(Date.DAY, -day);
        /*
         * Atualiza os dias das clulas do calendrio, fixo para 42 dias
         */
        for ( var i = 0; i < 42; i++) {
            textEls[i].innerHTML = incDate.getDate();
            cells[i].className = 'x-date-active';
            cells[i].date = incDate.clearTime(true);
            setCellClass(this, cells[i], incDate, preventFocus);
            incDate = this.getNextDay(incDate);
        }

    },

    getNextDay : function(date) {
        var day = date.getDayOfYear();
        var newDate = date.add(Date.DAY, 1);
        if (newDate.getDayOfYear() == day) {
            newDate = newDate.add(Date.DAY, 1).clearTime();
        }
        return newDate.clearTime();
    },

    /**
     * @private
     */
    leftDayNav : function(ev) {
        if (ev.ctrlKey) {
            this.showPrevMonth(ev, null, false);
        } else {
            this.dayNav(Date.DAY, -1, ev);
        }
    },

    /**
     * @private
     */
    rightDayNav : function(ev) {
        if (ev.ctrlKey) {
            this.showNextMonth(ev, null, false);
        } else {
            this.dayNav(Date.DAY, 1, ev);
        }
    },

    /**
     * @private
     */
    upDayNav : function(ev) {
        if (ev.ctrlKey) {
            this.showNextYear();
        } else {
            this.dayNav(Date.DAY, -7, ev);
        }
    },

    /**
     * @private
     */
    downDayNav : function(ev) {
        if (ev.ctrlKey) {
            this.showPrevYear();
        } else {
            this.dayNav(Date.DAY, 7, ev);
        }
    },

    /**
     * @private
     */
    onSelect : function(datepicker, date) {
        if (!this.readOnly) {
            delete this.focused;
            this.activeDate = date.clearTime(true);
        }
    },

    /**
     * Navega para o dia, conforme configuraes passadas como parmetro
     * 
     * @param {String} interval tipo de intervalo no qual se deseja fazer o incremento/decremento do valor.
     * @param {Number} value valor a ser incrementado/decrementado da data focada atualmente
     * 
     * @see Ext.Date para verificar as constantes de intervalo aceitas pela funo
     * 
     * @private
     */
    dayNav : function(interval, value, e) {
        var old = this.activeDate;
        this.activeDate = this.activeDate.add(interval, value);
        this.focused = this.activeDate;

        if (this.dateRefStart && this.dateRefStart > this.activeDate) {
            this.showPrevMonth(e, null, true);
        } else if (this.dateRefEnd && this.dateRefEnd < this.activeDate) {
            this.showNextMonth(e, null, true);
        } else {
            this.updateVisibleDays(this.activeDate.add(Date.HOUR, 2));
        }

        if (this.selectionMode != "SINGLE") {
            if (e.shiftKey) {
                this.setValue(new Date(this.activeDate));
                this.fireEvent('select', this, this.value);
            }
        }

    },

    /**
     * Verifica se o ms de ambas as datas so o mesmo. Para um ms ser considerado
     * igual ao outro  necessrio que a data seja do mesmo ano.
     * 
     * Ex. 1(retorna false):
     * dateA - 01/12/2010
     * dateB - 05/12/2011
     * 
     * Ex. 2(retorna true):
     * dateA - 15/04/2010
     * dateB - 25/04/2010
     * 
     * @returns true caso as datas sejam do mesmo ms, false caso contrrio
     */
    isSameMonth : function(dateA, dateB) {
        return dateA.getMonth() == dateB.getMonth() && dateA.getFullYear() == dateB.getFullYear();
    },

    /**
     * @private
     */
    dateConf : function(date) {
        date = this.convertDate(date);
        var conf = this.stylesToUpdate[date];
        if (!conf) {
            conf = {
                style : null
            };
        }
        this.stylesToUpdate[date] = conf;
        return conf;
    },

    /**
     * @private
     */
    setStyle : function(date, style) {
        var conf = this.dateConf(date);
        conf.style = style;
    },

    /**
     * @public
     */
    setFirstDayToShow : function(dateRef) {
        this.firstDayToShow = dateRef;
    },

    /**
     * @public
     */
    clearStyles : function() {
        delete this.stylesToUpdate;
        this.stylesToUpdate = {};
    },
    
    /**
     * @public
     */
    clearSelectedDates : function() {
        delete this.selectedDates;
    },

    /**
     * @public
     */
    setStyles : function(obj) {
        for ( var x in obj) {
            var style = obj[x];
            this.setStyle(x, style);
        }
    },

    /**
     * Seleciona as datas correspondentes
     * 
     * @public
     */
    setSelections : function(dates) {
        this.selectedDates = dates;
        for ( var i = 0; i < dates.length; i++) {
            this.setStyle(dates[i], "x-date-selected x-date-senior-selected");
        }
    },

    /**
     * Guarda as datas alteradas para adicionar a imagem do 'doritos' nas datas.
     * @public
     */
    setChangedDates : function(dates) {
        this.changedDays = dates;
    },

    /**
     * Retorna os dias selecionados
     * 
     * @public
     */
    getSelectionsDays : function() {
        return this.selectedDates;
    },

    /**
     * @private
     */
    updateCellStyles : function(cell) {

        /* pega a data de uma clula */
        var cellDate = cell.firstChild.dateValue || {};
        
        /* pega os estilos da clula */
        var dateUpdate = this.stylesToUpdate[this.getCellDateUTCTime(cellDate)];

        /*
         * se no houver estilo para esta clula vai para a prxima
         */
        if (!dateUpdate) {
            return;
        }

        var a = Ext.get(cell).child('a');
        var span = Ext.get(cell).child('span');

        if (cell.old) {
            var style = cell.old.style;

            if (style) {
                a.removeClass(style);
                span.removeClass(style);
            }

        }

        if (dateUpdate.style == "") {
            cell.old = null;
        } else {
            /* atualiza a clula */
            cell.old = {
                style : dateUpdate.style
            };

            if (dateUpdate.style) {
                a.addClass(dateUpdate.style);
                span.addClass(dateUpdate.style);
            }
        }

    },

    /**
     * @private
     */
    updateStyles : function() {
        var cells = this.cells.elements;
        for ( var i = 0; i < cells.length; i++) {
            var cell = cells[i];
            this.updateCellStyles(cell);
        }
    },

    /**
     * Define o ms visvel atualmente neste calendrio.
     *
     * @param year ano que deve ser exibido por este calendrio, representado por quatro dgitos.
     * @param month ms que deve ser exibido por este calendrio.
     */
    setCalendarMonth : function(year, month) {
        var date = new Date(year, month - 1, 1).clearTime();
        this.mpSelYear = date.getFullYear();
        this.mpSelMonth = date.getMonth();
    },

    /**
     * @public
     */
    setMonthNames : function(names) {
        this.monthNames = names;
    },

    /**
     * @public
     */
    setTitle : function(title) {
        this.title = title;
    },

    /**
     * @public
     */
    refresh : function(preventFocus) {
        var d = this.value || this.activeDate;
        var date = new Date(this.mpSelYear, this.mpSelMonth, d.getDate());
        this.updateVisibleDays(this.getCellDateUTCTime(date), preventFocus);
        this.updateStyles();
    },

    /**
     * @overide
     */
    setMaxDate : function(dt) {
        this.maxDate = dt;
        this.update(this.value, true);
    },

    /**
     * @overide
     */
    setMinDate : function(dt) {
        this.minDate = dt;
        this.update(this.value, true);
    },

    focus : function() {
        if (this.focused) {
            this.activeDate = this.focused.add(Date.HOUR, 2);
            delete this.focused;
        }
        this.updateVisibleDays(this.activeDate);
        this.activeDate.clearTime();
    },

    /**
     * 
     * Simula o efeito de blur do usurio sobre o componente. Tem o mesmo funcionamento
     * que o mimicBlur utilizado no TriggetField do Ext
     * 
     * @param evt evento de blur disparado pela pgina
     */
    mimicBlur : function(evt) {
        if (evt.getKey() == evt.TAB || !this.isDestroyed && !this.getEl().contains(evt.target)) {
            this.cells.removeClass('x-date-selected');
            this.focusedDate = null;
            this.focused = null;

            /* se existe ao menos uma data selecionada o foco vai para a primeira*/
            if (this.selectedDates.length > 0) {
                this.activeDate = this.convertDate(this.selectedDates[this.selectedDates.length - 1]);
            } else {
                /*seno exibe o dia padro*/
                this.activeDate = this.dateRefStart;
            }
            this.fireEvent('blur', this);
        }
    },

    /**
     * 
     * Converte a data passada como parmetro em um objeto Date
     * 
     * @param date {String} data no formato dd/mm/aaaa
     * @returns {Date} objeto data correspondete
     */
    convertDate : function(date) {
        var d = date.split("/");
        var timestamp = Date.UTC(d[2], d[1] - 1, d[0]);
        var timeZoneOffset = this.getTimeZoneOffsetMillis(timestamp);
        return new Date(timestamp + timeZoneOffset);
    },

    /**
     * @override
     */
    onDestroy : function() {
        this.doc.un('mousedown', this.mimicBlur, this);
        Ext.ux.senior.DatePicker.superclass.onDestroy.apply(this, arguments);
    },

    /**
     * 
     * Verifica se as datas passadas como parmetro so equivalentes
     * 
     * @returns <code>true</code> caso as datas sejam equivalentes, <code>false</code> caso contrrio
     */
    isSameDate : function(dateA, dateB) {
        if (dateA == null && dateB == null) {
            return true;
        }
        if (dateA == null || dateB == null) {
            return false;
        }
        var dayA = dateA.getDayOfYear();
        var dayB = dateB.getDayOfYear();
        var yearA = dateA.getFullYear();
        var yearB = dateB.getFullYear();
        return dayA == dayB && yearA == yearB;
    },

    /**
     * Formata a data no padro utilizado no server dia/mes/ano
     */
    dateFormat : function(date) {
        return (date == null || date == "") ? "" : date.format("d/m/Y");
    },
    
    getTimeZoneOffsetMillis : function(dateMillis){
        var date = new Date(dateMillis);
        return date.getTimezoneOffset() * 60000;
    },
    
    getCellDateUTCTime : function(date){
        var cellDateConverted = Date.UTC(date.getFullYear(), date.getMonth(), date.getDate());
        var timeZoneOffset = this.getTimeZoneOffsetMillis(cellDateConverted);
        return new Date(cellDateConverted + timeZoneOffset);
    }

});

Ext.reg('seniordatepicker', Ext.ux.senior.DatePicker);