Ext.namespace('Ext.ux.senior.form');

Ext.ux.senior.form.DateField = Ext.extend(Ext.form.DateField, {

    enableKeyEvents : true,
    selectOnFocus : true,
    // no utilizamos validao do Ext, passando false otimiza por no gerar chamadas na classe base
    validationEvent : false,
    DEFAUTL_FIELD_WIDTH : 93,
    
    /**
     * Teclas de atalho tratadas por este componente
     * 
     * @plugin EventManagerPlugin
     */
    keyMapping : [ Ext.EventObject.F4, Ext.EventObject.F3, Ext.EventObject.DOWN ],
    
    initComponent : function() {
        Ext.ux.senior.form.DateField.superclass.initComponent.call(this, arguments);

        this.on("afterrender", this.onAfterRender, this);
        this.on("select", this.selectDate, this);
        this.addEvents('changeByCalendar');
        this.on("changeByCalendar", this.changeDateByCalendar, this);
        this.on("disable", this.onDisableEvent, this);
    },
    
    onResize : function(width, height) {
        Ext.ux.senior.form.DateField.superclass.onResize.call(this, width, height);

        var triggerWidth = this.getTriggerWidth();
        if (Ext.isNumber(width)) {
            this.el.setWidth(width - triggerWidth);
            this.trigger.setWidth(triggerWidth);
            if (this.customTrigger) {
                this.customTrigger.setWidth(triggerWidth);
            }
        }
        this.wrap.setWidth(width);
    },

	 validateBlur : function(e){
  		return !this.menu || !this.menu.isVisible() || !this.menu.getEl().dom.contains(e.target);
 	},
    
    render : function(container, position) {
        return Ext.ux.senior.form.DateField.superclass.render.call(this, container, position);
    },

    eventMapping : function() {
        return {
            change : this.changeDate,
            changeByCalendar : this.changeDateByCalendar
        };
    },

    onKeyEvent : function(keyCode, evt) {
        // Atualiza o valor inicial do edit, para que com isso no seja enviado um "change"
        // para o server sem ter alterado o valor do edit.
        if (this.startValue != this.getValue()) {
            this.startValue = this.getValue();
            this.fireEvent('change');
        }

        switch(keyCode){
            case Ext.EventObject.F4:
            case Ext.EventObject.F3:
                this.onTriggerClick();
            case Ext.EventObject.DOWN:
                evt.stopEvent();
                if (Ext.isIE) {
                    window.event.keyCode = 0;
                }
        }
        
        return {
            type : "keypressed"
        };
    },

    setUnformattedValue : function(value) {
        this.unformattedValue = value;
    },

    onAfterRender : function() {
        Ext.destroy(this.keyNav);
        /* Ajusta o tamanho do trigger quando esta em um painel colapsado
         * bug: http://www.sencha.com/forum/showthread.php?146819-Trigger-in-collapsed-panel*/
        if (!this.initialConfig.width && this.el && this.el.getWidth() == 0) {
            this.setWidth(this.DEFAUTL_FIELD_WIDTH);
        }
    },
    /**
     * Retorna uma data formatada caso conseguiu parsear corretamente ou o valor incorreto. Este mtodo, no Ext, estava retornando uma string vazia caso o valor corrente no fosse validado e isso
     * estava gerando problemas nos eventos de "change"
     * 
     * @override
     */
    getValue : function() {
        // se o trigger estiver sendo clicado, o getValue retorna a instncia de um Date
        // para ser setada no calendrio que ir abrir
        if (this.useunformattedValue) {
            var date;

            if (this.unformattedValue) {
                //se possuir o valor unformattedValue
                date = Date.parseDate(this.unformattedValue, this.format);
            } else {
                try {
                    //se no possuir, tenta pegar o valor formatado mesmo e passar na mscara...
                    date = Date.parseDate(Ext.form.DateField.superclass.getValue.call(this), this.format);
                } catch (e) {
                    //se ocorrer algum erro na formatao, pega a data atual
                    date = new Date();
                }
            }
            return date;
        }
        return Ext.form.DateField.superclass.getValue.call(this);
    },

    /**
     * Trata os evento de alterao
     * 
     * @params date valor do componente
     */
    changeDate : function() {
        var date = this.getRawValue();
        // setado null para unformattedValue pois esta varivel deve ser zerada sempre que uma requisio de 
        // change acontece. Se a resposta da requisio no retornar qualquer valor para "unformattedValue"  
        // por que ocorreu um erro e o campo ser marcado com erro.
        this.unformattedValue = null;
        return {
            type : 'changed',
            value : date
        };
    },

    changeDateByCalendar : function() {
        var date = this.getRawValue();
        // setado null para unformattedValue pois esta varivel deve ser zerada sempre que uma requisio de 
        // change acontece. Se a resposta da requisio no retornar qualquer valor para "unformattedValue"  
        // por que ocorreu um erro e o campo ser marcado com erro.
        return {
            type : 'changed',
            clientFormat : true,
            value : date
        };
    },

    selectDate : function() {
        this.fireEvent('changeByCalendar', this);
        return false;
    },
    
    /**
     * Ligado ao evento disable
     */
    onDisableEvent : function() {
        if (this.rendered && this.hasFocus) {
            Ext.form.TriggerField.superclass.onBlur.call(this);
        }
    },

    /**
     * @private
     */
    onFocus : function() {
            Ext.form.TriggerField.superclass.onFocus.call(this);
            if (!this.mimicing) {
                this.wrap.addClass(this.wrapFocusClass);
                this.mimicing = true;
                this.doc.on('mousedown', this.mimicBlur, this);
                if (this.monitorTab) {
                    this.on('specialkey', this.checkTab, this);
                }
            }
    },

    beforeBlur : Ext.emptyFn,

    setValue : function(date, fromServer) {
        if (this.isFromOnSelectEvent) {
            // quando a seleo da data  feita pelo calendrio, a data  convertida
            // num formato que o servidor conhea, sem formatao, para ento
            // converter o valor em uma data vlida (no serivdor) e a retornar no 
            // formato definido no servidor
            date = date.dateFormat(this.format);
            this.unformattedValue = null;
        }

        // chama o cdigo da classe pai do DateField do Ext (TriggerField)
        // pois no deve aplicar a formatao do valor informado como sendo
        // uma data
        var retorno = Ext.form.DateField.superclass.setValue.call(this, date);
        if (fromServer) {
            this.startValue = this.getValue();
        }

        return retorno;
    },

    /**
     * Runs all of NumberFields validations and returns an array of any errors. Note that this first runs TextField's validations, so the returned
     * array is an amalgamation of all field errors. The additional validation checks are testing that the date format is valid, that the chosen date
     * is within the min and max date constraints set, that the date chosen is not in the disabledDates regex and that the day chosed is not one of
     * the disabledDays.
     * 
     * @param {Mixed} value The value to get errors for (defaults to the current field value)
     * @return {Array} All validation errors for this field
     */
    getErrors : function(value) {
        //faz a validao do superclass do DateField do Ext pois a validao do DateField mesmo  feito no server e no no client
        var errors = Ext.form.DateField.superclass.getErrors.call(this, value);
        return errors;
    },

    onTriggerClick : function() {
        if (this.disabled || this.readOnly) {
            return;
        }
        this.useunformattedValue = true;
        try {
            // faz um defer para tentar receber o valor informado pelo usurio antes de abrir o picker
            Ext.ux.senior.form.DateField.superclass.onTriggerClick.call(this);
            
            var prevMonth = this.menu.picker.el.child('td.x-date-left a');
            var nextMonth = this.menu.picker.el.child('td.x-date-right a');

            prevMonth.removeAllListeners();
            nextMonth.removeAllListeners();
            prevMonth.on('click', this.menu.picker.showPrevMonth, this.menu.picker);
            nextMonth.on('click', this.menu.picker.showNextMonth, this.menu.picker);

        } finally {
            this.useunformattedValue = false;
        }
    },

    /**
     * @override
     */
    onSelect : function(m, d) {
        // marca a flag para identificar a troca de data pelo calendrio.
        // veja o comentrio no mtodo setValue
        this.isFromOnSelectEvent = true;
        try {
            Ext.ux.senior.form.DateField.superclass.onSelect.call(this, m, d);
        } finally {
            this.isFromOnSelectEvent = false;
        }
    },

    /**
    * @override
    * 
    * @param preventMark
    * @returns
    */
    isValid : function(preventMark) {
        var errors = this.getErrors();
        if (Ext.isArray(errors) && errors.length > 0) {
            return false;
        }
        return true;
    },

    setLabel : function(textLabel) {
        var labelSeparator = this.ownerCt.labelSeparator;
        this.label.update(textLabel + labelSeparator);
    },

    getStyleEl : function(scope) {
        var properties = scope.split('$');

        if (properties[0] == 'label') {
            return this.label;
        }

        return Ext.ux.senior.form.DateField.superclass.getStyleEl.call(this, scope);
    }
});

Ext.reg('seniordatefield', Ext.ux.senior.form.DateField);
