Ext.Component.prototype.getHintTarget = function() {
    return this.el;
};

Ext.Component.prototype.afterRender = Ext.Component.prototype.afterRender.createSequence(function() {
    this.removeNegativeMargins();
});

Ext.override(Ext.Component, {
    
    lastAppliedStyle : null,
    /**
     * @cfg {String} customStyle
     * Estilo inicial do componente, no formato JSON
     */

    /**
     * Garante que o combobox no ter margem negativa. Caso alguma margem venha
     * a ser negativa, ser substituida por uma margem de valor zero.
     * 
     * @private
     */
    removeNegativeMargins : function() {
        var margins = this.el.getMargins();
        this.correctMargin(this.el, margins.top, 'top');
        this.correctMargin(this.el, margins.bottom, 'bottom');
        this.correctMargin(this.el, margins.left, 'left');
        this.correctMargin(this.el, margins.right, 'right');
    },

    /**
     * 
     * Caso o valor seja negativo esse mtodo atribui 0 a margem em questo
     * 
     * @private
     */
    correctMargin : function(el, value, side) {
        if (value < 0) {
            el.setStyle('margin-' + side, 0);
        }
    },
    
    /**
     * Aplica o estilo definido antes da renderizao do componente.
     * 
     * @private
     */
    applyCustomStyle : function() {
        if (this.customStyle) {
            this.setStyle(this.customStyle);
            delete this.customStyle;
        }
    },
    
    afterRender : function() {
        this.on('afterrender', this.applyCustomStyle, this);
    },

    getStyleEl : function(scope) {
        return this.getEl();
    },

    /**
     * Insere a classe de estilo passada como parmetro no componente. Se essa
     * classe j existir, ento a remove do componente antes de adicionar.
     * 
     * Caso a classe de estilo enviada seja nula, ento a classe atual ser
     * removida.
     * 
     * @param cls
     *            A classe de estilo que ser adicionada.
     */
    setStyle : function(style) {
        if (this.rendered) {
            var compiledStyle = eval(style);
            if (this.lastAppliedStyle) {
                this.manipulateStyle(this.lastAppliedStyle, false);
            }
            
            if (compiledStyle) {
                this.manipulateStyle(compiledStyle, true);
            }
            
            this.lastAppliedStyle = compiledStyle;
            
        } else if (!this.isDestroyed) {
            this.customStyle = style;
        }
    },

    /**
     * Auxilia o setStyle adicionando e removendo classe de estilo no componente.
     * @private
     * @param arrayStyle classes de estilo a serem adicionadas ou removidas
     * @param toAddClass <code>true</code> par adicionar a classe ao componente e <code>false</code> para remover.
     */
    manipulateStyle : function(arrayStyle, toAddClass) {
        for (var i = 0; i < arrayStyle.length; i++) {
            var elements = this.getElementsForDynamicStyle(arrayStyle[i].scope, toAddClass);
            for (var j = 0; j < elements.length; j++) {
                var el = Ext.get(elements[j]);
                if (el) {
                    if (toAddClass) {
                        el.addClass(arrayStyle[i].cls);

                    } else {
                        el.removeClass(arrayStyle[i].cls);
                    }
                }
            }
        }
    },

    /**
     * Obtm os elementos HTML em que deve ser aplicado a classe de estilo para o escopo passado em scope.
     * @param scope o escopo onde deseja-se aplicar o estilo dinmico.
     * @returns um array de elementos HTML onde devero ser aplicadas as classed de estilo css.
     */
    getElementsForDynamicStyle : function(scope, toAdd) {
        var elements = [];
        return elements.concat(this.getStyleEl(scope, toAdd));
    },
    
    /**
	 * Aplica as margens a um componente (funcionalidade requerida pelo TableLayout.js).
	 */
    applyMargins : function() {
        if (this.margins) {
            var el = this.getPositionEl();
            el.applyStyles({
                margin : this.margins
            });
        }
    }
    
});