Ext.namespace('Ext.ux.senior.form');

Ext.override(Ext.form.ComboBox, {

    /**
     * Sobrescrito este mtodo do Ext pois o zIndex da modal  de 12000,
     * sendo assim, com 13000 evita-se que a lista de opes seja sobreposta na
     * abertura de outra modal.
     */
    getZIndex : function(listParent) {
        listParent = listParent || Ext.getDom(this.getListParent() || Ext.getBody());
        var zindex = parseInt(Ext.fly(listParent).getStyle('z-index'), 10);
        if (!zindex) {
            zindex = this.getParentZIndex();
        }
        return (zindex || 13000) + 5;
    }
});

/**
 * @author Jean.Kirchner
 */
Ext.ux.senior.form.ComboBox = Ext.extend(Ext.form.ComboBox, {

    listEmptyText : '&nbsp',

    listClass : "combo-box-list",

    /**
     * Teclas de atalho tratadas por este componente
     * 
     * @plugin EventManagerPlugin
     */
    keyMapping : [ Ext.EventObject.F4, Ext.EventObject.TAB ],

    /**
     * Teclas ignoradas pelo menu do ComboBox.
     * 
     * 91 - Tecla Windows (esquerda) 92 - Tecla Windows (direita)
     */
    ignoredMenuKeys : [ Ext.EventObject.F2, Ext.EventObject.F3, Ext.EventObject.F4, Ext.EventObject.F7, Ext.EventObject.F8, Ext.EventObject.F9, Ext.EventObject.F10, Ext.EventObject.F11, 91, 92,
            Ext.EventObject.CONTEXT_MENU ],

    /**
     * Trata os eventos para este comboBox.
     */
    //TODO ie8 no  mais suportado, verificar se este cdigo  apenas para a verso 8 como diz o comentrio abaixo.
    initEvents : function() {
        Ext.ux.senior.form.ComboBox.superclass.initEvents.call(this, arguments);
        // Trata o evento da tecla TAB no ie8, faz com que ela mande o valor
        // para o server.
        this.keyNav.tab = this.keyNav.tab.createSequence(function() {
            if (this.forceSelection === true) {
                this.onViewClick(false);
            }
        }, this);
        
        this.on({
            "disable" : this.onDisableEvent,
            "expand" : this.attachWindowResizeListener,
            "collapse" : this.dettachWindowResizeListener,
            "destroy" : this.dettachWindowResizeListener,
            scope : this
        });
    },
    
    /**
     * Alinha a lista de itens com o input.
     * 
     * @private
     */
    alignList : function(e) {
        if (this.isExpanded()) {
            this.list.alignTo(this.el, this.listAlign);
        }
    },
    
    /**
     * Registra um listener que alinha a lista de itens ao redimensionar o navegador.
     * 
     * @private
     */
    attachWindowResizeListener : function() {
        Ext.EventManager.onWindowResize(this.alignList, this);
    },
    
    /**
     * Remove o listener que alinha a lista de itens ao redimensionar o navegador.
     * 
     * @private
     */
    dettachWindowResizeListener : function() {
        Ext.EventManager.removeResizeListener(this.alignList, this);
    },
    
    /**
     * Ligado ao evento de redimensionamento
     * 
     * @param width
     *            a nova largura
     * @param height
     *            a nova altura
     */
    onResize : function(width, height) {
        Ext.ux.senior.form.ComboBox.superclass.onResize.call(this, width, height);

        var triggerWidth = this.getTriggerWidth();
        if (Ext.isNumber(width)) {
            this.el.setWidth(width - triggerWidth);
            this.trigger.setWidth(triggerWidth);
            if (this.customTrigger) {
                this.customTrigger.setWidth(triggerWidth);
            }
        }
        this.wrap.setWidth(width);
    },

    /**
     * @plugin EventManagerPlugin
     */
    onKeyEvent : function(key, evt) {
        var evs = Ext.EventObject;
        switch (key) {
        case evs.F4:
            this.onTriggerClick();
            break;
        case evs.TAB:

            // no safari no troca de abas, fica navegando dentro da tela
            if (Ext.isSafari && evs.ctrlKey && evs.shiftKey) {
                return true;
            }

            if (!this.isExpanded()) {
                this.view.clearSelections(true);
            }
            // Trata o evento da tecla TAB no ie9, faz com que ela mande o
            // valor para o server.
            this.onViewClick(false);
            break;
        }
    },

    /**
     * @override
     */
    onFocus : function() {
        Ext.ux.senior.form.TriggerField.superclass.onFocus.call(this);

        // remove os 10ms da simulao do blur deste componente ao click no
        // documento
        if (this.mimicing) {
            this.doc.un('mousedown', this.mimicBlur, this);
            this.doc.on('mousedown', this.mimicBlur, this);
        }
    },
    
    /**
     * Ligado ao evento disable
     */
    onDisableEvent : function() {
        if (this.rendered && this.hasFocus) {
            Ext.form.TriggerField.superclass.onBlur.call(this);
        }
    },

    /**
     * Valida se determinado evento de click pode disparar o blur deste field.
     * 
     * @override
     */
    validateBlur : function(evt) {
        if (this.list && this.list.isVisible()) {
            if (this.selectedIndex >= 0 && this.list.contains(evt.target)) {
                return false;
            }
        }

        return !this.showingSearchForm;
    },

    onKeyUp : function(event) {
        if (this.ignoredMenuKeys.indexOf(event.getKey()) == -1 && !event.ctrlKey) {
            Ext.ux.senior.form.ComboBox.superclass.onKeyUp.call(this, event);
        }
    },

    /**
     * @plugin EventManagerPlugin
     */
    eventMapping : function() {
        return {
            select : this.prepareSelectEvent,
            afterrender : this.onComboBoxReady,
            change : this.onChange
        };
    },

    /**
     * @event changed
     */
    prepareSelectEvent : function(combo, record) {
        this.startValue = record.data.description;
        return {
            type : 'changed',
            value : record.get('index')
        };
    },

    onChange : function(combobox, newValue, oldValue) {
        this.startValue = newValue;
        var record = combobox.findRecord(combobox.valueField || combobox.displayField, newValue);
        var index = (record) ? record.data.index : -1;
        return {
            type : 'changed',
            value : index
        };
    },

    setLabel : function(textLabel) {
        var labelSeparator = this.ownerCt.labelSeparator;
        this.label.update(textLabel + labelSeparator);
    },

    /**
     * Trata os eventos que acontecem aps a renderizao
     * 
     */
    onComboBoxReady : function() {
        if (!this.dataLoaded) {
            this.dataLoaded = true;
            return {
                type : "loadData"
            };
        }
    },

    /**
     * Retorna o elemento que possui o estilo desejado.
     */
    getStyleEl : function(scope) {
        var el = null;
        var property = scope.split('$');

        if (property[0] == "combo.items") {
            el = this.view.getEl();
            if (property[1].indexOf('border') > -1) {
                el = Ext.get(el.dom.parentElement);
            }
        } else if (property[0] == "combo.focused") {
            el = Ext.Element.get(this.view.getSelectedNodes()[0]);
        } else if (property[0] == 'label') {
            el = this.label;
        } else {
            el = this.searchElementForCombo(scope);
        }

        return el;
    },

    /**
     * Retorna o elemento que trata as propriedades quando o escopo  igual a
     * combo.
     */
    searchElementForCombo : function(scope) {
        if (scope.indexOf("combo-icon") >= 0) {
            return Ext.Element.get(this.getEl().dom.nextSibling.id);
        } else {
            return this.getEl();
        }
    }

});

Ext.reg('seniorcombo', Ext.ux.senior.form.ComboBox);