Ext.namespace('Ext.ux.senior');

/**
 * Calendario Senior, atende alguns requisitos e caso de uso conforme segue:
 * 
 * UC-FRC-0085 - Operar Calendrio <br>
 * REQ0017, REQ0019, REQ0005, REQ0007<br>
 * 
 * Este componente, prov funcionalidades para que o DatePicker do Ext possa ser tratado como um BoxComponent, ou seja possa estar dentro de layouts, containers etc.
 * 
 * Alm disto  este componente que se preocupa em enviar os eventos do DatePicker para o servidor
 * 
 * Este calendrio  um BoxComponent, mas com uma instncia controlada de DatePicker, no qual  renderizado no elemento BoxComponent deste componente. Ou seja, ele  um Wrapper do DatePicker.
 * 
 * @author Jean.Kirchner
 */
Ext.ux.senior.Calendar = Ext.extend(Ext.BoxComponent, {

    /**
     * Inicializao de componente
     */

    /* Instncia do DatePicker no qual o da senior  wrapper, para o DatePicker poder ser filho de um container */
    datePickerInstance : null,

    /**
     * Guarda qual  o dia focado no calendrio, diferente do dia selecionado.
     */
    focused : null,
    /**
     * Define qual a data inicial de referencia do calendrio
     */
    dateRefStart : null,
    /**
     * Define qual a data final de referencia do calendrio
     */
    dateRefEnd : null,

    /**
     * @override
     */
    initComponent : function() {

        /* faz uma cpia da configurao, para no dar conflitos */
        var innerConfig = {};
        this.width = 179;

        if (Ext.isChrome || Ext.isSafari) {
            this.height = this.showToday == true ? 181 : 152;
        } else {
            if (Ext.isIE11) {
                this.height = this.showToday == true ? 187 : 158;
            } else {
                if (Ext.isFireFox) {
                    this.height = this.showToday == true ? 196 : 167;
                }
            }
        }

        Ext.apply(innerConfig, this.initialConfig);

        innerConfig.id = this.getId() + 'innerInstance';
        innerConfig.xtype = Ext.ux.senior.DatePicker.xtype;
        // Removido para esconder apenas o pai (que esconde o filho DatePicker junto)
        delete innerConfig.hidden;
        // Removidos para no reaplicar deslocamento
        delete innerConfig.x;
        delete innerConfig.y;
        /*
         * Eventmanager no interessa para a instncia interna, sendo que  o Calendar que gerncia os eventos Mas todos os outros interessam
         * O plugin de foco  adicionado apenas no calendrio, e no no datepicker pois, todos os eventos que o calendrio recebe repassa ao datepicker tratar
         */
        innerConfig.plugins.remove(Ext.ux.senior.plugins.EventManagerPlugin.ptype);
        innerConfig.plugins.remove(Ext.ux.senior.focuscontrol.FocusControlPlugin.ptype);

        this.plugins = [ Ext.ux.senior.plugins.EventManagerPlugin.ptype, Ext.ux.senior.focuscontrol.FocusControlPlugin.ptype ];

        Ext.ux.senior.Calendar.superclass.initComponent.call(this, arguments);

        this.datePickerInstance = Ext.create(innerConfig);

        /* quando os eventos forem disparados pelo datepicker, sero disparados como se fossem this (calendar) */
        this.relayEvents(this.datePickerInstance, [ 'select', 'prevMonth', 'nextMonth', 'prevYear', 'nextYear', 'navigate' ]);
    },

    /**
     * @override
     */
    onRender : function(ct, pos) {
        Ext.ux.senior.Calendar.superclass.onRender.call(this, ct, pos);

        /* Renderiza o datepicker no elemento deste componente */
        this.datePickerInstance.render(this.el);
    },

    setDateRefStart : function(date) {
        this.datePickerInstance.dateRefStart = date;
    },

    setDateRefEnd : function(date) {
        this.datePickerInstance.dateRefEnd = date;
    },

    /**
     * Formatao padro utilizada pelo servidor
     * 
     * @param date
     *            {Date} a data a ser normalizada
     * 
     * @private
     */
    normalizeDate : function(date) {
        return date.format('d/m/Y');
    },

    /**
     * Eventos que preparam dados para envio
     * 
     * @plugin EventManagerPlugin
     */
    eventMapping : function() {
        return {
            select : this.onSelect,
            prevMonth : this.onPrevMonth,
            nextMonth : this.onNextMonth,
            prevYear : this.onPrevYear,
            nextYear : this.onNextYear,
            navigate : this.onNavigate
        };
    },

    /**
     * Prepara dados para evento de seleo
     * 
     * @event
     */
    onSelect : function(picker, dateObj) {
        if (!this.readOnly) {
            FocusManager.onComponentFocus(this);
            var date = this.normalizeDate(dateObj);
            return {
                type : 'calendarNavigation',
                value : date,
                clientFormat : true,
                category : 'TO_DAY'
            };
        }
    },

    /**
     * Prepara dados para evento de navegao para o ms anterior
     * 
     * @event
     */
    onPrevMonth : function() {
        FocusManager.onComponentFocus(this);
        return {
            type : 'calendarNavigation',
            category : 'PREV_MONTH'
        };
    },

    /**
     * Prepara dados para evento de navegao para o ms posterior
     * 
     * @event
     */
    onNextMonth : function() {
        FocusManager.onComponentFocus(this);
        return {
            type : 'calendarNavigation',
            category : 'NEXT_MONTH'
        };
    },

    /**
     * Prepara dados para evento de navegao para o ano anterior
     * 
     * @event
     */
    onPrevYear : function() {
        FocusManager.onComponentFocus(this);
        return {
            type : 'calendarNavigation',
            category : 'PREV_YEAR'
        };
    },

    /**
     * Prepara dados para evento de navegao para o ano posterior
     * 
     * @event
     */
    onNextYear : function() {
        FocusManager.onComponentFocus(this);
        return {
            type : 'calendarNavigation',
            category : 'NEXT_YEAR'
        };
    },

    /**
     * Prepara dados para evento de seleo de ms e ano do calendrio
     * 
     * @event
     */
    onNavigate : function(date) {
        FocusManager.onComponentFocus(this);
        date = this.normalizeDate(date);
        return {
            type : 'calendarNavigation',
            category : 'TO_MONTH_YEAR',
            clientFormat : true,
            value : date
        };
    },

    /**
     * A partir daqui so mtodos wrappers para os mtodos do componente original Ou seja, so aqueles nos quais o servidor precisa utilizar
     */

    /**
     * @see Ext.ux.senior.DatePicker#setValue
     * @public
     */
    setValue : function(value) {
        this.datePickerInstance.setValue(value);
    },

    /**
     * @see Ext.ux.senior.DatePicker#setMaxDate
     * @public
     */
    setMaxDate : function(max) {
        this.datePickerInstance.setMaxDate(max);
    },

    /**
     * @see Ext.ux.senior.DatePicker#setMinDate
     * @public
     */
    setMinDate : function(min) {
        this.datePickerInstance.setMinDate(min);
    },

    /**
     * @see Ext.ux.senior.DatePicker#setCalendarMonth
     * @public
     */
    setCalendarMonth : function(year, month) {
        this.datePickerInstance.setCalendarMonth(year, month);
    },

    /**
     * @see Ext.ux.senior.DatePicker#setMonthNames
     * @public
     */
    setMonthNames : function(names) {
        this.datePickerInstance.setMonthNames(names);
    },

    /**
     * @see Ext.ux.senior.DatePicker#setFirstDayToShow
     * @public
     */
    setFirstDayToShow : function(date) {
        this.datePickerInstance.setFirstDayToShow(date);
    },

    /**
     * @see Ext.ux.senior.DatePicker#clearStyles
     * @public
     */
    clearStyles : function() {
        this.datePickerInstance.clearStyles();
    },

    /**
     * @see Ext.ux.senior.DatePicker#clearSelectdDates
     * @public
     */
    clearSelectedDates : function() {
        this.datePickerInstance.clearSelectedDates();
    },

    /**
     * @see Ext.ux.senior.DatePicker#setStyles
     * @public
     */
    setStyles : function(obj) {
        this.datePickerInstance.setStyles(obj);
    },

    /**
     * @see Ext.ux.senior.DatePicker#setSelections
     * @public
     */
    setSelections : function(obj) {
        this.datePickerInstance.setSelections(obj);
    },

    /**
     * @see Ext.ux.senior.DatePicker#setChangedDates
     * @public
     */
    setChangedDates : function(obj) {
        this.datePickerInstance.setChangedDates(obj);
    },

    /**
     * @see Ext.ux.senior.DatePicker#setTitle
     * @public
     */
    setTitle : function(title) {
        this.datePickerInstance.setTitle(title);
    },

    /**
     * @see Ext.ux.senior.DatePicker#setReadOnly
     * @public
     */
    setReadOnly : function(value) {
        this.datePickerInstance.setReadOnly(value);
    },

    /**
     * @see Ext.ux.senior.DatePicker#setShowNavigation
     * @public
     */
    setShowNavigation : function(value) {
        this.datePickerInstance.setShowNavigation(value);
    },

    /**
     * @see Ext.ux.senior.DatePicker#refresh
     * @public
     */
    refresh : function() {
        this.datePickerInstance.refresh(FocusManager.getFocusedComponent() != this);
    },

    /**
     * @overide
     */
    setDisabled : function(disabled) {
        Ext.ux.senior.Calendar.superclass.setDisabled.call(this, disabled);
        //Precisa desabilitar o calendrio tambm
        this.datePickerInstance.setDisabled(disabled);
    },

    focus : function() {
        this.datePickerInstance.focus();
        FocusManager.onComponentFocus(this);
    }

});

Ext.reg('seniorcalendar', Ext.ux.senior.Calendar);
