/*
 * Decompiled with CFR 0.152.
 */
package com.senior.ui.ext.style;

import com.senior.ui.components.VButton;
import com.senior.ui.components.VCheckBox;
import com.senior.ui.components.VEditBox;
import com.senior.ui.components.VFile;
import com.senior.ui.components.VFileButton;
import com.senior.ui.components.VGroupBox;
import com.senior.ui.components.VLabel;
import com.senior.ui.components.VLine;
import com.senior.ui.components.VPanel;
import com.senior.ui.components.VTabGroup;
import com.senior.ui.components.VTextArea;
import com.senior.ui.components.calendar.VCalendar;
import com.senior.ui.components.combo.VComboBox;
import com.senior.ui.components.grid.VScrollGrid;
import com.senior.ui.components.image.VImage;
import com.senior.ui.components.radio.VRadioButton;
import com.senior.ui.components.tree.VTree;
import com.senior.ui.core.theme.StyleClass;
import com.senior.ui.core.theme.StyleEntry;
import com.senior.ui.core.theme.StyleProperty;
import com.senior.ui.core.theme.StyleScope;
import com.senior.ui.core.theme.ThemeDefinition;
import com.senior.ui.core.theme.ThemeManager;
import com.senior.ui.ext.CSSBuilder;
import com.senior.ui.ext.style.CSSUtility;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public final class DynamicCssGenerator {
    private static final Map<String, EnumSet<StyleScope>> scopeByComponent = new HashMap<String, EnumSet<StyleScope>>();

    static {
        scopeByComponent.put(VEditBox.class.getName(), EnumSet.of(StyleScope.EDITBOX, StyleScope.LABEL));
        scopeByComponent.put(VComboBox.class.getName(), EnumSet.of(StyleScope.COMBO, StyleScope.LABEL));
        scopeByComponent.put(VButton.class.getName(), EnumSet.of(StyleScope.BUTTON, StyleScope.BUTTON_FLAT));
        scopeByComponent.put(VCalendar.class.getName(), EnumSet.of(StyleScope.CALENDAR, new StyleScope[]{StyleScope.CALENDAR_FOCUSED, StyleScope.CALENDAR_FOOTER, StyleScope.CALENDAR_HEADER, StyleScope.CALENDAR_NAV_PANEL, StyleScope.CALENDAR_NAV_PANEL_BUTTON, StyleScope.CALENDAR_NAV_PANEL_SELECTED, StyleScope.CALENDAR_SELECTED, StyleScope.CALENDAR_TODAY_BUTTON, StyleScope.LABEL}));
        scopeByComponent.put(VRadioButton.class.getName(), EnumSet.of(StyleScope.RADIO, StyleScope.LABEL));
        scopeByComponent.put(VCheckBox.class.getName(), EnumSet.of(StyleScope.CHECKBOX, StyleScope.LABEL));
        scopeByComponent.put(VLabel.class.getName(), EnumSet.of(StyleScope.LABEL));
        scopeByComponent.put(VLine.class.getName(), EnumSet.of(StyleScope.LINE));
        scopeByComponent.put(VTextArea.class.getName(), EnumSet.of(StyleScope.TEXT_AREA, StyleScope.LABEL));
        scopeByComponent.put(VPanel.class.getName(), EnumSet.of(StyleScope.PANEL, StyleScope.PANEL_HEADER));
        scopeByComponent.put(VImage.class.getName(), EnumSet.of(StyleScope.IMAGE, StyleScope.LABEL));
        scopeByComponent.put(VTree.class.getName(), EnumSet.of(StyleScope.TREE, StyleScope.TREE_FOCUSED, StyleScope.TREE_SELECTED));
        scopeByComponent.put(VTabGroup.class.getName(), EnumSet.of(StyleScope.TABGROUP_HEADER, StyleScope.TABGROUP_HEADER_ACTIVE));
        scopeByComponent.put(VTextArea.class.getName(), EnumSet.of(StyleScope.TEXT_AREA, StyleScope.LABEL));
        scopeByComponent.put(VGroupBox.class.getName(), EnumSet.of(StyleScope.GROUPBOX_HEADER));
        scopeByComponent.put(VScrollGrid.class.getName(), EnumSet.of(StyleScope.GRID, StyleScope.GRID_CELL_FOCUSED, StyleScope.GRID_HEADER, StyleScope.GRID_ROW_FOCUSED, StyleScope.GRID_ROW_SELECTED));
        scopeByComponent.put(VFile.class.getName(), EnumSet.of(StyleScope.FILE));
        scopeByComponent.put(VFileButton.class.getName(), EnumSet.of(StyleScope.FILE_BUTTON, StyleScope.FILE_BUTTON_FLAT));
    }

    private static EnumSet<StyleScope> getStyleScope(String componentName) {
        if (!scopeByComponent.containsKey(componentName)) {
            return EnumSet.noneOf(StyleScope.class);
        }
        return scopeByComponent.get(componentName);
    }

    public static Map<String, CSSUtility[]> generateCss(String[] styleNames, String componentClassName) {
        HashMap<String, CSSUtility[]> createdCSSClasses = new HashMap<String, CSSUtility[]>();
        EnumSet<StyleScope> filteredScope = DynamicCssGenerator.getStyleScope(componentClassName);
        ThemeDefinition themeDefinition = ThemeManager.getInstance().getCurrentTheme();
        ArrayList<StyleEntry> renderedEntries = new ArrayList<StyleEntry>();
        HashMap<StyleEntry, String> groupedEntries = new HashMap<StyleEntry, String>();
        String[] stringArray = styleNames;
        int n = styleNames.length;
        int n2 = 0;
        while (n2 < n) {
            String styleName = stringArray[n2];
            StyleClass styleClass = themeDefinition.getStyleClass(styleName);
            if (styleClass != null) {
                for (StyleEntry styleEntry : styleClass.getEntries()) {
                    StyleScope scope = styleEntry.getScope();
                    if (!filteredScope.contains(scope)) continue;
                    if (DynamicCssGenerator.isEntryGroup(styleEntry)) {
                        if (groupedEntries.containsKey(styleEntry)) continue;
                        String styleFor = DynamicCssGenerator.formatBackground(styleClass.styleFor(scope, styleEntry.getProperty()));
                        groupedEntries.put(styleEntry, styleFor);
                        continue;
                    }
                    if (renderedEntries.contains(styleEntry)) continue;
                    renderedEntries.add(styleEntry);
                    String className = DynamicCssGenerator.buildClassName(styleNames, styleEntry);
                    StyleProperty property = styleEntry.getProperty();
                    String styleFor = DynamicCssGenerator.formatBackground(styleClass.styleFor(scope, property));
                    CSSUtility cssClass = CSSBuilder.generateCSSClass(className, styleFor, styleEntry);
                    createdCSSClasses.put(scope.getValue().concat("$").concat(property.getValue()), new CSSUtility[]{cssClass});
                }
            }
            ++n2;
        }
        for (Map.Entry entry : groupedEntries.entrySet()) {
            StyleEntry styleEntry = (StyleEntry)entry.getKey();
            if (renderedEntries.contains(styleEntry)) continue;
            ArrayList<StyleEntry> styleEntries = new ArrayList<StyleEntry>();
            ArrayList<String> values = new ArrayList<String>();
            String className = DynamicCssGenerator.buildClassName(styleNames, styleEntry);
            renderedEntries.add(styleEntry);
            styleEntries.add(styleEntry);
            values.add((String)entry.getValue());
            for (Map.Entry e : groupedEntries.entrySet()) {
                if (((StyleEntry)e.getKey()).getScope() != styleEntry.getScope()) continue;
                renderedEntries.add((StyleEntry)e.getKey());
                styleEntries.add((StyleEntry)e.getKey());
                values.add((String)e.getValue());
            }
            CSSUtility[] cssClasses = CSSBuilder.generateCssClassesOfGroupedProperties(className, styleEntries.toArray(new StyleEntry[styleEntries.size()]), values.toArray(new String[values.size()]));
            createdCSSClasses.put(styleEntry.getScope().getValue().concat("$").concat(styleEntry.getProperty().getValue()), cssClasses);
        }
        return createdCSSClasses;
    }

    private static String formatBackground(String valueProperty) {
        if (valueProperty != null && valueProperty.contains("url") && !valueProperty.contains("http") && !valueProperty.contains("resmanager")) {
            valueProperty = valueProperty.replace("url(", "url(images/");
        }
        return valueProperty;
    }

    public static boolean isEntryGroup(StyleEntry styleEntry) {
        switch (styleEntry.getScope()) {
            case PANEL_HEADER: {
                return StyleProperty.BACKGROUND == styleEntry.getProperty();
            }
            case BUTTON: 
            case TABGROUP_HEADER: 
            case TABGROUP_HEADER_ACTIVE: 
            case BUTTON_FLAT: 
            case FILE_BUTTON: 
            case FILE_BUTTON_FLAT: {
                return StyleProperty.BACKGROUND == styleEntry.getProperty() || StyleProperty.BORDER_COLOR == styleEntry.getProperty();
            }
        }
        return false;
    }

    private static String buildClassName(String[] styleNames, StyleEntry styleEntry) {
        StringBuilder builderClassName = new StringBuilder();
        String[] stringArray = styleNames;
        int n = styleNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            builderClassName.append(name);
            builderClassName.append('-');
            ++n2;
        }
        builderClassName.append(styleEntry.getScope().name().toLowerCase());
        builderClassName.append('-');
        builderClassName.append(styleEntry.getProperty().getValue());
        return builderClassName.toString();
    }
}

