/*
 * Decompiled with CFR 0.152.
 */
package com.senior.ui.ext.renderer;

import com.senior.ui.components.ComponentProperty;
import com.senior.ui.components.VComponent;
import com.senior.ui.components.VComposite;
import com.senior.ui.components.VWindow;
import com.senior.ui.core.ChangeNode;
import com.senior.ui.ext.renderer.AbstractRender;
import com.senior.ui.ext.renderer.IComponentRenderer;
import com.senior.ui.ext.renderer.JSONUtility;
import com.senior.ui.ext.renderer.JsUtility;

public class WindowRender
extends AbstractRender {
    public WindowRender() {
        this.properties.put(ComponentProperty.RESIZABLE, "resizable");
        this.properties.put(ComponentProperty.DRAGGABLE, "draggable");
        this.properties.put(ComponentProperty.CLOSABLE, "closable");
        this.properties.put(ComponentProperty.MAXIMIZABLE, "maximizable");
        this.properties.put(ComponentProperty.TITLE, "title");
        this.properties.put(ComponentProperty.MAXIMIZED, "maximized");
        this.methods.put(ComponentProperty.TITLE, "setTitle");
    }

    @Override
    protected void render(ChangeNode node, JSONUtility util, IComponentRenderer renderer) {
        VWindow window = (VWindow)node.getComponent();
        if (!node.hasPropertyChange(ComponentProperty.TITLE)) {
            util.key("header").value(false);
        }
        util.key("constrainHeader").value(true);
        JsUtility afterScripts = util.getAfterScripts();
        afterScripts.extCmp(window.getId());
        Boolean isModal = (Boolean)window.get(ComponentProperty.MODAL);
        if (isModal.booleanValue()) {
            VComponent firstChild = window.getChildAt(0);
            afterScripts.attribute("id", firstChild.getId());
        }
        afterScripts.method("doLayout", new Object[0]);
        afterScripts.method("show", new Object[0]);
        if (node.hasPropertyChange(ComponentProperty.X) || node.hasPropertyChange(ComponentProperty.Y)) {
            node.clearPropertyChange(ComponentProperty.X);
            node.clearPropertyChange(ComponentProperty.Y);
            afterScripts.method("setWindowPosition", window.getX(), window.getY());
        } else {
            afterScripts.method("center", new Object[0]);
        }
        if (window.getAnchorTo() != null) {
            afterScripts.method("anchorTo", window.getAnchorTo().getId());
        }
        JsUtility beforeScripts = util.getBeforeScripts();
        if (isModal.booleanValue()) {
            afterScripts.closeScope();
            VComposite owner = window.getOwner();
            if (owner != null) {
                util.key("owner").value(owner.getId());
            }
            beforeScripts.objMethod("ProcessManager", "startProcess", "true");
            beforeScripts.objMethod("FocusManager", "pushContext", new Object[0]);
            afterScripts.objMethod("FocusManager", "focusFirstComponent", new Object[0]);
        } else {
            VComposite owner = window.getOwner();
            if (owner != null) {
                Object windowVar = afterScripts.getCurrentVar();
                afterScripts.closeScope();
                afterScripts.objMethod("Ext.ux.senior.WindowMgr", "register", windowVar);
                util.key("owner").value(owner.getId());
                beforeScripts.objMethod("ConnectionManager", "findAndRegisterConnectionFrom", owner.getId(), window.getId());
            }
        }
        if (window.isMaximized()) {
            afterScripts.objMethod("Ext.ux.senior.LayoutOrganizer", "enqueueFitContainer", window.getId());
        }
    }
}

