/*
 * Decompiled with CFR 0.152.
 */
package com.senior.ui.ext.renderer;

import com.senior.ui.components.ComponentProperty;
import com.senior.ui.components.tree.ITreeNode;
import com.senior.ui.components.tree.TreeNodeChange;
import com.senior.ui.components.tree.TreeNodeChangeType;
import com.senior.ui.components.tree.VTree;
import com.senior.ui.core.ChangeNode;
import com.senior.ui.ext.renderer.AbstractRender;
import com.senior.ui.ext.renderer.IComponentRenderer;
import com.senior.ui.ext.renderer.JSONUtility;
import com.senior.ui.ext.renderer.JsUtility;
import com.senior.ui.ext.renderer.RendererFlag;
import java.util.Collection;
import java.util.List;

public class TreeRender
extends AbstractRender {
    private static final String ID_MASK = "%s_%s";

    TreeRender() {
        this.properties.put(ComponentProperty.SHOW_FILTER, "showFilter");
        this.methods.put(ComponentProperty.SHOW_FILTER, "setShowFilter");
        this.properties.put(ComponentProperty.EMPTY_TEXT, "emptyText");
        this.methods.put(ComponentProperty.EMPTY_TEXT, "setEmptyText");
        this.properties.put(ComponentProperty.FILTER_EXPRESSION, "filterExpression");
        this.methods.put(ComponentProperty.FILTER_EXPRESSION, "setFilterExpression");
    }

    @Override
    protected void render(ChangeNode node, JSONUtility util, IComponentRenderer renderer) {
        JSONUtility rootNodesKey = util.key("rootNodes");
        VTree tree = (VTree)node.getComponent();
        this.renderNodes(rootNodesKey, tree, tree.getRootNodes());
        node.clearPropertyChange(ComponentProperty.DATA_CHANGED);
        boolean allowDrag = tree.isAllowDrag();
        boolean allowDrop = tree.isAllowDrop();
        if (allowDrag) {
            util.key("enableDrag").value(true);
            util.key("treeDragZone").value(true);
        }
        if (allowDrop) {
            util.key("enableDrop").value(true);
            util.key("treeDropZone").value(true);
        }
        if (tree.isShowFilter()) {
            this.renderFilter(node, util, renderer);
        }
    }

    private void renderFilter(ChangeNode treeNode, JSONUtility util, IComponentRenderer renderer) {
        VTree tree = (VTree)treeNode.getComponent();
        ChangeNode.ChangeNodeAssociation editorAssoc = treeNode.getSingleAssociation(ComponentProperty.FILTER_EDITBOX);
        ChangeNode editorNode = editorAssoc.getReferencedNode();
        editorNode.setPropertyChanges(editorNode.getComponent().getDefaultProperties());
        RendererFlag.IGNORE_MASK_PLUGIN.setFlag(editorNode);
        JSONUtility editorUtil = JSONUtility.getInstance();
        editorUtil.object();
        renderer.render(editorNode, editorUtil);
        editorUtil.key("emptyText").value(tree.getEmptyTextFilter());
        editorUtil.key("componentOwner").value(tree.getId());
        editorUtil.end();
        editorAssoc.markAsRendered();
        util.key("editor").value(editorUtil);
        JSONUtility.release(editorUtil);
    }

    private void renderNodes(JSONUtility util, VTree tree, List<ITreeNode> toRender) {
        util.array();
        for (ITreeNode treeNode : toRender) {
            this.renderNode(util, tree, treeNode);
        }
        util.end();
    }

    private void renderNode(JSONUtility util, VTree tree, ITreeNode toRender) {
        util.object();
        util.key("id").value(String.format(ID_MASK, tree.getId(), toRender.getId()));
        util.key("text").value(toRender.getTitle());
        if (toRender.getIcon() != null) {
            util.key("icon").value(TreeRender.getResourceUri(toRender.getIcon()));
        }
        if (toRender.hasCheckBox()) {
            util.key("checked").value(toRender.isChecked());
        }
        util.key("expanded").value(!toRender.isLeaf() && toRender.isOpen());
        util.key("leaf").value(toRender.isLeaf());
        List childrenToRender = tree.getChildrenForNode(toRender);
        if (!childrenToRender.isEmpty()) {
            JSONUtility childrenKey = util.key("children");
            this.renderNodes(childrenKey, tree, childrenToRender);
        }
        util.end();
    }

    @Override
    protected void update(ChangeNode node, JsUtility util, IComponentRenderer renderer) {
        VTree tree = (VTree)node.getComponent();
        if (!node.hasPropertyChanges() || !tree.getVisibleState()) {
            return;
        }
        if (node.hasPropertyChange(ComponentProperty.DATA_CHANGED)) {
            util.method("clearAllChildren", new Object[0]);
            JSONUtility render = JSONUtility.getInstance();
            List rootNodes = tree.getRootNodes();
            this.renderNodes(render, tree, rootNodes);
            util.method("addNodes", "root", render);
            node.clearPropertyChange(ComponentProperty.DATA_CHANGED);
            JSONUtility.release(render);
        } else {
            TreeNodesUpdatesRender uRender = new TreeNodesUpdatesRender(tree, util);
            uRender.renderUpdates();
        }
        node.clearPropertyChange(ComponentProperty.NODES_CHANGED);
        tree.clearChangeSet();
        if (tree.isShowFilter()) {
            ChangeNode.ChangeNodeAssociation editorAssoc = node.getSingleAssociation(ComponentProperty.FILTER_EDITBOX);
            ChangeNode editorNode = editorAssoc.getReferencedNode();
            RendererFlag.IGNORE_MASK_PLUGIN.setFlag(editorNode);
            renderer.update(editorNode, util);
        }
    }

    private static class TreeNodesUpdatesRender {
        private final VTree tree;
        private final JsUtility updateUtil;

        public TreeNodesUpdatesRender(VTree tree, JsUtility updateUtil) {
            this.tree = tree;
            this.updateUtil = updateUtil;
        }

        public void renderUpdates() {
            Collection changes = this.tree.getChangeSet();
            for (TreeNodeChange change : changes) {
                this.renderChange(change);
            }
        }

        private void renderChange(TreeNodeChange change) {
            ITreeNode node = this.tree.getNodeByID(change.getNode());
            String nodeId = String.format(TreeRender.ID_MASK, this.tree.getId(), node.getId());
            if (change.hasChange(TreeNodeChangeType.OPENED)) {
                this.updateUtil.method("expandNode", nodeId);
            } else if (change.hasChange(TreeNodeChangeType.CLOSED)) {
                this.updateUtil.method("collapseNode", nodeId);
            }
        }
    }
}

