/*
 * Decompiled with CFR 0.152.
 */
package com.senior.ui.ext.renderer;

import com.senior.ui.components.ComponentProperty;
import com.senior.ui.components.VToolbar;
import com.senior.ui.core.ChangeNode;
import com.senior.ui.definition.ButtonAlignmentKind;
import com.senior.ui.ext.renderer.AbstractRender;
import com.senior.ui.ext.renderer.IComponentRenderer;
import com.senior.ui.ext.renderer.JSONUtility;
import com.senior.ui.ext.renderer.JsUtility;
import java.util.Collection;

final class ToolbarRender
extends AbstractRender {
    ToolbarRender() {
    }

    @Override
    protected void render(ChangeNode node, JSONUtility util, IComponentRenderer renderer) {
        VToolbar toolbar = (VToolbar)node.getComponent();
        node.clearPropertyChange(ComponentProperty.NAME);
        node.clearPropertyChange(ComponentProperty.VISIBLE_STATE);
        node.clearPropertyChange(ComponentProperty.TAB_ORDER);
        node.clearPropertyChange(ComponentProperty.ALLOW_DRAG);
        node.clearPropertyChange(ComponentProperty.ALLOW_DROP);
        util.key("autoHeight").value(false);
        util.key("height").value(26);
        if (!toolbar.getVisibleState()) {
            util.key("hidden").value(true);
        }
        if (node.hasPropertyChange(ComponentProperty.ENABLED_STATE)) {
            util.key("disabled").value(!toolbar.getEnableState());
            node.clearPropertyChange(ComponentProperty.ENABLED_STATE);
        }
        util.key("items").array();
        if (toolbar.getAlignmentButtons() == ButtonAlignmentKind.RIGHT) {
            util.object().key("xtype").value("tbfill").end();
        }
        Collection buttonsAssocs = node.getMultipleAssociations(ComponentProperty.BUTTONS);
        for (ChangeNode.ChangeNodeAssociation buttonAssoc : buttonsAssocs) {
            ChangeNode buttonNode = buttonAssoc.getReferencedNode();
            assert (buttonAssoc.getStatus() == ChangeNode.ChangeNodeAssociationStatus.ADDED);
            buttonNode.setPropertyChanges(buttonNode.getComponent().getDefaultProperties());
            util.object();
            renderer.render(buttonNode, util);
            util.end();
            buttonAssoc.markAsRendered();
        }
        util.end();
    }

    @Override
    protected void update(ChangeNode node, JsUtility util, IComponentRenderer renderer) {
        VToolbar toolbar = (VToolbar)node.getComponent();
        if (node.hasPropertyChange(ComponentProperty.ENABLED_STATE)) {
            util.method("setDisabled", !toolbar.getEnableState());
            node.clearPropertyChange(ComponentProperty.ENABLED_STATE);
        }
        Collection buttonsAssocs = node.getMultipleAssociations(ComponentProperty.BUTTONS);
        for (ChangeNode.ChangeNodeAssociation buttonAssoc : buttonsAssocs) {
            ChangeNode buttonNode = buttonAssoc.getReferencedNode();
            assert (buttonAssoc.getStatus() == ChangeNode.ChangeNodeAssociationStatus.RENDERED);
            renderer.update(buttonNode, util);
        }
    }
}

