/*
 * Decompiled with CFR 0.152.
 */
package com.senior.ui.ext.renderer;

import com.senior.ui.components.ComponentProperty;
import com.senior.ui.components.VButton;
import com.senior.ui.components.VCheckBox;
import com.senior.ui.components.VColorPicker;
import com.senior.ui.components.VComponent;
import com.senior.ui.components.VEditBox;
import com.senior.ui.components.VFile;
import com.senior.ui.components.VFileButton;
import com.senior.ui.components.VFrame;
import com.senior.ui.components.VGroupBox;
import com.senior.ui.components.VLabel;
import com.senior.ui.components.VLine;
import com.senior.ui.components.VPanel;
import com.senior.ui.components.VRepeater;
import com.senior.ui.components.VTabGroup;
import com.senior.ui.components.VTabSheet;
import com.senior.ui.components.VTextArea;
import com.senior.ui.components.VToolbar;
import com.senior.ui.components.VViewPort;
import com.senior.ui.components.VWindow;
import com.senior.ui.components.calendar.VCalendar;
import com.senior.ui.components.combo.VComboBox;
import com.senior.ui.components.grid.VScrollGrid;
import com.senior.ui.components.image.VImage;
import com.senior.ui.components.plugins.ChangeStylePlugin;
import com.senior.ui.components.plugins.DateEditBoxFilterPlugin;
import com.senior.ui.components.plugins.DescriptionPlugin;
import com.senior.ui.components.plugins.LookupPlugin;
import com.senior.ui.components.radio.VRadioButton;
import com.senior.ui.components.tree.VTree;
import com.senior.ui.core.ActionCommand;
import com.senior.ui.core.ChangeNode;
import com.senior.ui.ext.action.ExtActionCommand;
import com.senior.ui.ext.renderer.AfterRenderAction;
import com.senior.ui.ext.renderer.BaseButtonRender;
import com.senior.ui.ext.renderer.BasicRender;
import com.senior.ui.ext.renderer.ButtonRender;
import com.senior.ui.ext.renderer.CalendarRender;
import com.senior.ui.ext.renderer.ChangeThemeAction;
import com.senior.ui.ext.renderer.ChangeVisionAction;
import com.senior.ui.ext.renderer.CheckBoxRender;
import com.senior.ui.ext.renderer.CloseModalAction;
import com.senior.ui.ext.renderer.ClosePerspectiveActionRenderer;
import com.senior.ui.ext.renderer.ComboBoxRender;
import com.senior.ui.ext.renderer.CompositeRenderer;
import com.senior.ui.ext.renderer.CreateTimerActionRenderer;
import com.senior.ui.ext.renderer.DestroyTimerActionRenderer;
import com.senior.ui.ext.renderer.DownloadAction;
import com.senior.ui.ext.renderer.EditRender;
import com.senior.ui.ext.renderer.EditableRender;
import com.senior.ui.ext.renderer.EmptyPluginRender;
import com.senior.ui.ext.renderer.FileRender;
import com.senior.ui.ext.renderer.FocusComponentAction;
import com.senior.ui.ext.renderer.FocusCurrentComponentAction;
import com.senior.ui.ext.renderer.GridRender;
import com.senior.ui.ext.renderer.GroupBoxRender;
import com.senior.ui.ext.renderer.IActionRender;
import com.senior.ui.ext.renderer.IExtActionRender;
import com.senior.ui.ext.renderer.ImageRender;
import com.senior.ui.ext.renderer.LabelRender;
import com.senior.ui.ext.renderer.LayoutRender;
import com.senior.ui.ext.renderer.LineRender;
import com.senior.ui.ext.renderer.LogOffActionRenderer;
import com.senior.ui.ext.renderer.LookupPluginRender;
import com.senior.ui.ext.renderer.OpenLinkActionRender;
import com.senior.ui.ext.renderer.OpenURLActionRender;
import com.senior.ui.ext.renderer.OpenURLExtActionRender;
import com.senior.ui.ext.renderer.PanelRender;
import com.senior.ui.ext.renderer.PluginRender;
import com.senior.ui.ext.renderer.RadioButtonRender;
import com.senior.ui.ext.renderer.RearrangeTabOrderAction;
import com.senior.ui.ext.renderer.RedirectActionRender;
import com.senior.ui.ext.renderer.RegisterPerspectiveActionRender;
import com.senior.ui.ext.renderer.RenderAskLater;
import com.senior.ui.ext.renderer.RenderContextAction;
import com.senior.ui.ext.renderer.RenderCurrentMessageAction;
import com.senior.ui.ext.renderer.RenderProcessor;
import com.senior.ui.ext.renderer.RenderServerIdle;
import com.senior.ui.ext.renderer.RenderUserActionDone;
import com.senior.ui.ext.renderer.RepeaterAdjustScrollRender;
import com.senior.ui.ext.renderer.RepeaterRender;
import com.senior.ui.ext.renderer.StartTimerActionRenderer;
import com.senior.ui.ext.renderer.StopTimerActionRenderer;
import com.senior.ui.ext.renderer.StoreRender;
import com.senior.ui.ext.renderer.TabGroupRender;
import com.senior.ui.ext.renderer.TabSheetCompositeRenderer;
import com.senior.ui.ext.renderer.TextAreaRender;
import com.senior.ui.ext.renderer.ToolbarRender;
import com.senior.ui.ext.renderer.TreeRender;
import com.senior.ui.ext.renderer.UnblockAction;
import com.senior.ui.ext.renderer.UpdateTimerActionRenderer;
import com.senior.ui.ext.renderer.UploadActionRenderer;
import com.senior.ui.ext.renderer.ViewPortRender;
import com.senior.ui.ext.renderer.WindowRender;
import com.senior.ui.plugin.Plugin;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

class RenderFactory {
    private static final ComponentProperty[] EMPTY_COMPONENT_PROPERTIES = new ComponentProperty[0];
    private static final Map<Class<? extends VComponent>, RenderProcessor> componentRenders;
    private static final Map<ActionCommand.ActionType, IActionRender> actionRenders;
    private static final Map<ExtActionCommand.ExtActionType, IExtActionRender> extActionRenders;
    private static final HashMap<Class<? extends Plugin>, PluginRender<?>> pluginRenders;
    private static final Map<Class<? extends VComponent>, ComponentProperty[]> singleAssociationProperties;
    private static final Map<Class<? extends VComponent>, ComponentProperty[]> multipleAssociationProperties;
    private static final String LABEL_CSS = "x-senior-label";

    static {
        BasicRender basicRender = new BasicRender();
        CompositeRenderer compositeRenderer = new CompositeRenderer();
        TabSheetCompositeRenderer tabSheetCompositeRenderer = new TabSheetCompositeRenderer();
        EditableRender editableRender = new EditableRender();
        ButtonRender buttonRender = new ButtonRender();
        LayoutRender layoutRender = new LayoutRender();
        EditRender editRender = new EditRender();
        ViewPortRender viewPortRender = new ViewPortRender();
        ComboBoxRender comboboxRender = new ComboBoxRender();
        TabGroupRender tabgroupRender = new TabGroupRender();
        StoreRender storeRender = new StoreRender();
        TreeRender treeRender = new TreeRender();
        PanelRender panelRender = new PanelRender();
        GroupBoxRender groupBoxRender = new GroupBoxRender();
        GridRender gridRender = new GridRender();
        CheckBoxRender checkBoxRender = new CheckBoxRender();
        CalendarRender calendarRender = new CalendarRender();
        LineRender lineRender = new LineRender();
        RadioButtonRender radioButtonRender = new RadioButtonRender();
        RepeaterRender repeaterRender = new RepeaterRender();
        RepeaterAdjustScrollRender repeaterAdjustScrollRender = new RepeaterAdjustScrollRender();
        ToolbarRender toolbarRender = new ToolbarRender();
        WindowRender windowRender = new WindowRender();
        LabelRender labelRender = new LabelRender();
        ImageRender imageRender = new ImageRender();
        TextAreaRender textAreaRender = new TextAreaRender();
        FileRender fileRender = new FileRender();
        BaseButtonRender fileButtonRender = new BaseButtonRender();
        HashMap<Class<? extends VComponent>, Collection<ComponentProperty>> singleAssociationPropertiesMap = new HashMap<Class<? extends VComponent>, Collection<ComponentProperty>>();
        HashMap<Class<? extends VComponent>, Collection<ComponentProperty>> multipleAssociationPropertiesMap = new HashMap<Class<? extends VComponent>, Collection<ComponentProperty>>();
        componentRenders = new HashMap<Class<? extends VComponent>, RenderProcessor>();
        componentRenders.put(VLabel.class, new RenderProcessor("seniorlabel", LABEL_CSS, labelRender, basicRender));
        componentRenders.put(VCheckBox.class, new RenderProcessor("seniorcheckbox", null, checkBoxRender, editableRender, basicRender));
        componentRenders.put(VRadioButton.class, new RenderProcessor("seniorradio", null, radioButtonRender, editableRender, basicRender));
        componentRenders.put(VColorPicker.class, new RenderProcessor("seniorcolorfield", null, editableRender, basicRender));
        componentRenders.put(VEditBox.class, new RenderProcessor(null, null, editRender, editableRender, basicRender));
        componentRenders.put(VButton.class, new RenderProcessor(null, null, buttonRender, basicRender));
        componentRenders.put(VPanel.class, new RenderProcessor("seniorpanel", null, panelRender, layoutRender, compositeRenderer, basicRender));
        componentRenders.put(VViewPort.class, new RenderProcessor("seniorviewport", null, viewPortRender, layoutRender, basicRender, compositeRenderer));
        componentRenders.put(VWindow.class, new RenderProcessor("seniorwindow", null, windowRender, layoutRender, compositeRenderer, basicRender));
        componentRenders.put(VComboBox.class, new RenderProcessor("seniorcombo", null, storeRender, comboboxRender, editableRender, basicRender));
        componentRenders.put(VLine.class, new RenderProcessor("seniorline", null, lineRender, basicRender));
        componentRenders.put(VTabGroup.class, new RenderProcessor("seniortabpanel", null, tabgroupRender, compositeRenderer, basicRender));
        componentRenders.put(VTabSheet.class, new RenderProcessor("seniortabsheet", null, layoutRender, tabSheetCompositeRenderer, basicRender));
        componentRenders.put(VTextArea.class, new RenderProcessor("seniortextarea", null, textAreaRender, editableRender, basicRender));
        componentRenders.put(VImage.class, new RenderProcessor("seniorimage", null, imageRender, editableRender, basicRender));
        componentRenders.put(VRepeater.class, new RenderProcessor("seniorrepeater", null, repeaterRender, layoutRender, compositeRenderer, repeaterAdjustScrollRender, basicRender));
        componentRenders.put(VTree.class, new RenderProcessor("seniortreepanel", null, basicRender, treeRender));
        componentRenders.put(VGroupBox.class, new RenderProcessor("seniorgroupbox", null, groupBoxRender, panelRender, layoutRender, compositeRenderer, basicRender));
        componentRenders.put(VCalendar.class, new RenderProcessor("seniorcalendar", null, calendarRender, editableRender, basicRender));
        componentRenders.put(VScrollGrid.class, new RenderProcessor("senioreditorgrid", null, gridRender, basicRender));
        componentRenders.put(VFrame.class, new RenderProcessor("seniorframe", null, basicRender));
        componentRenders.put(VToolbar.class, new RenderProcessor("seniortoolbar", null, toolbarRender, basicRender));
        componentRenders.put(VFile.class, new RenderProcessor("seniorfile", null, fileRender, editableRender, basicRender));
        componentRenders.put(VFileButton.class, new RenderProcessor(null, null, fileButtonRender, basicRender));
        singleAssociationProperties = RenderFactory.createAssociationPropertiesMap(singleAssociationPropertiesMap);
        multipleAssociationProperties = RenderFactory.createAssociationPropertiesMap(multipleAssociationPropertiesMap);
        actionRenders = new EnumMap<ActionCommand.ActionType, IActionRender>(ActionCommand.ActionType.class);
        actionRenders.put(ActionCommand.ActionType.DOWNLOAD, new DownloadAction());
        actionRenders.put(ActionCommand.ActionType.ALLOW_UPLOAD, new UploadActionRenderer());
        actionRenders.put(ActionCommand.ActionType.CLOSE_MODAL, new CloseModalAction());
        actionRenders.put(ActionCommand.ActionType.FOCUS, new FocusComponentAction());
        actionRenders.put(ActionCommand.ActionType.REARANGE_TAB_ORDER, new RearrangeTabOrderAction());
        actionRenders.put(ActionCommand.ActionType.CHANGE_VIEW, new ChangeVisionAction());
        actionRenders.put(ActionCommand.ActionType.OPEN_LINK, new OpenLinkActionRender());
        actionRenders.put(ActionCommand.ActionType.FOCUS_CURRENT, new FocusCurrentComponentAction());
        actionRenders.put(ActionCommand.ActionType.WAIT_USER_ACTION, new RenderUserActionDone());
        actionRenders.put(ActionCommand.ActionType.CURRENT_MESSAGE_ACTION, new RenderCurrentMessageAction());
        actionRenders.put(ActionCommand.ActionType.OPEN_URL, new OpenURLActionRender());
        actionRenders.put(ActionCommand.ActionType.CLOSE_PERSPECTIVE, new ClosePerspectiveActionRenderer());
        actionRenders.put(ActionCommand.ActionType.CHANGE_THEME, new ChangeThemeAction());
        actionRenders.put(ActionCommand.ActionType.UNBLOCK, new UnblockAction());
        actionRenders.put(ActionCommand.ActionType.LOG_OFF, new LogOffActionRenderer());
        actionRenders.put(ActionCommand.ActionType.CREATE_TIMER, new CreateTimerActionRenderer());
        actionRenders.put(ActionCommand.ActionType.START_TIMER, new StartTimerActionRenderer());
        actionRenders.put(ActionCommand.ActionType.STOP_TIMER, new StopTimerActionRenderer());
        actionRenders.put(ActionCommand.ActionType.UPDATE_TIMER, new UpdateTimerActionRenderer());
        actionRenders.put(ActionCommand.ActionType.DESTROY_TIMER, new DestroyTimerActionRenderer());
        extActionRenders = new EnumMap<ExtActionCommand.ExtActionType, IExtActionRender>(ExtActionCommand.ExtActionType.class);
        extActionRenders.put(ExtActionCommand.ExtActionType.RENDER_CONTEXT, new RenderContextAction());
        extActionRenders.put(ExtActionCommand.ExtActionType.REGISTER_PERSPECTIVE, new RegisterPerspectiveActionRender());
        extActionRenders.put(ExtActionCommand.ExtActionType.OPEN_URL, new OpenURLExtActionRender());
        extActionRenders.put(ExtActionCommand.ExtActionType.ASK_LATER, new RenderAskLater());
        extActionRenders.put(ExtActionCommand.ExtActionType.WAIT_SERVER_IDLE, new RenderServerIdle());
        extActionRenders.put(ExtActionCommand.ExtActionType.REDIRECT, new RedirectActionRender());
        extActionRenders.put(ExtActionCommand.ExtActionType.AFTER_RENDER, new AfterRenderAction());
        PluginRender defaultPluginRender = new PluginRender();
        pluginRenders = new HashMap();
        pluginRenders.put(LookupPlugin.class, new LookupPluginRender());
        pluginRenders.put(ChangeStylePlugin.class, defaultPluginRender);
        pluginRenders.put(DescriptionPlugin.class, defaultPluginRender);
        pluginRenders.put(DateEditBoxFilterPlugin.class, new EmptyPluginRender());
    }

    RenderFactory() {
    }

    private static Map<Class<? extends VComponent>, ComponentProperty[]> createAssociationPropertiesMap(Map<Class<? extends VComponent>, Collection<ComponentProperty>> associationProperties) {
        HashMap<Class<? extends VComponent>, ComponentProperty[]> result = new HashMap<Class<? extends VComponent>, ComponentProperty[]>(associationProperties.size());
        for (Map.Entry<Class<? extends VComponent>, Collection<ComponentProperty>> assocPropEntry : associationProperties.entrySet()) {
            Collection<ComponentProperty> assocsProps = assocPropEntry.getValue();
            result.put(assocPropEntry.getKey(), assocsProps.toArray(new ComponentProperty[assocsProps.size()]));
        }
        return result;
    }

    public static RenderProcessor getRenderProcessor(ChangeNode node) {
        return componentRenders.get(node.getComponent().getClass());
    }

    public static IActionRender getActionRender(ActionCommand command) {
        return actionRenders.get(command.getActionType());
    }

    public static IExtActionRender getExtActionRender(ExtActionCommand command) {
        return extActionRenders.get((Object)command.getActionType());
    }

    public static PluginRender<Plugin> getPluginRender(Plugin plugin) {
        return pluginRenders.get(plugin.getClass());
    }

    public static ComponentProperty[] getComponentSingleAssociationProperties(VComponent cmp) {
        ComponentProperty[] properties = singleAssociationProperties.get(cmp.getClass());
        return properties != null ? properties : EMPTY_COMPONENT_PROPERTIES;
    }

    public static ComponentProperty[] getComponentMultipleAssociationProperties(VComponent cmp) {
        ComponentProperty[] properties = multipleAssociationProperties.get(cmp.getClass());
        return properties != null ? properties : EMPTY_COMPONENT_PROPERTIES;
    }
}

