/*
 * Decompiled with CFR 0.152.
 */
package com.senior.ui.ext.renderer;

import com.senior.ui.components.ComponentProperty;
import com.senior.ui.components.radio.VRadioButton;
import com.senior.ui.core.ChangeNode;
import com.senior.ui.ext.renderer.AbstractRender;
import com.senior.ui.ext.renderer.IComponentRenderer;
import com.senior.ui.ext.renderer.JSONUtility;
import com.senior.ui.ext.renderer.JsUtility;

final class RadioButtonRender
extends AbstractRender {
    public RadioButtonRender() {
        this.properties.put(ComponentProperty.TEXT, "boxLabel");
    }

    @Override
    protected void render(ChangeNode node, JSONUtility util, IComponentRenderer renderer) {
        VRadioButton radioButton = (VRadioButton)node.getComponent();
        if (node.hasPropertyChange(ComponentProperty.CHECKED)) {
            util.key("checked").value(radioButton.isSelected());
            node.clearPropertyChange(ComponentProperty.CHECKED);
        }
        if (node.hasPropertyChange(ComponentProperty.AGGREGATOR_ID)) {
            util.key("name").value(radioButton.getAggregator().getId());
            node.clearPropertyChange(ComponentProperty.AGGREGATOR_ID);
        }
        if (node.hasPropertyChange(ComponentProperty.NAME)) {
            util.key("realName").value(radioButton.getName());
            node.clearPropertyChange(ComponentProperty.NAME);
        }
    }

    @Override
    protected void update(ChangeNode node, JsUtility util, IComponentRenderer renderer) {
        node.clearPropertyChange(ComponentProperty.TEXT);
        VRadioButton radioButton = (VRadioButton)node.getComponent();
        if (!node.hasPropertyChanges() || !radioButton.getVisibleState()) {
            return;
        }
        if (node.hasPropertyChange(ComponentProperty.CHECKED)) {
            util.method("internalSetValue", radioButton.isSelected());
            node.clearPropertyChange(ComponentProperty.CHECKED);
        }
        if (node.hasPropertyChange(ComponentProperty.HAS_ERROR)) {
            util.method("setHasError", radioButton.hasError());
            if (radioButton.hasError()) {
                util.method("markInvalid", new Object[0]);
            } else {
                util.method("clearInvalid", new Object[0]);
            }
            node.clearPropertyChange(ComponentProperty.HAS_ERROR);
        }
        if (node.hasPropertyChange(ComponentProperty.AGGREGATOR_ID)) {
            util.method("setName", radioButton.getAggregator().getId());
            node.clearPropertyChange(ComponentProperty.AGGREGATOR_ID);
        }
        if (node.hasPropertyChange(ComponentProperty.NAME)) {
            util.method("setRealName", radioButton.getName());
            node.clearPropertyChange(ComponentProperty.NAME);
        }
    }
}

