/*
 * Decompiled with CFR 0.152.
 */
package com.senior.ui.ext.renderer;

import com.senior.ui.components.ComponentProperty;
import com.senior.ui.components.VComponent;
import com.senior.ui.components.VPanel;
import com.senior.ui.components.layout.border.BorderLayout;
import com.senior.ui.components.layout.border.BorderLayoutDefinition;
import com.senior.ui.components.layout.card.CardLayout;
import com.senior.ui.core.ChangeNode;
import com.senior.ui.definition.BorderLayoutRegion;
import com.senior.ui.definition.OverflowKind;
import com.senior.ui.ext.renderer.AbstractRender;
import com.senior.ui.ext.renderer.ComponentRenderUtility;
import com.senior.ui.ext.renderer.IComponentRenderer;
import com.senior.ui.ext.renderer.JSONUtility;
import com.senior.ui.ext.renderer.JsUtil;
import com.senior.ui.ext.renderer.JsUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PanelRender
extends AbstractRender {
    PanelRender() {
        this.properties.put(ComponentProperty.COLLAPSED, "collapsed");
        this.properties.put(ComponentProperty.HAS_ERROR, "hasIncorrectChildren");
        this.properties.put(ComponentProperty.HIDE_ORIGINALBAR_ON_SLIDE, "hideOriginalBarOnSlide");
        this.methods.put(ComponentProperty.SHOW_COLLAPSE_BUTTON, "setShowCollapseButton");
    }

    @Override
    protected void render(ChangeNode node, JSONUtility util, IComponentRenderer renderer) {
        VPanel panel = (VPanel)node.getComponent();
        ComponentRenderUtility.setDefaultSizeWhereUndefined((VComponent)panel);
        ChangeNode.ChangeNodeAssociation toolbarAssoc = node.getSingleAssociation(ComponentProperty.TOOLBAR);
        if (toolbarAssoc != null) {
            assert (toolbarAssoc.getStatus() == ChangeNode.ChangeNodeAssociationStatus.ADDED);
            ChangeNode toolbarNode = toolbarAssoc.getReferencedNode();
            util.key("tbar");
            toolbarNode.setPropertyChanges(toolbarNode.getComponent().getDefaultProperties());
            util.instance("Ext.ux.senior.Toolbar").object();
            renderer.render(toolbarNode, util);
            util.end().end();
            toolbarAssoc.markAsRendered();
        }
        if (node.hasPropertyChange(ComponentProperty.OVERFLOW_KIND)) {
            util.key("autoScroll").value(panel.getOverflowKind() == OverflowKind.OVERFLOW_AUTO);
            node.clearPropertyChange(ComponentProperty.OVERFLOW_KIND);
        }
        if (node.hasPropertyChange(ComponentProperty.ALIGNMENT_TITLE_KIND)) {
            util.key("titleAlignment").value(panel.getAlignmentTitle().toString());
            node.clearPropertyChange(ComponentProperty.ALIGNMENT_TITLE_KIND);
        }
        if (node.hasPropertyChange(ComponentProperty.VISIBLE_STATE)) {
            util.key("hidden").value(!panel.getVisibleState());
            node.clearPropertyChange(ComponentProperty.VISIBLE_STATE);
        }
        util.addPlugin("containerfocusplugin");
        Collection collapsedBarComponentsNodes = node.getMultipleAssociations(ComponentProperty.TITLE_BAR_COMPONENTS);
        if (!collapsedBarComponentsNodes.isEmpty()) {
            if (panel.getParent() == null || !(panel.getParent().getLayout() instanceof BorderLayout)) {
                throw new IllegalStateException(String.format("The Ext3 Renderer doesn't support collapsed bar buttons in a panel that is not a child of a container with BorderLayout. Panel id: %s", panel.getId()));
            }
            BorderLayoutDefinition layoutDefinition = (BorderLayoutDefinition)panel.getLayoutDefinition();
            assert (layoutDefinition != null);
            if (layoutDefinition.getRegion() == BorderLayoutRegion.CENTER) {
                throw new IllegalStateException(String.format("The Ext3 Renderer doesn't support collapsed bar buttons in a panel at the center. Panel id: %s", panel.getId()));
            }
            util.key("componentAttachmentTarget").value(panel.getTitleBarComponentVisibility());
            JSONUtility collapsedBarButtonsUtil = JSONUtility.getInstance();
            collapsedBarButtonsUtil.array();
            for (ChangeNode.ChangeNodeAssociation collapsedBarComponentAssoc : collapsedBarComponentsNodes) {
                assert (collapsedBarComponentAssoc.getStatus() == ChangeNode.ChangeNodeAssociationStatus.ADDED);
                collapsedBarButtonsUtil.object();
                renderer.render(collapsedBarComponentAssoc.getReferencedNode(), collapsedBarButtonsUtil);
                VComponent cmp = collapsedBarComponentAssoc.getReferencedNode().getComponent();
                String alignment = VPanel.AlignmentTitleBarComponents.LEFT.toString();
                if (panel.getTitleBarComponents(VPanel.AlignmentTitleBarComponents.RIGHT).contains(cmp)) {
                    alignment = VPanel.AlignmentTitleBarComponents.RIGHT.toString();
                } else if (panel.getTitleBarComponents(VPanel.AlignmentTitleBarComponents.CENTER).contains(cmp)) {
                    alignment = VPanel.AlignmentTitleBarComponents.CENTER.toString();
                }
                collapsedBarButtonsUtil.key("alignment").value(alignment);
                collapsedBarButtonsUtil.key("componentOwner").value(panel.getId());
                collapsedBarButtonsUtil.end();
                collapsedBarComponentAssoc.markAsRendered();
            }
            collapsedBarButtonsUtil.end();
            util.addPlugin(JsUtil.unquotedValue(String.format("new Ext.ux.senior.plugins.PanelToolbarPlugin(%s)", collapsedBarButtonsUtil)));
            JSONUtility.release(collapsedBarButtonsUtil);
        }
    }

    @Override
    protected void update(ChangeNode node, JsUtility util, IComponentRenderer renderer) {
        VPanel.TitleBarComponentVisibility titleBarComponentVisibility;
        VPanel panel = (VPanel)node.getComponent();
        ComponentRenderUtility.setDefaultSizeWhereUndefined((VComponent)panel);
        if (!node.hasChanges() || !panel.getVisibleState()) {
            return;
        }
        if (node.hasPropertyChange(ComponentProperty.COLLAPSED)) {
            if (!panel.isCollapsed()) {
                util.method("expand", false);
            } else {
                util.method("collapse", true);
            }
            node.clearPropertyChange(ComponentProperty.COLLAPSED);
        }
        if (node.hasPropertyChange(ComponentProperty.TOOLBAR_VISIBILITY)) {
            node.clearPropertyChange(ComponentProperty.TOOLBAR_VISIBILITY);
            util.method("showToolbar", panel.getToolbar().getVisibleState());
        }
        if (node.hasPropertyChange(ComponentProperty.HAS_ERROR)) {
            node.clearPropertyChange(ComponentProperty.HAS_ERROR);
            if (panel.getLayout().getClass() == CardLayout.class) {
                util.method("setIncorrectChildren", PanelRender.getIncorrectChildren(panel));
            } else {
                util.method("setHasIncorrectChildren", panel.get(ComponentProperty.HAS_ERROR));
            }
        }
        if ((titleBarComponentVisibility = panel.getTitleBarComponentVisibility()) == VPanel.TitleBarComponentVisibility.ALWAYS || !panel.isAllowCollapse() || titleBarComponentVisibility == VPanel.TitleBarComponentVisibility.ON_COLLAPSED && panel.isCollapsed() || titleBarComponentVisibility == VPanel.TitleBarComponentVisibility.ON_EXPANDED && !panel.isCollapsed()) {
            Collection collapsedBarButtonsNodes = node.getMultipleAssociations(ComponentProperty.TITLE_BAR_COMPONENTS);
            for (ChangeNode.ChangeNodeAssociation collapsedBarButtonAssoc : collapsedBarButtonsNodes) {
                ChangeNode collapsedBarButtonNode = collapsedBarButtonAssoc.getReferencedNode();
                if (collapsedBarButtonAssoc.getStatus() == ChangeNode.ChangeNodeAssociationStatus.ADDED || collapsedBarButtonAssoc.getStatus() == ChangeNode.ChangeNodeAssociationStatus.REMOVED) {
                    throw new IllegalStateException(String.format("Add or remove a button from the collapsed bar is not supported after the panel rendering. Panel id = %s, button id = %s", panel.getId(), collapsedBarButtonNode.getComponent().getId()));
                }
                if (!collapsedBarButtonNode.hasChanges()) continue;
                renderer.update(collapsedBarButtonNode, util);
            }
            ChangeNode.ChangeNodeAssociation toolbarAssoc = node.getSingleAssociation(ComponentProperty.TOOLBAR);
            if (toolbarAssoc != null) {
                ChangeNode toolbarNode = toolbarAssoc.getReferencedNode();
                renderer.update(toolbarNode, util);
            }
        }
    }

    private static List<String> getIncorrectChildren(VPanel owner) {
        List tabs = owner.getChildren();
        ArrayList<String> incorrectChildren = new ArrayList<String>();
        for (VPanel tab : tabs) {
            if (!tab.hasIncorrectChildren()) continue;
            incorrectChildren.add(tab.getId());
        }
        return incorrectChildren;
    }
}

