/*
 * Decompiled with CFR 0.152.
 */
package com.senior.ui.ext.renderer;

import com.senior.ui.components.lookup.LookupEventType;
import com.senior.ui.components.plugins.LookupPlugin;
import com.senior.ui.core.ChangeNode;
import com.senior.ui.ext.renderer.JSONUtility;
import com.senior.ui.ext.renderer.JsUtility;
import com.senior.ui.ext.renderer.PluginRender;
import com.senior.ui.ext.renderer.RendererFlag;
import com.senior.ui.plugin.PluginProperty;
import java.util.Set;

public final class LookupPluginRender<P>
extends PluginRender<LookupPlugin<P>> {
    @Override
    protected void configurePlugin(ChangeNode node, LookupPlugin<P> plugin, JSONUtility util) {
        RendererFlag.IGNORE_MASK_PLUGIN.setFlag(node);
        plugin.consumeRequestedActions();
        util.key("minChars").value(1);
        util.key("searchType").value(plugin.get(PluginProperty.SEARCH_TYPE));
        util.key("queryDelay").value(plugin.get(PluginProperty.SEARCH_TIME));
        String value = (String)plugin.get(PluginProperty.VALUE);
        if (value != null) {
            util.key("value").value(value);
            util.key("backupMatch").value(value);
        }
    }

    @Override
    public void renderAction(ChangeNode node, LookupPlugin<P> plugin, JsUtility util) {
        util.method("setShowingSearchForm", plugin.isShowingSearchForm());
        Set actions = plugin.consumeRequestedActions();
        for (LookupEventType e : actions) {
            switch (e) {
                case GET_OPTIONS: {
                    LookupPluginRender.renderOptions(plugin, util);
                    break;
                }
                case APPLY_MATCH: 
                case GET_MATCH: {
                    LookupPluginRender.renderMatch(plugin, util);
                    break;
                }
            }
        }
        util.method("setShowRefine", plugin.get(PluginProperty.IS_SHOW_REFINE));
    }

    private static <P> void renderMatch(LookupPlugin<P> plugin, JsUtility util) {
        String value = (String)plugin.get(PluginProperty.VALUE);
        value = value == null ? "" : value;
        String context = plugin.getMathContext();
        if (context == null) {
            util.method("setMatch", value);
        } else {
            util.method("setMatch", value, context);
        }
    }

    private static <P> void renderOptions(LookupPlugin<P> plugin, JsUtility util) {
        JSONUtility renderUtil = JSONUtility.getInstance();
        String[] options = (String[])plugin.get(PluginProperty.OPTIONS_VALUE);
        renderUtil.array();
        String[] stringArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            String option = stringArray[n2];
            renderUtil.array().value(option).end();
            ++n2;
        }
        renderUtil.end();
        util.method("loadOptions", renderUtil);
        JSONUtility.release(renderUtil);
    }
}

