/*
 * Decompiled with CFR 0.152.
 */
package com.senior.ui.ext.renderer;

import com.senior.ui.components.ComponentProperty;
import com.senior.ui.components.VComponent;
import com.senior.ui.components.VComposite;
import com.senior.ui.components.VPanel;
import com.senior.ui.components.layout.ILayoutDefinition;
import com.senior.ui.components.layout.ILayoutManager;
import com.senior.ui.components.layout.LayoutDefinitionBase;
import com.senior.ui.components.layout.NullLayout;
import com.senior.ui.components.layout.accordion.AccordionLayout;
import com.senior.ui.components.layout.border.BorderLayout;
import com.senior.ui.components.layout.border.BorderLayoutDefinition;
import com.senior.ui.components.layout.card.CardLayout;
import com.senior.ui.components.layout.flow.FlowLayout;
import com.senior.ui.components.layout.flow.FlowLayoutDefinition;
import com.senior.ui.components.layout.form.FormLayout;
import com.senior.ui.components.layout.grid.GridLayout;
import com.senior.ui.components.layout.grid.GridLayoutDefinition;
import com.senior.ui.core.ChangeNode;
import com.senior.ui.definition.BorderLayoutRegion;
import com.senior.ui.definition.CardLayoutBarPosition;
import com.senior.ui.definition.FlowLayoutDirection;
import com.senior.ui.definition.FlowLayoutVerticalAlignment;
import com.senior.ui.definition.LabelAlignment;
import com.senior.ui.ext.renderer.AbstractRender;
import com.senior.ui.ext.renderer.ComponentRenderUtility;
import com.senior.ui.ext.renderer.IComponentRenderer;
import com.senior.ui.ext.renderer.JSONUtility;
import com.senior.ui.ext.renderer.JsUtility;
import java.util.Arrays;
import java.util.List;

class LayoutRender
extends AbstractRender {
    public LayoutRender() {
        this.methods.put(ComponentProperty.LAYOUT, "setLayout");
        this.properties.put(ComponentProperty.LAYOUT, "layout");
    }

    @Override
    protected void render(ChangeNode node, JSONUtility utility, IComponentRenderer renderer) {
        VComponent cmp = node.getComponent();
        if (node.hasPropertyChange(ComponentProperty.LAYOUT)) {
            node.clearPropertyChange(ComponentProperty.LAYOUT);
            ILayoutManager layout = (ILayoutManager)cmp.get(ComponentProperty.LAYOUT);
            if (layout instanceof BorderLayout) {
                this.renderBorderLayout(utility, cmp);
            } else if (layout instanceof GridLayout) {
                this.renderGridLayout(utility, (GridLayout)layout, cmp);
            } else if (layout instanceof FormLayout) {
                this.renderFormLayout(utility, (FormLayout)layout);
            } else if (layout instanceof AccordionLayout) {
                this.renderAccordionLayout(utility, (AccordionLayout)layout);
            } else if (layout instanceof FlowLayout) {
                this.renderFlowLayout(utility, (FlowLayout)layout);
            } else if (layout instanceof CardLayout) {
                LayoutRender.renderCardLayout(utility, (CardLayout)layout, cmp);
            } else if (layout instanceof NullLayout) {
                this.renderNullLayout(utility);
            }
        }
        utility.addPlugin("layoutplugin");
    }

    @Override
    protected void update(ChangeNode node, JsUtility utility, IComponentRenderer renderer) {
        VComponent cmp = node.getComponent();
        if (!node.hasPropertyChanges() || !cmp.getVisibleState()) {
            return;
        }
        ILayoutManager layout = (ILayoutManager)cmp.get(ComponentProperty.LAYOUT_CHANGED);
        if (node.hasPropertyChange(ComponentProperty.LAYOUT_CHANGED) && layout instanceof CardLayout) {
            LayoutRender.updateCardLayout(utility, (CardLayout)layout);
            node.clearPropertyChange(ComponentProperty.LAYOUT_CHANGED);
        }
    }

    private static void renderMargin(JSONUtility util, LayoutDefinitionBase def) {
        if (def == null) {
            return;
        }
        util.key("defaults").object();
        StringBuilder buf = new StringBuilder();
        buf.append(def.getMarginTop()).append("px ");
        buf.append(def.getMarginRight()).append("px ");
        buf.append(def.getMarginBottom()).append("px ");
        buf.append(def.getMarginLeft()).append("px");
        util.key("margins").value(buf.toString());
        util.end();
    }

    private void renderAccordionLayout(JSONUtility utility, AccordionLayout layout) {
        utility.key(this.propertyName(ComponentProperty.LAYOUT)).value("senioraccordion");
        if (layout.getActiveItem() >= 0) {
            utility.key("activeItem").value(layout.getActiveItem());
        }
        utility.addPlugin("containerfocusplugin");
    }

    private void renderFormLayout(JSONUtility utility, FormLayout layout) {
        utility.key(this.propertyName(ComponentProperty.LAYOUT)).value("seniorform");
        String align = "";
        LabelAlignment labelAlignment = layout.getLabelAlignment();
        switch (labelAlignment) {
            case LEFT: {
                align = "left";
                break;
            }
            case RIGHT: {
                align = "right";
                break;
            }
            case TOP: {
                align = "top";
                break;
            }
        }
        utility.key("labelAlign").value(align);
        utility.key("labelWidth").value(layout.getLabelWidth());
        utility.key("labelSeparator").value(layout.getLabelSeparator());
        utility.key("labelPad").objectValue(3);
        utility.key("layoutConfig").object();
        utility.key("trackLabels").objectValue("true");
        utility.end();
        LayoutRender.renderMargin(utility, (LayoutDefinitionBase)layout.getDefaultLayoutDefinition());
    }

    private void renderFlowLayout(JSONUtility utility, FlowLayout layout) {
        FlowLayoutDefinition defaultLayoutDefinition = layout.getDefaultLayoutDefinition();
        if (layout.isWrapLine()) {
            utility.key(this.propertyName(ComponentProperty.LAYOUT)).value("seniorflowlayout");
            if (defaultLayoutDefinition != null) {
                defaultLayoutDefinition.setMarginTop(0);
                defaultLayoutDefinition.setMarginBottom(0);
            }
            utility.key("layoutConfig").object();
            if (layout.getAlignment() == FlowLayoutDirection.LEFT_TO_RIGHT) {
                utility.key("horizontalAlign").value("left");
            } else if (layout.getAlignment() == FlowLayoutDirection.RIGHT_TO_LEFT) {
                utility.key("horizontalAlign").value("right");
            }
        } else {
            utility.key(this.propertyName(ComponentProperty.LAYOUT)).value("seniorhboxlayout");
            utility.key("layoutConfig").object();
            if (layout.getVerticalAlignment() == FlowLayoutVerticalAlignment.MIDDLE) {
                utility.key("align").value("middle");
            }
            if (layout.getAlignment() == FlowLayoutDirection.LEFT_TO_RIGHT) {
                utility.key("pack").value("start");
            } else if (layout.getAlignment() == FlowLayoutDirection.RIGHT_TO_LEFT) {
                utility.key("pack").value("end");
            }
        }
        utility.end();
        LayoutRender.renderMargin(utility, (LayoutDefinitionBase)defaultLayoutDefinition);
    }

    private void renderGridLayout(JSONUtility utility, GridLayout layout, VComponent cmp) {
        utility.key(this.propertyName(ComponentProperty.LAYOUT)).value("seniortable");
        utility.key("layoutConfig").object();
        LayoutRender.configureFit(utility, "100%", layout.isFit() ? "100%" : "0%");
        int columns = layout.getColumns();
        String[] columnWidths = layout.getColumnWidths();
        String[] newColumnWidths = new String[columns];
        List children = ((VComposite)cmp).getChildren();
        int columnWidthsLength = columnWidths.length;
        utility.key("columns").value(columns);
        int curColumn = 0;
        int[] maxWidths = new int[columns];
        Arrays.fill(maxWidths, -1);
        int i = 0;
        while (i < children.size()) {
            int colspan;
            VComponent child = (VComponent)children.get(i);
            GridLayoutDefinition definition = (GridLayoutDefinition)ComponentRenderUtility.getLayoutDefinition(child);
            int n = colspan = definition == null ? 1 : definition.getColSpan();
            if (curColumn >= columnWidthsLength || columnWidths[curColumn].trim().equals("")) {
                String width = child.getWidth();
                if (colspan == 1 && width != null && !width.equals("") && width.charAt(width.length() - 1) != '%') {
                    int cmpWidth;
                    if (width.endsWith("px")) {
                        width = width.substring(0, width.length() - 2);
                    }
                    if ((cmpWidth = Integer.parseInt(width)) > maxWidths[curColumn]) {
                        ILayoutDefinition def = ComponentRenderUtility.getLayoutDefinition(child);
                        if (def instanceof LayoutDefinitionBase) {
                            int[] margins = ComponentRenderUtility.getOverriddenMargins(child, (LayoutDefinitionBase)def);
                            cmpWidth += margins[1] + margins[3];
                        }
                        maxWidths[curColumn] = cmpWidth;
                    }
                }
            } else {
                newColumnWidths[curColumn] = columnWidths[curColumn];
            }
            curColumn = colspan > 1 ? (curColumn += colspan) : ++curColumn;
            if (curColumn >= columns) {
                curColumn = 0;
            }
            ++i;
        }
        i = 0;
        while (i < columns) {
            if (maxWidths[i] != -1) {
                newColumnWidths[i] = String.valueOf(maxWidths[i]);
            } else if (newColumnWidths[i] == null) {
                newColumnWidths[i] = "";
            }
            ++i;
        }
        layout.setColumnWidths(newColumnWidths);
        if (layout.getColumnWidths().length > 0) {
            utility.key("columnWidths").array();
            String[] stringArray = layout.getColumnWidths();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String width = stringArray[n2];
                if (!width.equals("") && width.charAt(width.length() - 1) != '%' && !width.endsWith("px")) {
                    width = width.concat("px");
                }
                utility.value(width);
                ++n2;
            }
            utility.end();
        }
        utility.end();
        LayoutRender.renderMargin(utility, (LayoutDefinitionBase)layout.getDefaultLayoutDefinition());
    }

    private static void configureFit(JSONUtility utility, String widthValue, String heightValue) {
        utility.key("tableAttrs").object();
        utility.key("style").object();
        utility.key("width").value(widthValue);
        utility.key("height").value(heightValue);
        utility.end().end();
        utility.key("fit").value("true");
    }

    private static void renderCardLayout(JSONUtility utility, CardLayout layout, VComponent cmp) {
        CardLayoutBarPosition barPosition = layout.getBarPosition();
        int activeTab = layout.getCurrentTab();
        utility.key("xtype").value("seniortabpanel");
        utility.key("activeTab").value(activeTab);
        utility.key("tabWidth").value(layout.getTabWidth());
        utility.key("tabPosition").value(String.valueOf(barPosition).toLowerCase());
        utility.addPlugin("componentfocusplugin");
        if (cmp instanceof VPanel) {
            utility.key("hideBorders").value(((VPanel)cmp).isShowBorder());
        }
    }

    private static void updateCardLayout(JsUtility utility, CardLayout layout) {
        int currentTab = layout.getCurrentTab();
        if (currentTab > -1) {
            utility.method("setActiveTab", currentTab);
        }
    }

    private void renderBorderLayout(JSONUtility utility, VComponent cmp) {
        boolean hasCenter = false;
        if (cmp instanceof VComposite) {
            VComposite container = (VComposite)cmp;
            List children = container.getChildren();
            for (VComponent child : children) {
                BorderLayoutDefinition borderLayoutDefinition;
                ILayoutDefinition layoutDefinition = child.getLayoutDefinition();
                if (!(layoutDefinition instanceof BorderLayoutDefinition) || !(borderLayoutDefinition = (BorderLayoutDefinition)layoutDefinition).getRegion().equals((Object)BorderLayoutRegion.CENTER)) continue;
                hasCenter = true;
                break;
            }
            if (!hasCenter) {
                VPanel panelCenter = new VPanel("pnCenterBorderLayout", false);
                BorderLayoutDefinition borderLayoutDefinition = new BorderLayoutDefinition(BorderLayoutRegion.CENTER);
                panelCenter.setLayout((ILayoutManager)new FormLayout());
                panelCenter.setLayoutDefinition((ILayoutDefinition)borderLayoutDefinition);
                container.addChild((VComponent)panelCenter);
            }
        }
        utility.key(this.propertyName(ComponentProperty.LAYOUT)).value("seniorborder");
    }

    private void renderNullLayout(JSONUtility utility) {
        utility.key(this.propertyName(ComponentProperty.LAYOUT)).value("seniorabsolute");
    }
}

