/*
 * Decompiled with CFR 0.152.
 */
package com.senior.ui.ext.renderer;

import com.senior.FrameworkProperty;
import com.senior.ui.ext.renderer.JsUtil;
import com.senior.ui.ext.renderer.JsVariableIndentifierGeneratorProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class JsUtility {
    private StringBuilder script;
    private String currentScopeSentence;
    private String currentScopeVar;
    private Object[] currentScopeParams;
    private Stack<String> scopes;
    private Stack<String> scopesSentences;
    private Stack<Object[]> scopesParams;
    private List<String> varsToFinish;
    private ArrayList<String> dynamicClassScripts;

    public void initialize() {
        this.script = new StringBuilder();
    }

    public void setOutput(StringBuilder output) {
        this.script = output;
    }

    public void clear() {
        this.dynamicClassScripts = null;
        if (this.scopes != null) {
            this.scopes.clear();
        }
        if (this.scopesSentences != null) {
            this.scopesSentences.clear();
        }
        if (this.scopesParams != null) {
            this.scopesParams.clear();
        }
        this.varsToFinish = null;
        this.script = null;
        this.currentScopeVar = null;
        this.currentScopeSentence = null;
    }

    public JsUtility(StringBuilder sb, String name, String sentence, Object ... args) {
        this.currentScopeVar = name;
        this.currentScopeSentence = sentence;
        this.script = sb;
    }

    public JsUtility newScope(String sentence, Object ... args) {
        if (this.currentScopeSentence != null) {
            if (this.scopes == null) {
                this.scopes = new Stack();
                this.scopesSentences = new Stack();
                this.scopesParams = new Stack();
            }
            this.scopes.push(this.currentScopeVar);
            this.scopesSentences.push(this.currentScopeSentence);
            this.scopesParams.push(this.currentScopeParams);
        }
        this.currentScopeVar = null;
        this.currentScopeSentence = sentence;
        this.currentScopeParams = args;
        return this;
    }

    public void closeScope() {
        if (this.scopes != null) {
            if (this.scopes.isEmpty()) {
                this.currentScopeVar = null;
                this.currentScopeSentence = null;
                this.currentScopeParams = null;
            } else {
                this.currentScopeVar = this.scopes.pop();
                this.currentScopeSentence = this.scopesSentences.pop();
                this.currentScopeParams = this.scopesParams.pop();
            }
        }
    }

    private static String identifier() {
        return JsVariableIndentifierGeneratorProvider.getJsVariableComponentIdentifierGenerator().nextId();
    }

    public void addDynamicCSS(String cssDefinition) {
        if (!StringUtils.isBlank((String)cssDefinition)) {
            this.getDynamicClassScripts().remove(cssDefinition);
            this.dynamicClassScripts.add(cssDefinition);
        }
    }

    private void addDynamicCSS(ArrayList<String> cssDefinition) {
        if (!CollectionUtils.isEmpty(cssDefinition)) {
            this.getDynamicClassScripts().removeAll(cssDefinition);
            this.dynamicClassScripts.addAll(cssDefinition);
        }
    }

    public JsUtility method(String method, Object ... params) {
        this.declareVariable();
        this.internalMethod(this.currentScopeVar, method, params);
        return this;
    }

    public JsUtility objMethod(String id, String method, Object ... params) {
        this.internalMethod(id, method, params);
        return this;
    }

    private void internalMethod(String id, String method, Object ... params) {
        if (id != null) {
            this.script.append(id).append('.');
        }
        this.script.append(method);
        if (params == null) {
            this.script.append("(null);").append((CharSequence)JsUtilityHelper.getNewLine());
        } else if (params.length > 0) {
            this.script.append('(');
            Object[] objectArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                Object param = objectArray[n2];
                this.script.append(JsUtil.value(param));
                this.script.append(',');
                ++n2;
            }
            this.script.setCharAt(this.script.length() - 1, ')');
            this.script.append(';').append((CharSequence)JsUtilityHelper.getNewLine());
        } else {
            this.script.append("();").append((CharSequence)JsUtilityHelper.getNewLine());
        }
    }

    private List<String> getVarsToFinish() {
        if (this.varsToFinish == null) {
            this.varsToFinish = new ArrayList<String>();
        }
        return this.varsToFinish;
    }

    private List<String> getDynamicClassScripts() {
        if (this.dynamicClassScripts == null) {
            this.dynamicClassScripts = new ArrayList();
        }
        return this.dynamicClassScripts;
    }

    private JsUtility declareVariable() {
        if (this.currentScopeVar == null) {
            this.currentScopeVar = JsUtility.identifier();
            this.getVarsToFinish().add(this.currentScopeVar);
            this.script.append("var ").append(this.currentScopeVar).append(" = ");
            this.internalMethod(null, this.currentScopeSentence, this.currentScopeParams);
        }
        return this;
    }

    public JsUtility scopedSentenceVar(String sentence, Object ... args) {
        this.declareVariable();
        sentence = String.format("%s.%s", this.currentScopeVar, sentence);
        this.newScope(sentence, args);
        return this;
    }

    public JsUtility attribute(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name cannot be null");
        }
        this.declareVariable();
        this.script.append(this.currentScopeVar).append('.').append(name).append('=').append(JsUtil.value(value)).append(';').append((CharSequence)JsUtilityHelper.getNewLine());
        return this;
    }

    public JsUtility extCmp(String id) {
        this.newScope("Ext.getCmp", id);
        return this;
    }

    public Object getCurrentVar() {
        this.declareVariable();
        return JsUtil.unquotedValue(this.currentScopeVar);
    }

    public void finish() {
        if (this.varsToFinish != null) {
            for (String var : this.varsToFinish) {
                this.clearVar(var);
            }
        }
        this.clear();
    }

    public void generateCSSStyle() {
        if (!CollectionUtils.isEmpty(this.dynamicClassScripts)) {
            StringBuilder styleSheet = new StringBuilder();
            styleSheet.append("StyleHelper.createClass(\"dynamicCss\", \"");
            for (String css : this.dynamicClassScripts) {
                styleSheet.append(css);
                styleSheet.append(" ");
            }
            styleSheet.append("\");");
            this.script.insert(0, styleSheet.append(JsUtilityHelper.getNewLine().toString()));
        }
    }

    public void append(JsUtility utility) {
        this.appendDynamicCss(utility);
        if (!CollectionUtils.isEmpty(utility.varsToFinish)) {
            this.getVarsToFinish().addAll(utility.varsToFinish);
        }
        this.script.append((CharSequence)utility.script);
    }

    private void clearVar(String var) {
        if (var != null) {
            this.script.append(var).append(" = null;").append((CharSequence)JsUtilityHelper.getNewLine());
        }
    }

    public String toString() {
        if (this.script != null) {
            return this.script.toString();
        }
        return "";
    }

    public void appendDynamicCss(JsUtility cmpJs) {
        this.addDynamicCSS(cmpJs.dynamicClassScripts);
    }

    private static final class JsUtilityHelper {
        private static final StringBuilder newLine = new StringBuilder();

        static {
            if (Integer.parseInt(FrameworkProperty.FORMCENTER_DEBUG_LEVEL.get()) > 0) {
                newLine.append("\n");
            }
        }

        private JsUtilityHelper() {
        }

        static StringBuilder getNewLine() {
            return newLine;
        }
    }
}

