/*
 * Decompiled with CFR 0.152.
 */
package com.senior.ui.ext.renderer;

import com.senior.ui.ext.renderer.JsUtil;
import com.senior.ui.ext.renderer.JsUtility;
import com.senior.util.Context;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JSONUtility {
    private static final String CONTEXT_KEY = JSONUtility.class.getName();
    private static final int INSTANCES_QUANTITY = 15;
    private final LinkedList<JSONToken> syntax = new LinkedList();
    private StringBuilder jsonModel = new StringBuilder();
    private List<Object> plugins;
    private Map<String, String> styles;
    private JsUtility beforeScripts;
    private JsUtility afterScripts;

    private JSONUtility() {
    }

    public static JSONUtility getInstance() {
        JSONUtility utility;
        List<JSONUtility> utilityList = JSONUtility.getInstancesList();
        if (utilityList.isEmpty()) {
            utility = new JSONUtility();
        } else {
            utility = utilityList.remove(0);
            utility.initialize();
        }
        return utility;
    }

    public static void release(JSONUtility utility) {
        List<JSONUtility> utilityList = JSONUtility.getInstancesList();
        if (utilityList.size() <= 15) {
            utility.clear();
            utilityList.add(utility);
        }
    }

    private static List<JSONUtility> getInstancesList() {
        ArrayList utilityList = (ArrayList)Context.current().get(CONTEXT_KEY);
        if (utilityList == null) {
            utilityList = new ArrayList(15);
            Context.current().put(CONTEXT_KEY, utilityList);
        }
        return utilityList;
    }

    public void initialize() {
        this.jsonModel = new StringBuilder();
        if (this.beforeScripts != null) {
            this.beforeScripts.initialize();
        }
        if (this.afterScripts != null) {
            this.afterScripts.initialize();
        }
    }

    public void clear() {
        this.jsonModel = null;
        this.syntax.clear();
        this.plugins = null;
        if (this.styles != null) {
            this.styles.clear();
        }
        if (this.beforeScripts != null) {
            this.beforeScripts.clear();
        }
        if (this.afterScripts != null) {
            this.afterScripts.clear();
        }
    }

    private void push(JSONToken token) {
        this.syntax.push(token);
    }

    private JSONToken pop() {
        return this.syntax.pop();
    }

    private JSONToken peek() {
        return this.syntax.peek();
    }

    public JSONUtility array() {
        JSONToken state = this.peek();
        if (state != null) {
            switch (state) {
                case array: {
                    this.append(",");
                    break;
                }
                case begin_array: {
                    this.pop();
                    this.push(JSONToken.array);
                    break;
                }
            }
        }
        this.push(JSONToken.begin_array);
        this.append("[");
        return this;
    }

    public JSONUtility object() {
        JSONToken state = this.peek();
        if (state != null) {
            switch (state) {
                case array: {
                    this.append(",");
                    break;
                }
                case begin_object: {
                    this.pop();
                    this.push(JSONToken.object);
                    break;
                }
                case begin_array: {
                    this.pop();
                    this.push(JSONToken.array);
                    break;
                }
            }
        }
        this.push(JSONToken.begin_object);
        this.append("{");
        return this;
    }

    private StringBuilder append(Object value) {
        return this.jsonModel.append(value);
    }

    public JSONUtility key(String keyStr) {
        JSONToken state = this.peek();
        if (state != null) {
            switch (state) {
                case object: 
                case instance: {
                    this.append(",");
                    break;
                }
                case begin_instance: {
                    this.pop();
                    this.push(JSONToken.instance);
                    break;
                }
                case begin_object: {
                    this.pop();
                    this.push(JSONToken.object);
                    break;
                }
            }
        }
        this.append("\"").append(keyStr).append("\":");
        return this;
    }

    public JSONUtility raw(String raw) {
        this.append(raw);
        return this;
    }

    public JSONUtility value(Object value) {
        this.objectValue(JsUtil.value(value));
        return this;
    }

    JSONUtility objectValue(Object value) {
        JSONToken state = this.peek();
        if (state != null) {
            switch (state) {
                case array: {
                    this.append(",");
                    break;
                }
                case begin_array: {
                    this.pop();
                    this.push(JSONToken.array);
                    break;
                }
            }
        }
        this.append(value);
        return this;
    }

    JSONUtility instance(String className) {
        this.objectValue("new ".concat(className).concat("("));
        this.push(JSONToken.instance);
        return this;
    }

    public JSONUtility end() {
        JSONToken token = this.pop();
        switch (token) {
            case begin_array: 
            case array: {
                this.append("]");
                break;
            }
            case begin_object: 
            case object: {
                this.append("}");
                break;
            }
            case begin_instance: 
            case instance: {
                this.append(")");
                break;
            }
        }
        return this;
    }

    private String finish() {
        if (this.syntax.size() > 0) {
            throw new IllegalStateException(String.format("You must close the pendent syntax, of this json. Syntax: %s", this.syntax.toString()));
        }
        return this.jsonModel.toString();
    }

    void addPlugin(Object plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException("Plugin can't be null");
        }
        if (this.plugins == null) {
            this.plugins = new ArrayList<Object>();
        }
        this.plugins.add(plugin);
    }

    private void renderPlugins() {
        this.key("plugins").array();
        if (this.plugins != null) {
            for (Object o : this.plugins) {
                this.value(o);
            }
            this.plugins = null;
        }
        this.end();
    }

    public JsUtility getAfterScripts() {
        if (this.afterScripts == null) {
            this.afterScripts = new JsUtility(new StringBuilder(), null, null, new Object[0]);
        }
        return this.afterScripts;
    }

    public JsUtility getBeforeScripts() {
        if (this.beforeScripts == null) {
            this.beforeScripts = new JsUtility(new StringBuilder(), null, null, new Object[0]);
        }
        return this.beforeScripts;
    }

    public boolean hasBeforeScripts() {
        return this.beforeScripts != null;
    }

    public boolean hasAfterScripts() {
        return this.afterScripts != null;
    }

    void addStyle(String style, String value) {
        if (this.styles == null) {
            this.styles = new HashMap<String, String>();
        }
        this.styles.put(style, value);
    }

    private void renderStyles() {
        if (this.styles != null) {
            if (this.styles.entrySet().size() > 0) {
                this.key("style").value(this.styles);
            }
            this.styles = null;
        }
    }

    void renderDependencies() {
        this.renderPlugins();
        this.renderStyles();
    }

    public String toString() {
        return this.finish();
    }

    private static enum JSONToken {
        begin_array,
        array,
        begin_object,
        object,
        begin_instance,
        instance;

    }
}

