/*
 * Decompiled with CFR 0.152.
 */
package com.senior.ui.ext.renderer;

import com.senior.ui.components.Hint;
import com.senior.ui.components.IFieldDataDescriptor;
import com.senior.ui.components.grid.IGridRecord;
import com.senior.ui.components.grid.VScrollGrid;
import com.senior.ui.core.theme.StyleScope;
import com.senior.ui.ext.renderer.AbstractRender;
import com.senior.ui.ext.renderer.JSONUtility;
import com.senior.ui.ext.renderer.JsUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

final class GridCustomizationRender {
    private final VScrollGrid grid;
    private final Map<String, String> classesToCreate;
    private final List<RowCustomization> rowCustomizations;
    private final List<RowCustomization> selectedRowCustomizations;
    private final List<RowCustomization> focusedRowCustomizations;
    private final List<ColumnCustomization> columnCustomizations;

    GridCustomizationRender(VScrollGrid grid) {
        this.grid = grid;
        this.columnCustomizations = new ArrayList<ColumnCustomization>(grid.getColumns().size());
        this.rowCustomizations = new ArrayList<RowCustomization>();
        this.selectedRowCustomizations = new ArrayList<RowCustomization>(5);
        this.focusedRowCustomizations = new ArrayList<RowCustomization>(5);
        this.classesToCreate = new HashMap<String, String>(5);
        this.processColumnCustomizations();
        this.processRowCustomizations();
    }

    JSONUtility getCustomizations() {
        JSONUtility allRowsCustomUtil;
        JSONUtility util = JSONUtility.getInstance();
        util.object();
        JSONUtility colCustomUtil = this.renderColumnCustomizations();
        if (colCustomUtil != null) {
            util.key("colCustomizations").value(colCustomUtil);
            JSONUtility.release(colCustomUtil);
        }
        if ((allRowsCustomUtil = this.renderRowCustomizations(RowCustomizationType.NONE)) != null) {
            util.key("rowCustomizations").value(allRowsCustomUtil);
            JSONUtility.release(allRowsCustomUtil);
        }
        util.end();
        return util;
    }

    JSONUtility getFocusCustomizations() {
        JSONUtility util = JSONUtility.getInstance();
        util.object();
        JSONUtility selectedRowsCustomUtil = this.renderRowCustomizations(RowCustomizationType.SELECTED);
        JSONUtility focusedRowsCustomUtil = this.renderRowCustomizations(RowCustomizationType.FOCUSED);
        if (selectedRowsCustomUtil != null) {
            util.key("selectedCustomizations").value(selectedRowsCustomUtil);
            JSONUtility.release(selectedRowsCustomUtil);
        }
        if (focusedRowsCustomUtil != null) {
            util.key("focusedCustomizations").value(focusedRowsCustomUtil);
            JSONUtility.release(focusedRowsCustomUtil);
        }
        util.end();
        return util;
    }

    void renderStyleClassesToCreate(JsUtility utility) {
        if (!this.classesToCreate.isEmpty()) {
            for (String cssContent : this.classesToCreate.values()) {
                utility.addDynamicCSS(cssContent);
            }
        }
    }

    private JSONUtility renderRowCustomizations(RowCustomizationType type) {
        List<RowCustomization> customizations;
        switch (type) {
            case SELECTED: {
                customizations = this.selectedRowCustomizations;
                break;
            }
            case FOCUSED: {
                customizations = this.focusedRowCustomizations;
                break;
            }
            default: {
                customizations = this.rowCustomizations;
            }
        }
        JSONUtility allRowsCustomUtil = JSONUtility.getInstance().object();
        for (RowCustomization customization : customizations) {
            JSONUtility cellCustomUtil;
            JSONUtility rowCustomUtil = JSONUtility.getInstance().object();
            if (!customization.getHints().isEmpty() || StringUtils.isNotBlank((String)customization.getStyle())) {
                this.applyCustomization("rowCustomization", customization.getStyle(), customization.getHints(), rowCustomUtil);
            }
            if ((cellCustomUtil = this.renderCellCustomizations(customization.cellCustomizations)) != null) {
                rowCustomUtil.key("cellCustomizations").value(cellCustomUtil);
                JSONUtility.release(cellCustomUtil);
            }
            rowCustomUtil.end();
            allRowsCustomUtil.key(String.valueOf(customization.getRecordId())).value(rowCustomUtil);
            JSONUtility.release(rowCustomUtil);
        }
        allRowsCustomUtil.end();
        if (customizations.isEmpty()) {
            JSONUtility.release(allRowsCustomUtil);
            return null;
        }
        return allRowsCustomUtil;
    }

    private JSONUtility renderCellCustomizations(List<CellCustomization> cellCustomizations) {
        if (cellCustomizations == null || cellCustomizations.isEmpty()) {
            return null;
        }
        JSONUtility cellCustomUtil = JSONUtility.getInstance().object();
        for (CellCustomization cellCustomization : cellCustomizations) {
            if (!StringUtils.isNotBlank((String)cellCustomization.getStyle()) && cellCustomization.getHints().isEmpty()) continue;
            this.applyCustomization(cellCustomization.getField(), cellCustomization.getStyle(), cellCustomization.getHints(), cellCustomUtil);
        }
        cellCustomUtil.end();
        if (cellCustomizations.isEmpty()) {
            JSONUtility.release(cellCustomUtil);
            return null;
        }
        return cellCustomUtil;
    }

    private JSONUtility renderColumnCustomizations() {
        JSONUtility colCustomUtil = JSONUtility.getInstance().object();
        for (ColumnCustomization colCustomization : this.columnCustomizations) {
            if (colCustomization.getHints().isEmpty() && !StringUtils.isNotBlank((String)colCustomization.getStyle())) continue;
            this.applyCustomization(colCustomization.getField(), colCustomization.getStyle(), colCustomization.getHints(), colCustomUtil);
        }
        colCustomUtil.end();
        if (this.columnCustomizations.isEmpty()) {
            JSONUtility.release(colCustomUtil);
            return null;
        }
        return colCustomUtil;
    }

    private void processColumnCustomizations() {
        for (IFieldDataDescriptor field : this.grid.getGridModel().getFields()) {
            String[] cssClass;
            boolean hasStyle;
            String fieldName = field.getFieldName();
            Object[] styleNames = this.grid.getColStyle(fieldName);
            List hints = this.grid.getColHints(fieldName);
            boolean bl = hasStyle = !ArrayUtils.isEmpty((Object[])styleNames);
            if (!hasStyle && hints == null) continue;
            String className = null;
            if (hasStyle && (cssClass = AbstractRender.buildCssClass((String[])styleNames, EnumSet.of(StyleScope.GRID_COLUMN))) != null) {
                className = cssClass[0];
                this.classesToCreate.put(className, cssClass[1]);
            }
            this.columnCustomizations.add(new ColumnCustomization(fieldName, className, hints));
        }
    }

    private void processRowCustomizations() {
        List gridData = this.grid.getData();
        int rowIndex = 0;
        while (rowIndex < gridData.size()) {
            IGridRecord record = (IGridRecord)gridData.get(rowIndex);
            Object[] styleNames = this.grid.getRowStyle(record);
            List hints = this.grid.getRowHints(record);
            boolean hasStyle = !ArrayUtils.isEmpty((Object[])styleNames);
            RowCustomization selectedCustomization = null;
            RowCustomization customization = null;
            if (hasStyle || hints != null) {
                String className = null;
                if (hasStyle) {
                    String[] focusedCssClass;
                    String[] selectedCssClass;
                    String[] cssClass = AbstractRender.buildCssClass((String[])styleNames, EnumSet.of(StyleScope.GRID_ROW));
                    if (cssClass != null) {
                        className = cssClass[0];
                        this.classesToCreate.put(className, cssClass[1]);
                    }
                    if ((selectedCssClass = AbstractRender.buildCssClass((String[])styleNames, EnumSet.of(StyleScope.GRID_ROW_SELECTED))) != null) {
                        this.classesToCreate.put(selectedCssClass[0], selectedCssClass[1]);
                        selectedCustomization = new RowCustomization(record.getId(), selectedCssClass[0], Collections.emptyList());
                        this.selectedRowCustomizations.add(selectedCustomization);
                    }
                    if ((focusedCssClass = AbstractRender.buildCssClass((String[])styleNames, EnumSet.of(StyleScope.GRID_ROW_FOCUSED))) != null) {
                        this.classesToCreate.put(focusedCssClass[0], focusedCssClass[1]);
                        this.focusedRowCustomizations.add(new RowCustomization(record.getId(), focusedCssClass[0], Collections.emptyList()));
                    }
                }
                customization = new RowCustomization(record.getId(), className, hints);
                this.rowCustomizations.add(customization);
            } else {
                customization = new RowCustomization(record.getId(), null, null);
            }
            if (selectedCustomization == null) {
                selectedCustomization = new RowCustomization(record.getId(), null, null);
            }
            this.processCellCustomizations(record, customization, selectedCustomization);
            ++rowIndex;
        }
    }

    private void processCellCustomizations(IGridRecord record, RowCustomization rowCustomization, RowCustomization focusedCustomization) {
        for (IFieldDataDescriptor field : this.grid.getGridModel().getFields()) {
            boolean hasStyle;
            String fieldName = field.getFieldName();
            Object[] styleNames = this.grid.getCellStyle(field, record);
            List hints = this.grid.getCellHints(field, record);
            boolean bl = hasStyle = !ArrayUtils.isEmpty((Object[])styleNames);
            if (!hasStyle && hints.isEmpty()) continue;
            String className = null;
            if (hasStyle) {
                String[] focusCssClass;
                String[] cssClass = AbstractRender.buildCssClass((String[])styleNames, EnumSet.of(StyleScope.GRID_CELL));
                if (cssClass != null) {
                    className = cssClass[0];
                    this.classesToCreate.put(className, cssClass[1]);
                }
                if ((focusCssClass = AbstractRender.buildCssClass((String[])styleNames, EnumSet.of(StyleScope.GRID_CELL_FOCUSED))) != null) {
                    this.classesToCreate.put(focusCssClass[0], focusCssClass[1]);
                    focusedCustomization.cellCustomizations.add(new CellCustomization(record.getId(), fieldName, focusCssClass[0], Collections.emptyList()));
                    if (!this.selectedRowCustomizations.contains(focusedCustomization)) {
                        this.selectedRowCustomizations.add(focusedCustomization);
                    }
                }
            }
            rowCustomization.cellCustomizations.add(new CellCustomization(record.getId(), fieldName, className, hints));
            if (this.rowCustomizations.contains(rowCustomization)) continue;
            this.rowCustomizations.add(rowCustomization);
        }
    }

    private void applyCustomization(String key, String style, List<Hint> hints, JSONUtility util) {
        boolean hasHints = hints != null && !hints.isEmpty();
        boolean hasStyle = StringUtils.isNotBlank((String)style);
        util.key(key).object();
        if (hasStyle) {
            util.key("style").value(style);
        }
        if (hasHints) {
            util.key("hints");
            AbstractRender.renderHints(util, hints);
        }
        util.end();
    }

    private static abstract class BaseCustomization {
        private final String style;
        private final List<Hint> hints;

        BaseCustomization(String style, List<Hint> hints) {
            this.style = style == null ? "" : style;
            this.hints = hints == null ? Collections.emptyList() : hints;
        }

        String getStyle() {
            return this.style;
        }

        List<Hint> getHints() {
            return this.hints;
        }
    }

    private static class CellCustomization
    extends ColumnCustomization {
        private final int recordId;

        CellCustomization(int recordId, String field, String style, List<Hint> hints) {
            super(field, style, hints);
            this.recordId = recordId;
        }

        int getRecordId() {
            return this.recordId;
        }

        public String toString() {
            return "CellCustomization [recordId=" + this.getRecordId() + ", Field=" + this.getField() + ", Style=" + this.getStyle() + ", Hints=" + this.getHints() + "]";
        }
    }

    private static class ColumnCustomization
    extends BaseCustomization {
        private final String field;

        ColumnCustomization(String field, String style, List<Hint> hints) {
            super(style, hints);
            this.field = field;
        }

        String getField() {
            return this.field;
        }
    }

    private static class RowCustomization
    extends BaseCustomization {
        private final int recordId;
        private final List<CellCustomization> cellCustomizations;

        RowCustomization(int recordId, String style, List<Hint> hints) {
            super(style, hints);
            this.recordId = recordId;
            this.cellCustomizations = new ArrayList<CellCustomization>();
        }

        int getRecordId() {
            return this.recordId;
        }
    }

    private static enum RowCustomizationType {
        NONE,
        SELECTED,
        FOCUSED;

    }
}

