/*
 * Decompiled with CFR 0.152.
 */
package com.senior.ui.ext.renderer;

import com.senior.mask.MaskType;
import com.senior.mask.Masks;
import com.senior.ui.components.ActionConfig;
import com.senior.ui.components.ComponentProperty;
import com.senior.ui.components.DataType;
import com.senior.ui.components.EditBoxHelper;
import com.senior.ui.components.VComponent;
import com.senior.ui.components.VEditBox;
import com.senior.ui.components.plugins.LookupPlugin;
import com.senior.ui.core.ChangeNode;
import com.senior.ui.ext.renderer.AbstractRender;
import com.senior.ui.ext.renderer.ComponentRenderUtility;
import com.senior.ui.ext.renderer.ConverterKeyCode;
import com.senior.ui.ext.renderer.IComponentRenderer;
import com.senior.ui.ext.renderer.JSONUtility;
import com.senior.ui.ext.renderer.JsUtility;
import com.senior.ui.plugin.Plugin;
import java.util.ArrayList;
import java.util.List;

class EditRender
extends AbstractRender {
    private static final String SENIORTEXTFIELD = "seniortextfield";
    private static final String SENIORDATEFIELD = "seniordatefield";
    private static final String SENIOR_TEXT_AREA_TRIGGER = "seniortextareatrigger";
    private static final String SENIOR_TRIGGER = "seniortrigger";
    private static final String SENIOR_TRIGGER_BOX = "seniortriggerbox";

    public EditRender() {
        this.properties.put(ComponentProperty.EMPTY_TEXT, "emptyText");
        this.properties.put(ComponentProperty.PASSWORD, "password");
        this.properties.put(ComponentProperty.TYPE, "type");
        this.methods.put(ComponentProperty.EMPTY_TEXT, "setEmptyText");
        this.methods.put(ComponentProperty.PASSWORD, "setPassword");
        this.methods.put(ComponentProperty.TYPE, "setType");
    }

    @Override
    protected void render(ChangeNode node, JSONUtility util, IComponentRenderer renderer) {
        MaskType type;
        String mask;
        VEditBox currentState = (VEditBox)node.getComponent();
        ComponentRenderUtility.setDefaultSizeWhereUndefined((VComponent)currentState);
        List actions = currentState.getActions();
        String xtype = EditRender.getXType(currentState);
        util.key("xtype").value(xtype);
        if (SENIOR_TRIGGER.equals(xtype)) {
            if (!actions.isEmpty()) {
                EditRender.renderTrigger(util, (ActionConfig)actions.get(0));
            } else {
                throw new AssertionError((Object)"Invalid Edit - triggers must have a plugin");
            }
        }
        if (node.hasPropertyChange(ComponentProperty.PASSWORD)) {
            node.clearPropertyChange(ComponentProperty.PASSWORD);
            boolean isPassword = (Boolean)node.getComponent().get(ComponentProperty.PASSWORD);
            if (isPassword) {
                util.key("inputType").value("password");
            }
        }
        if (currentState.getKeys().length > 0) {
            util.key("keyMapping").value(EditRender.convertKeys(currentState.getKeys()));
        }
        if (SENIORDATEFIELD.equals(xtype) && (mask = currentState.getMask()) != null && (type = Masks.compile((String)mask).getType()) == MaskType.DATE_COMPETENCE) {
            util.addPlugin("monthPickerPlugin");
        }
    }

    private static Integer[] convertKeys(Integer[] keysParam) {
        ArrayList<Integer> keys = new ArrayList<Integer>();
        Integer[] integerArray = keysParam;
        int n = keysParam.length;
        int n2 = 0;
        while (n2 < n) {
            Integer key = integerArray[n2];
            int codeJs = ConverterKeyCode.convertToJs(key);
            keys.add(codeJs);
            ++n2;
        }
        return keys.toArray(new Integer[keys.size()]);
    }

    private static String getXType(VEditBox edit) {
        String xType = SENIORTEXTFIELD;
        xType = edit.getType() == DataType.TYPE_DATE || EditBoxHelper.hasDateEditBoxFilterPlugin((VEditBox)edit) ? SENIORDATEFIELD : (edit.getType() == DataType.TYPE_CLOB ? SENIOR_TEXT_AREA_TRIGGER : (edit.getActions().isEmpty() ? SENIORTEXTFIELD : SENIOR_TRIGGER));
        for (Plugin plg : edit.getPlugins()) {
            if (!(plg instanceof LookupPlugin)) continue;
            xType = SENIOR_TRIGGER_BOX;
        }
        return xType;
    }

    private static void renderTrigger(JSONUtility util, ActionConfig action) {
        util.key("triggerID").value(action.getName());
        String enabledIcon = action.getIcon();
        String disabledIcon = action.getDisabledIcon();
        if (enabledIcon != null) {
            util.key("enabledIcon").value(EditRender.getResourceUri(enabledIcon));
        }
        if (disabledIcon != null) {
            util.key("disabledIcon").value(EditRender.getResourceUri(disabledIcon));
        }
    }

    @Override
    protected void update(ChangeNode node, JsUtility util, IComponentRenderer renderer) {
        VEditBox editbox = (VEditBox)node.getComponent();
        ComponentRenderUtility.setDefaultSizeWhereUndefined((VComponent)editbox);
        if (EditRender.getXType(editbox).equals(SENIORDATEFIELD) && (node.hasPropertyChange(ComponentProperty.TEXT) || node.hasPropertyChange(ComponentProperty.RAW_TEXT))) {
            util.method("setUnformattedValue", editbox.getRawText());
        }
        super.update(node, util, renderer);
    }
}

