/*
 * Decompiled with CFR 0.152.
 */
package com.senior.ui.ext.renderer;

import com.senior.ui.components.ComponentProperty;
import com.senior.ui.components.VCheckBox;
import com.senior.ui.components.VComposite;
import com.senior.ui.components.layout.ILayoutDefaultsSupport;
import com.senior.ui.components.layout.ILayoutManager;
import com.senior.ui.components.layout.LayoutDefinitionBase;
import com.senior.ui.components.layout.grid.GridLayout;
import com.senior.ui.components.layout.grid.GridLayoutDefinition;
import com.senior.ui.core.ChangeNode;
import com.senior.ui.definition.HorizontalAlignment;
import com.senior.ui.ext.renderer.AbstractRender;
import com.senior.ui.ext.renderer.IComponentRenderer;
import com.senior.ui.ext.renderer.JSONUtility;
import com.senior.ui.ext.renderer.JsUtility;

final class CheckBoxRender
extends AbstractRender {
    public CheckBoxRender() {
        this.properties.put(ComponentProperty.TEXT, "boxLabel");
    }

    @Override
    protected void render(ChangeNode node, JSONUtility util, IComponentRenderer renderer) {
        ILayoutManager layout;
        VComposite parent;
        VCheckBox checkBox = (VCheckBox)node.getComponent();
        if (node.hasPropertyChange(ComponentProperty.CHECKED)) {
            util.key("checked").value(checkBox.isSelected());
            node.clearPropertyChange(ComponentProperty.CHECKED);
        }
        if (checkBox.getLayoutDefinition() == null && (parent = checkBox.getParent()) != null && (layout = parent.getLayout()) instanceof GridLayout) {
            LayoutDefinitionBase layoutDefinition = ((ILayoutDefaultsSupport)layout).getDefaultLayoutDefinition();
            ((GridLayoutDefinition)layoutDefinition).setHorizontalAlignment(HorizontalAlignment.CENTER);
        }
    }

    @Override
    protected void update(ChangeNode node, JsUtility util, IComponentRenderer renderer) {
        node.clearPropertyChange(ComponentProperty.TEXT);
        VCheckBox checkBox = (VCheckBox)node.getComponent();
        if (!node.hasPropertyChanges() || !checkBox.getVisibleState()) {
            return;
        }
        if (node.hasPropertyChange(ComponentProperty.CHECKED)) {
            util.method("internalSetValue", checkBox.isSelected());
            node.clearPropertyChange(ComponentProperty.CHECKED);
        }
        if (node.hasPropertyChange(ComponentProperty.HAS_ERROR)) {
            util.method("setHasError", checkBox.hasError());
            if (checkBox.hasError()) {
                util.method("markInvalid", new Object[0]);
            } else {
                util.method("clearInvalid", new Object[0]);
            }
            node.clearPropertyChange(ComponentProperty.HAS_ERROR);
        }
    }
}

