/*
 * Decompiled with CFR 0.152.
 */
package com.senior.ui.ext.renderer;

import com.senior.ui.components.ComponentProperty;
import com.senior.ui.components.calendar.VCalendar;
import com.senior.ui.core.ChangeNode;
import com.senior.ui.core.theme.StyleScope;
import com.senior.ui.definition.CalendarSelectionMode;
import com.senior.ui.ext.renderer.AbstractRender;
import com.senior.ui.ext.renderer.IComponentRenderer;
import com.senior.ui.ext.renderer.JSONUtility;
import com.senior.ui.ext.renderer.JsUtility;
import com.senior.ui.ext.renderer.RendererFlag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTimeFieldType;
import org.joda.time.LocalDate;
import org.joda.time.Partial;
import org.joda.time.ReadablePartial;

class CalendarRender
extends AbstractRender {
    public CalendarRender() {
        this.properties.put(ComponentProperty.MAX_DATE, "maxDate");
        this.properties.put(ComponentProperty.MIN_DATE, "minDate");
        this.properties.put(ComponentProperty.FOCUSED_MONTH, "calendarMonth");
        this.properties.put(ComponentProperty.DATE_REFSTART, "firstDayToShow");
        this.properties.put(ComponentProperty.SHOW_NAVIGATION, "showNavigation");
        this.methods.put(ComponentProperty.MAX_DATE, "setMaxDate");
        this.methods.put(ComponentProperty.MIN_DATE, "setMinDate");
        this.methods.put(ComponentProperty.FOCUSED_MONTH, "setCalendarMonth");
        this.methods.put(ComponentProperty.DATE_REFSTART, "setFirstDayToShow");
        this.methods.put(ComponentProperty.SHOW_NAVIGATION, "setShowNavigation");
    }

    @Override
    protected void render(ChangeNode node, JSONUtility util, IComponentRenderer renderer) {
        VCalendar calendar = (VCalendar)node.getComponent();
        node.clearPropertyChange(ComponentProperty.CALENDAR_SELECTION_CHANGED);
        RendererFlag.IGNORE_MARKCHANGED_PLUGIN.setFlag(node);
        RendererFlag.IGNORE_MASK_PLUGIN.setFlag(node);
        util.key("monthYearText").value("Escolha um m\u00eas (Control + Cima/Baixo para sele\u00e7\u00e3o de anos)");
        util.key("nextText").value("Pr\u00f3ximo m\u00eas (Control+Right)");
        util.key("prevText").value("M\u00eas anterior (Control+Left)");
        util.key("todayText").value("Hoje");
        util.key("showToday").value(calendar.isShowTodayButton());
        util.key("selectionMode").value(calendar.getSelectionMode().toString());
        Partial p = calendar.getFocusedMonth();
        if (node.hasPropertyChange(ComponentProperty.FOCUSED_MONTH)) {
            node.clearPropertyChange(ComponentProperty.FOCUSED_MONTH);
            util.key((String)this.properties.get(ComponentProperty.FOCUSED_MONTH)).value(String.format("%s/%s", p.get(DateTimeFieldType.monthOfYear()), p.get(DateTimeFieldType.year())));
        }
        if (p == null) {
            p = new Partial();
        }
        if (node.hasPropertyChange(ComponentProperty.DATE_REFSTART) || node.hasPropertyChange(ComponentProperty.DATE_REFEND)) {
            node.clearPropertyChange(ComponentProperty.DATE_REFSTART);
            node.clearPropertyChange(ComponentProperty.DATE_REFEND);
            LocalDate firstDayToShow = calendar.getFirstDayToShow();
            util.key((String)this.properties.get(ComponentProperty.DATE_REFSTART)).value(firstDayToShow);
            util.key("dateRefStart").value(calendar.getDateRefStart());
            util.key("dateRefEnd").value(calendar.getDateRefEnd());
        }
        LocalDate from = new LocalDate((Object)calendar.getFirstDayToShow());
        LocalDate to = new LocalDate((Object)from).plusDays(41);
        ArrayList<String> selections = new ArrayList<String>();
        JSONUtility stylesJson = JSONUtility.getInstance();
        stylesJson.object();
        ArrayList<String> changedDates = new ArrayList<String>();
        HashMap<String, String> classesToCreate = node.hasPropertyChange(ComponentProperty.STYLE) ? new HashMap<String, String>() : Collections.emptyMap();
        while (!from.isAfter((ReadablePartial)to)) {
            if (calendar.isSelected(from)) {
                selections.add(CalendarRender.toString(from));
            }
            if (calendar.isChanged(from)) {
                changedDates.add(CalendarRender.toString(from));
            }
            CalendarRender.addStyle(node, calendar, from, stylesJson, classesToCreate);
            from = from.plusDays(1);
        }
        for (Map.Entry classes : classesToCreate.entrySet()) {
            util.getAfterScripts().addDynamicCSS((String)classes.getValue());
        }
        stylesJson.end();
        util.key("selections").value(selections);
        util.key("styles").value(stylesJson);
        util.key("changedDates").value(changedDates);
        node.clearPropertyChange(ComponentProperty.STYLE);
        JSONUtility.release(stylesJson);
    }

    @Override
    protected void update(ChangeNode node, JsUtility util, IComponentRenderer renderer) {
        VCalendar calendar = (VCalendar)node.getComponent();
        if (!node.hasPropertyChanges() || !calendar.getVisibleState()) {
            return;
        }
        node.clearPropertyChange(ComponentProperty.CALENDAR_SELECTION_CHANGED);
        LocalDate from = calendar.getFirstDayToShow();
        LocalDate to = from.plusDays(41);
        JSONUtility selections = JSONUtility.getInstance();
        JSONUtility stylesJson = JSONUtility.getInstance();
        JSONUtility changedDates = JSONUtility.getInstance();
        selections.array();
        stylesJson.object();
        changedDates.array();
        LocalDate selectedDate = null;
        HashMap<String, String> classesToCreate = node.hasPropertyChange(ComponentProperty.STYLE) ? new HashMap<String, String>() : Collections.emptyMap();
        while (!from.isAfter((ReadablePartial)to)) {
            if (calendar.isSelected(from)) {
                selectedDate = from;
                selections.value(CalendarRender.toString(from));
            }
            if (calendar.isChanged(from)) {
                changedDates.value(CalendarRender.toString(from));
            }
            CalendarRender.addStyle(node, calendar, from, stylesJson, classesToCreate);
            from = from.plusDays(1);
        }
        for (Map.Entry classes : classesToCreate.entrySet()) {
            util.addDynamicCSS((String)classes.getValue());
        }
        selections.end();
        stylesJson.end();
        changedDates.end();
        if (node.hasPropertyChange(ComponentProperty.DATE_REFSTART)) {
            node.clearPropertyChange(ComponentProperty.DATE_REFSTART);
            LocalDate firstDayToShow = calendar.getFirstDayToShow();
            util.method((String)this.methods.get(ComponentProperty.DATE_REFSTART), firstDayToShow);
            util.method("setDateRefStart", calendar.getDateRefStart());
        }
        if (node.hasPropertyChange(ComponentProperty.DATE_REFEND)) {
            node.clearPropertyChange(ComponentProperty.DATE_REFEND);
            util.method("setDateRefEnd", calendar.getDateRefEnd());
        }
        if (node.hasPropertyChange(ComponentProperty.TITLE)) {
            node.clearPropertyChange(ComponentProperty.TITLE);
            util.method("setTitle", calendar.getTitle());
        }
        if (node.hasPropertyChange(ComponentProperty.SELECTED_DATES) || node.hasPropertyChange(ComponentProperty.FOCUSED_MONTH)) {
            util.method("clearSelectedDates", new Object[0]);
            util.method("setSelections", selections);
        }
        if (node.hasPropertyChange(ComponentProperty.FOCUSED_MONTH)) {
            Partial focusedmonth = calendar.getFocusedMonth();
            util.method((String)this.methods.get(ComponentProperty.FOCUSED_MONTH), focusedmonth.get(DateTimeFieldType.year()), focusedmonth.get(DateTimeFieldType.monthOfYear()));
            node.clearPropertyChange(ComponentProperty.FOCUSED_MONTH);
        }
        if (node.hasPropertyChange(ComponentProperty.STYLE)) {
            node.clearPropertyChange(ComponentProperty.STYLE);
            util.method("clearStyles", new Object[0]);
            util.method("setStyles", stylesJson);
        }
        util.method("setChangedDates", changedDates);
        JSONUtility.release(selections);
        JSONUtility.release(stylesJson);
        JSONUtility.release(changedDates);
        if (node.hasPropertyChange(ComponentProperty.SELECTED_DATES)) {
            node.clearPropertyChange(ComponentProperty.SELECTED_DATES);
            if (selectedDate == null && !this.isMultiSelect(calendar) && calendar.getDate() != null) {
                selectedDate = calendar.getDate();
            }
            util.method("setValue", selectedDate);
        }
        util.method("refresh", new Object[0]);
        node.clearPropertyChange(ComponentProperty.CHANGED);
    }

    protected boolean isMultiSelect(VCalendar calendar) {
        return calendar.getSelectionMode() == CalendarSelectionMode.MULTI || calendar.getSelectionMode() == CalendarSelectionMode.INTERVAL;
    }

    private static void addStyle(ChangeNode node, VCalendar calendar, LocalDate from, JSONUtility stylesJson, Map<String, String> classesToCreate) {
        if (node.hasPropertyChange(ComponentProperty.STYLE)) {
            String[] cssClass;
            String className = "";
            String[] styleNames = calendar.getStyle(from);
            if (styleNames != null && styleNames.length > 0 && (cssClass = CalendarRender.buildCssClass(styleNames, EnumSet.of(StyleScope.CALENDAR_DAY))) != null) {
                className = cssClass[0];
                classesToCreate.put(className, cssClass[1]);
            }
            stylesJson.key(CalendarRender.toString(from)).value(className);
        }
    }

    private static String toString(LocalDate date) {
        return String.format("%s/%s/%s", date.getDayOfMonth(), date.getMonthOfYear(), date.getYear());
    }
}

