/*
 * Decompiled with CFR 0.152.
 */
package com.senior.ui.ext.renderer;

import com.senior.ui.components.ComponentProperty;
import com.senior.ui.components.VAbstractButton;
import com.senior.ui.core.ChangeNode;
import com.senior.ui.definition.ButtonIconPosition;
import com.senior.ui.definition.ButtonKind;
import com.senior.ui.definition.TextAlignment;
import com.senior.ui.ext.renderer.AbstractRender;
import com.senior.ui.ext.renderer.IComponentRenderer;
import com.senior.ui.ext.renderer.JSONUtility;
import com.senior.ui.ext.renderer.JsUtility;

class BaseButtonRender
extends AbstractRender {
    public BaseButtonRender() {
        this.properties.put(ComponentProperty.ICON, "icon");
        this.properties.put(ComponentProperty.DISABLED_ICON, "disabledIcon");
        this.properties.put(ComponentProperty.ALIGN_ICON, "iconAlign");
        this.properties.put(ComponentProperty.ALIGN_TEXT, "align");
        this.properties.put(ComponentProperty.KIND_BUTTON, "kind");
        this.methods.put(ComponentProperty.ICON, "setIcon");
        this.methods.put(ComponentProperty.DISABLED_ICON, "setIcon");
    }

    @Override
    protected void render(ChangeNode node, JSONUtility util, IComponentRenderer renderer) {
        String alignment;
        super.render(node, util, renderer);
        VAbstractButton button = (VAbstractButton)node.getComponent();
        switch (button.getKind()) {
            case FLATBUTTON: 
            case MENUBUTTON: {
                util.key("xtype").value("seniorbutton");
                util.key("cls").value("x-btn-flat x-btn-over-flat");
                break;
            }
            case ICONBUTTON: {
                util.key("xtype").value("seniorbutton");
                if (button.getIcon() != null) {
                    util.key("cls").value("x-btn-text-icon x-btn-icon-small-left");
                    break;
                }
                util.key("cls").value("x-btn-text");
                break;
            }
            case LINKBUTTON: {
                util.key("xtype").value("seniorlink");
                break;
            }
            default: {
                throw new RuntimeException("Type not supported: " + button.getKind());
            }
        }
        if (node.hasPropertyChange(ComponentProperty.TEXT)) {
            node.clearPropertyChange(ComponentProperty.TEXT);
            util.key("text").value(BaseButtonRender.processText(button));
        }
        if (node.hasPropertyChange(ComponentProperty.ICON) || node.hasPropertyChange(ComponentProperty.DISABLED_ICON)) {
            node.clearPropertyChange(ComponentProperty.ICON);
            node.clearPropertyChange(ComponentProperty.DISABLED_ICON);
            String icon = button.getCurrentIcon();
            if (icon != null) {
                util.key(this.propertyName(ComponentProperty.ICON)).value(BaseButtonRender.getResourceUri(icon.toString()));
            }
        }
        if (node.hasPropertyChange(ComponentProperty.ALIGN_ICON)) {
            node.clearPropertyChange(ComponentProperty.ALIGN_ICON);
            alignment = "";
            ButtonIconPosition alignmentValue = button.getIconAlign();
            switch (alignmentValue) {
                case BOTTOM: {
                    alignment = "bottom";
                    break;
                }
                case LEFT: {
                    alignment = "left";
                    break;
                }
                case RIGHT: {
                    alignment = "right";
                    break;
                }
                case TOP: {
                    alignment = "top";
                    break;
                }
            }
            util.key(this.propertyName(ComponentProperty.ALIGN_ICON)).value(alignment);
        }
        if (node.hasPropertyChange(ComponentProperty.ALIGN_TEXT)) {
            node.clearPropertyChange(ComponentProperty.ALIGN_TEXT);
            alignment = BaseButtonRender.getTextAlignment(button.getAlign());
            util.key(this.propertyName(ComponentProperty.ALIGN_TEXT)).value(alignment);
        }
        if (node.hasPropertyChange(ComponentProperty.KIND_BUTTON)) {
            node.clearPropertyChange(ComponentProperty.KIND_BUTTON);
            String buttonKind = BaseButtonRender.getButtonKindValue(button.getKind());
            util.key(this.propertyName(ComponentProperty.KIND_BUTTON)).value(buttonKind);
        }
    }

    @Override
    protected void update(ChangeNode node, JsUtility util, IComponentRenderer renderer) {
        String icon;
        super.update(node, util, renderer);
        VAbstractButton button = (VAbstractButton)node.getComponent();
        if (node.hasPropertyChange(ComponentProperty.ALIGN_TEXT)) {
            String alignment = BaseButtonRender.getTextAlignment(button.getAlign());
            util.method("setContentAligment", alignment);
            node.clearPropertyChange(ComponentProperty.ALIGN_TEXT);
        }
        if (node.hasPropertyChange(ComponentProperty.TEXT)) {
            node.clearPropertyChange(ComponentProperty.TEXT);
            util.method("setText", BaseButtonRender.processText(button));
        }
        if (node.hasPropertyChange(ComponentProperty.ICON) || node.hasPropertyChange(ComponentProperty.DISABLED_ICON)) {
            node.clearPropertyChange(ComponentProperty.ICON);
            node.clearPropertyChange(ComponentProperty.DISABLED_ICON);
            icon = button.getCurrentIcon();
            if (icon != null) {
                util.method(this.methodName(ComponentProperty.ICON), BaseButtonRender.getResourceUri(icon.toString()));
            }
        }
        if (node.hasPropertyChange(ComponentProperty.ENABLED_STATE) && (icon = button.getCurrentIcon()) != null) {
            util.method(this.methodName(ComponentProperty.ICON), BaseButtonRender.getResourceUri(icon.toString()));
        }
    }

    private static String processText(VAbstractButton button) {
        String text = (String)button.get(ComponentProperty.TEXT);
        if (text == null) {
            text = "";
        }
        return text;
    }

    private static String getButtonKindValue(ButtonKind kind) {
        String kindValue = "";
        switch (kind) {
            case FLATBUTTON: {
                kindValue = "FLATBUTTON";
                break;
            }
            case ICONBUTTON: {
                kindValue = "ICONBUTTON";
                break;
            }
            case LINKBUTTON: {
                kindValue = "LINKBUTTON";
                break;
            }
            case MENUBUTTON: {
                kindValue = "MENUBUTTON";
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value for property ButtonKind :" + kind.toString());
            }
        }
        return kindValue;
    }

    private static String getTextAlignment(TextAlignment alignment) {
        String textAlignment = "";
        switch (alignment) {
            case CENTER: {
                textAlignment = "center";
                break;
            }
            case LEFT: {
                textAlignment = "left";
                break;
            }
            case RIGHT: {
                textAlignment = "right";
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value for property TextAlignment :" + alignment.toString());
            }
        }
        return textAlignment;
    }
}

