/*
 * Decompiled with CFR 0.152.
 */
package com.senior.ui.ext;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ResourceColorChange {
    private final String color;
    private final String originalColor;
    private final String borderColor;
    private final String originalBorderColor;

    ResourceColorChange(String color, String originalColor) {
        this(color, originalColor, color, originalColor);
    }

    public ResourceColorChange(String color, String originalColor, String borderColor, String originalBorderColor) {
        ResourceColorChange.verifyParameters(color, originalColor, borderColor, originalBorderColor);
        this.color = color;
        this.originalColor = originalColor;
        this.borderColor = borderColor;
        this.originalBorderColor = originalBorderColor;
    }

    private static void verifyParameters(String color, String originalColor, String borderColor, String originalBorderColor) {
        if (color == null || originalColor == null || borderColor == null || originalBorderColor == null) {
            throw new IllegalArgumentException("The color is null.");
        }
        if (color.length() != 6 || originalColor.length() != 6 || borderColor.length() != 6 || originalBorderColor.length() != 6) {
            throw new IllegalArgumentException(String.format("All colors must be in format 'RRGGBB'. Actual values were: %s - %s - %s - %s", color, originalColor, borderColor, originalBorderColor));
        }
        ResourceColorChange.verifyPatternRGB(color);
        ResourceColorChange.verifyPatternRGB(originalColor);
        ResourceColorChange.verifyPatternRGB(borderColor);
        ResourceColorChange.verifyPatternRGB(originalBorderColor);
    }

    private static void verifyPatternRGB(String color) {
        color = color.toUpperCase();
        Pattern pattern = Pattern.compile("[0-9A-F]{6}?");
        Matcher matcher = pattern.matcher(color);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("The color is not formatted RRGGBB: " + color);
        }
    }

    String getColor() {
        return this.color;
    }

    String getOriginalColor() {
        return this.originalColor;
    }

    String getBorderColor() {
        return this.borderColor;
    }

    String getOriginalBorderColor() {
        return this.originalBorderColor;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.borderColor == null ? 0 : this.borderColor.hashCode());
        result = 31 * result + (this.color == null ? 0 : this.color.hashCode());
        result = 31 * result + (this.originalBorderColor == null ? 0 : this.originalBorderColor.hashCode());
        result = 31 * result + (this.originalColor == null ? 0 : this.originalColor.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceColorChange other = (ResourceColorChange)obj;
        if (this.borderColor == null ? other.borderColor != null : !this.borderColor.equals(other.borderColor)) {
            return false;
        }
        if (this.color == null ? other.color != null : !this.color.equals(other.color)) {
            return false;
        }
        if (this.originalBorderColor == null ? other.originalBorderColor != null : !this.originalBorderColor.equals(other.originalBorderColor)) {
            return false;
        }
        return !(this.originalColor == null ? other.originalColor != null : !this.originalColor.equals(other.originalColor));
    }
}

