/*
 * Decompiled with CFR 0.152.
 */
package com.senior.ui.ext;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

final class ExtImageInfo {
    private final String backgroundColor;
    private final String borderColor;
    private final String imagePath;
    private final boolean hasBorder;

    ExtImageInfo(String backgroundColor, String path) {
        this(backgroundColor, backgroundColor, path, false);
    }

    ExtImageInfo(String backgroundColor, String borderColor, String imagePath) {
        this(backgroundColor, borderColor, imagePath, true);
    }

    private ExtImageInfo(String backgroundColor, String borderColor, String imagePath, boolean hasBorderAtImage) {
        this.backgroundColor = backgroundColor;
        this.borderColor = borderColor;
        this.imagePath = imagePath;
        this.hasBorder = hasBorderAtImage;
        if (StringUtils.isBlank((String)imagePath)) {
            throw new IllegalArgumentException("Image path is null or it is an empty String.");
        }
        this.verifyColors(backgroundColor, borderColor);
    }

    String getImagePath() {
        return this.imagePath;
    }

    String getBackgroundColor() {
        return this.backgroundColor;
    }

    String getBorderColor() {
        return this.borderColor;
    }

    boolean hasBorder() {
        return this.hasBorder;
    }

    private void verifyColors(String background, String border) {
        if (background == null || border == null) {
            throw new IllegalArgumentException("The color is null.");
        }
        if (background.length() != 6 || border.length() != 6) {
            throw new IllegalArgumentException(String.format("All colors must be in format 'RRGGBB'. Actual values were: %s - %s", background, border));
        }
        ExtImageInfo.verifyPatternRGB(background);
        ExtImageInfo.verifyPatternRGB(border);
    }

    private static void verifyPatternRGB(String color) {
        color = color.toUpperCase();
        Pattern pattern = Pattern.compile("[0-9A-F]{6}?");
        Matcher matcher = pattern.matcher(color);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("The color is not formatted RRGGBB: " + color);
        }
    }

    public String toString() {
        return this.getImagePath();
    }
}

