/*
 * Decompiled with CFR 0.152.
 */
package com.senior.ui.ext;

import com.senior.FrameworkProperty;
import com.senior.formcenter.auth.AuthenticationKey;
import com.senior.formcenter.auth.ChangePasswordPageGenerator;
import com.senior.formcenter.auth.CriticalErrorPageGenerator;
import com.senior.formcenter.auth.LoginPageGenerator;
import com.senior.formcenter.auth.QuestionPageGenerator;
import com.senior.formcenter.auth.SubstituteUserGenerator;
import com.senior.formcenter.auth.SubstituteUserKey;
import com.senior.security.ISubstitutedUser;
import com.senior.security.IUser;
import com.senior.security.SecurityManagerProvider;
import com.senior.security.SubstituteUserType;
import com.senior.ui.ExtPerspectiveSession;
import com.senior.ui.components.VButton;
import com.senior.ui.components.VEditBox;
import com.senior.ui.components.VPanel;
import com.senior.ui.core.HttpIOProcessor;
import com.senior.ui.core.HttpResourceManager;
import com.senior.ui.core.IHttpRequestDescriptor;
import com.senior.ui.core.IRequestDescriptor;
import com.senior.ui.core.message.ContextMessage;
import com.senior.ui.core.message.FrameworkMessage;
import com.senior.ui.core.message.Message;
import com.senior.ui.core.message.MessagePriorityLevel;
import com.senior.ui.core.message.SynchronizableMessage;
import com.senior.ui.ext.ExtResourceManager;
import com.senior.ui.ext.RequestProperties;
import com.senior.ui.ext.XmlRequestProcessor;
import com.senior.ui.ext.renderer.Ext3Renderer;
import com.senior.ui.ext.renderer.JSONUtility;
import com.senior.ui.ext.renderer.JsUtility;
import com.senior.ui.ext.style.CSSUtility;
import com.senior.ui.ext.style.DynamicCssGenerator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExtIOProcessor
extends HttpIOProcessor
implements Serializable {
    private static final String DEFAULT_ERROR_PAGE_TITLE = "Erro cr\u00edtico";
    private static final String COMPONENT_ID_LOGIN_BUTTON_LOGIN = "login";
    private static final String COMPONENT_ID_LOGIN_BUTTON_APPLY = "apply";
    private static final String COMPONENT_ID_LOGIN_BUTTON_CANCEL = "cancel";
    private static final String COMPONENT_ID_LOGIN_EDITBOX_PSW = "psw";
    private static final String COMPONENT_ID_LOGIN_EDITBOX_USR = "usr";
    private static final String COMPONENT_ID_LOGIN_EDITBOX_NEWPSW = "newPsw";
    private static final String COMPONENT_ID_LOGIN_EDITBOX_CNFPSW = "cnfPsw";
    private static final String COMPONENT_ID_LOGIN_LOGO_PANEL = "loginLogoPanel";
    private static final String COMPONENT_ID_LOGIN_INTERNAL_PANEL = "loginInternalPanel";
    private static final String COMPONENT_ID_LOGIN_EXTERNAL_PANEL = "loginExternalPanel";
    private static final String STYLE_LOGIN_LOGO_PANEL = "login-logo-panel";
    private static final String STYLE_LOGIN_INTERNAL_PANEL = "login-internal-panel";
    private static final String STYLE_LOGIN_EXTERNAL_PANEL = "login-external-panel";
    private static final long serialVersionUID = -8019725150046982352L;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ExtIOProcessor.class.getName());
    private static Map<String, Memento> serializedData = new HashMap<String, Memento>();
    private String id;
    private Map<String, ExtPerspectiveSession> extPerspectiveSessions;
    private Ext3Renderer renderer;
    private volatile ExtResourceManager resourceManager;

    public ExtIOProcessor(String id) {
        this.id = id;
        this.initialize();
    }

    private void initialize() {
        this.extPerspectiveSessions = new HashMap<String, ExtPerspectiveSession>();
        this.renderer = new Ext3Renderer();
    }

    public void handlePerspectiveOpening(IHttpRequestDescriptor requestDesc, OutputStream output) {
        ExtPerspectiveSession session;
        String perspectiveURL;
        Object perspective = requestDesc.getParameter(RequestProperties.PERSPECTIVE.getValue());
        String string = perspectiveURL = perspective != null ? String.valueOf(perspective) : null;
        if (requestDesc.getParameter(RequestProperties.PERSPECTIVE_ID.getValue()) != null) {
            String perspectiveId = (String)requestDesc.getParameter(RequestProperties.PERSPECTIVE_ID.getValue());
            session = new ExtPerspectiveSession(perspectiveId);
        } else {
            session = new ExtPerspectiveSession(perspectiveURL, requestDesc.getParametersMap());
        }
        this.extPerspectiveSessions.put(session.getPerspectiveDescriptor().getId(), session);
        StringBuilder response = new StringBuilder();
        session.requestRender(this.renderer, response);
        ExtIOProcessor.printResponse(output, response);
    }

    public boolean handlePerspectiveClosing(IHttpRequestDescriptor requestDesc, OutputStream output) {
        block3: {
            String perspectiveId = (String)requestDesc.getParameter(RequestProperties.PERSPECTIVE.getValue());
            ExtPerspectiveSession session = this.extPerspectiveSessions.remove(perspectiveId);
            if (session != null) {
                try {
                    session.destroy();
                }
                catch (Throwable t) {
                    if (!LOGGER.isWarnEnabled()) break block3;
                    IUser currentUser = SecurityManagerProvider.getInstance().getCurrentUser();
                    LOGGER.warn("Error destroying a perspective session. Perspective: " + perspectiveId + ", user: " + currentUser == null ? "null" : String.valueOf(currentUser.getName()) + ".", t);
                }
            }
        }
        return this.extPerspectiveSessions.isEmpty();
    }

    public void handlePerspectiveBeforeClose(IHttpRequestDescriptor requestDesc, OutputStream output) {
        StringBuilder response = new StringBuilder();
        boolean hasChanges = false;
        if (Boolean.parseBoolean(FrameworkProperty.CONFIRM_CLOSE.get())) {
            String perspectiveId = (String)requestDesc.getParameter(RequestProperties.PERSPECTIVE.getValue());
            FrameworkMessage message = new FrameworkMessage(MessagePriorityLevel.USER_MESSAGE_HIGH_PRIORITY, perspectiveId, "beforeStop", null);
            ExtPerspectiveSession session = this.extPerspectiveSessions.get(perspectiveId);
            if (session != null) {
                session.postAndWaitMessage((SynchronizableMessage)message);
                response.append(message.getData().get("hasChanges"));
                hasChanges = true;
            }
        }
        if (!hasChanges) {
            response.append(false);
        }
        ExtIOProcessor.printResponse(output, response);
    }

    public void handleError(IHttpRequestDescriptor requestDesc, OutputStream output) {
        String title;
        boolean screenRequest = ExtIOProcessor.isScreenRequest((IRequestDescriptor)requestDesc);
        PrintWriter writer = new PrintWriter(output);
        Object objectTitle = requestDesc.getParametersMap().get(com.senior.ui.core.RequestProperties.TITLE.name());
        String string = title = objectTitle != null ? (String)objectTitle : null;
        if (StringUtils.isEmpty((String)title)) {
            title = DEFAULT_ERROR_PAGE_TITLE;
        }
        String messageTitle = ExtIOProcessor.getString(requestDesc.getParametersMap().get(com.senior.ui.core.RequestProperties.MESSAGE_TITLE.name()));
        String carriageReturnNewLineExpr = "\r\n";
        String carriageReturnOrNewLineExpr = "\r|\n";
        String htmlNewLine = "<br>";
        messageTitle = messageTitle.replaceAll(carriageReturnNewLineExpr, htmlNewLine).replaceAll(carriageReturnOrNewLineExpr, htmlNewLine);
        String message = ExtIOProcessor.getString(requestDesc.getParametersMap().get(com.senior.ui.core.RequestProperties.MESSAGE.name()));
        message = message.replaceAll(carriageReturnNewLineExpr, htmlNewLine).replaceAll(carriageReturnOrNewLineExpr, htmlNewLine);
        String statusCode = ExtIOProcessor.getString(requestDesc.getParametersMap().get(com.senior.ui.core.RequestProperties.STATUS_CODE.name()));
        statusCode = statusCode.replaceAll(carriageReturnNewLineExpr, htmlNewLine).replaceAll(carriageReturnOrNewLineExpr, htmlNewLine);
        String datetime = new DateTime().toString("dd/MM/yyyy HH:mm:ss");
        String criticalErrorPage = CriticalErrorPageGenerator.build(title, messageTitle, datetime, message, statusCode);
        if (screenRequest) {
            StringBuilder sb = new StringBuilder();
            criticalErrorPage = criticalErrorPage.split("<body>")[1].split("</body>")[0];
            sb.append("this.loginResponse = {");
            sb.append("\"success\":false,");
            sb.append("\"type\": \"fatal\",");
            sb.append("\"pageError\" : \"");
            sb.append(StringEscapeUtils.escapeJavaScript((String)criticalErrorPage));
            sb.append("\",\"title\" : \"");
            sb.append(StringEscapeUtils.escapeJavaScript((String)title));
            sb.append("\"};");
            writer.write(sb.toString());
        } else {
            writer.write(criticalErrorPage);
        }
        writer.flush();
    }

    private static String getString(Object object) {
        if (object == null) {
            return "";
        }
        return StringEscapeUtils.escapeHtml((String)object.toString());
    }

    public void handleDefaultInput(IHttpRequestDescriptor requestDesc, OutputStream output) {
        String input = (String)requestDesc.getParameter(RequestProperties.DATA.getValue());
        if (input == null) {
            if (ExtIOProcessor.isLoginRequest(requestDesc)) {
                this.handleLoginStepFinish(requestDesc, output);
            }
            return;
        }
        ContextMessage contextMessage = XmlRequestProcessor.process(input);
        StringBuilder response = new StringBuilder();
        ExtPerspectiveSession session = this.extPerspectiveSessions.get(contextMessage.getPerspectiveId());
        if (session == null) {
            response.append(ExtIOProcessor.getScriptToReload());
        } else {
            for (Message message : contextMessage.getMessages()) {
                session.postMessage(message);
            }
            session.requestRender(this.renderer, response);
        }
        ExtIOProcessor.printResponse(output, response);
    }

    private static boolean isLoginRequest(IHttpRequestDescriptor requestDesc) {
        String parameter = (String)requestDesc.getParameter("scrReq");
        return StringUtils.isNotBlank((String)((String)requestDesc.getParameter(COMPONENT_ID_LOGIN_EDITBOX_PSW))) && StringUtils.isNotBlank((String)((String)requestDesc.getParameter(COMPONENT_ID_LOGIN_EDITBOX_USR))) && StringUtils.isNotBlank((String)parameter) && Boolean.TRUE.toString().equals(parameter);
    }

    private static String getScriptToReload() {
        return "window.location.reload();";
    }

    public void handleLoginRequest(IHttpRequestDescriptor requestDesc, OutputStream output, boolean usernameOnly) {
        PrintWriter writer = new PrintWriter(output);
        String username = (String)requestDesc.getParameter(AuthenticationKey.USER_NAME.getValue());
        String scriptCSSDynamic = ExtIOProcessor.generateLoginPageCSS(false);
        String loginPage = LoginPageGenerator.build(requestDesc.getParametersMap(), ExtResourceManager.FINGERPRINT, this.getInternalResourceManager().getThemeFingerprint(), scriptCSSDynamic, usernameOnly, username);
        writer.write(loginPage);
        writer.flush();
    }

    public void handleChangePasswordRequest(IHttpRequestDescriptor requestDesc, OutputStream output) {
        PrintWriter writer = new PrintWriter(output);
        String scriptCSSDynamic = ExtIOProcessor.generateChangePasswordPageCSS();
        String changePassword = ChangePasswordPageGenerator.build(requestDesc.getParametersMap(), ExtResourceManager.FINGERPRINT, this.getInternalResourceManager().getThemeFingerprint(), scriptCSSDynamic);
        writer.write(changePassword);
        writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExtResourceManager getInternalResourceManager() {
        if (this.resourceManager == null) {
            ExtIOProcessor extIOProcessor = this;
            synchronized (extIOProcessor) {
                if (this.resourceManager == null) {
                    this.resourceManager = new ExtResourceManager();
                }
            }
        }
        return this.resourceManager;
    }

    private static String generateLoginPageCSS(boolean isSubstituteUserPage) {
        StringBuilder script = new StringBuilder();
        JsUtility utility = new JsUtility(script, null, null, new Object[0]);
        String componentTypeName = VPanel.class.getName();
        ExtIOProcessor.generatePanelCss(script, utility, componentTypeName);
        if (!isSubstituteUserPage) {
            componentTypeName = VEditBox.class.getName();
            ExtIOProcessor.generateDynamicCSS(script, utility, STYLE_LOGIN_INTERNAL_PANEL, COMPONENT_ID_LOGIN_EDITBOX_USR, componentTypeName);
            ExtIOProcessor.generateDynamicCSS(script, utility, STYLE_LOGIN_INTERNAL_PANEL, COMPONENT_ID_LOGIN_EDITBOX_PSW, componentTypeName);
            ExtIOProcessor.generateDynamicCSS(script, utility, STYLE_LOGIN_INTERNAL_PANEL, COMPONENT_ID_LOGIN_BUTTON_LOGIN, VButton.class.getName());
        }
        utility.generateCSSStyle();
        utility.finish();
        return script.toString();
    }

    private static String generateChangePasswordPageCSS() {
        StringBuilder script = new StringBuilder();
        JsUtility utility = new JsUtility(script, null, null, new Object[0]);
        String componentTypeName = VPanel.class.getName();
        ExtIOProcessor.generatePanelCss(script, utility, componentTypeName);
        componentTypeName = VEditBox.class.getName();
        ExtIOProcessor.generateDynamicCSS(script, utility, STYLE_LOGIN_INTERNAL_PANEL, COMPONENT_ID_LOGIN_EDITBOX_NEWPSW, componentTypeName);
        ExtIOProcessor.generateDynamicCSS(script, utility, STYLE_LOGIN_INTERNAL_PANEL, COMPONENT_ID_LOGIN_EDITBOX_CNFPSW, componentTypeName);
        ExtIOProcessor.generateDynamicCSS(script, utility, STYLE_LOGIN_INTERNAL_PANEL, COMPONENT_ID_LOGIN_BUTTON_APPLY, VButton.class.getName());
        ExtIOProcessor.generateDynamicCSS(script, utility, STYLE_LOGIN_INTERNAL_PANEL, COMPONENT_ID_LOGIN_BUTTON_CANCEL, VButton.class.getName());
        utility.generateCSSStyle();
        utility.finish();
        return script.toString();
    }

    private static String generatePanelCss(StringBuilder script, JsUtility utility, String componentTypeName) {
        String[] cssStyles = new String[]{STYLE_LOGIN_EXTERNAL_PANEL, STYLE_LOGIN_INTERNAL_PANEL, STYLE_LOGIN_LOGO_PANEL};
        String[] componentsIds = new String[]{COMPONENT_ID_LOGIN_EXTERNAL_PANEL, COMPONENT_ID_LOGIN_INTERNAL_PANEL, COMPONENT_ID_LOGIN_LOGO_PANEL};
        int i = 0;
        while (i < cssStyles.length) {
            ExtIOProcessor.generateDynamicCSS(script, utility, cssStyles[i], componentsIds[i], componentTypeName);
            ++i;
        }
        return script.toString();
    }

    private static void generateDynamicCSS(StringBuilder script, JsUtility utility, String cssClassName, String componentId, String componentTypeName) {
        JSONUtility css = JSONUtility.getInstance();
        Map<String, CSSUtility[]> generatedClasses = DynamicCssGenerator.generateCss(new String[]{cssClassName}, componentTypeName);
        css.array();
        String[] generatedClassesNames = null;
        for (Map.Entry<String, CSSUtility[]> entry : generatedClasses.entrySet()) {
            generatedClassesNames = new String[entry.getValue().length];
            CSSUtility[] cssUtility = entry.getValue();
            int i = 0;
            while (i < cssUtility.length) {
                CSSUtility cssClass = entry.getValue()[i];
                utility.addDynamicCSS(cssClass.toString());
                generatedClassesNames[i] = cssClass.getName();
                ++i;
            }
            css.object();
            css.key("scope").value(entry.getKey());
            css.key("cls").value(generatedClassesNames);
            css.end();
        }
        css.end();
        script.append("Ext.getCmp('".concat(componentId).concat("').setStyle(").concat(css.toString()).concat(");"));
        JSONUtility.release(css);
    }

    public void handleSessionDestruction() {
        for (ExtPerspectiveSession session : this.extPerspectiveSessions.values()) {
            try {
                session.destroy();
            }
            catch (Throwable t) {
                if (!LOGGER.isWarnEnabled()) continue;
                IUser currentUser = SecurityManagerProvider.getInstance().getCurrentUser();
                LOGGER.warn("Error destroying a perspective session. Perspective: " + session.getPerspectiveDescriptor().getId() + ", user : " + currentUser == null ? "null" : currentUser.getName(), t);
            }
        }
        this.extPerspectiveSessions.clear();
    }

    private static void printResponse(OutputStream output, StringBuilder response) {
        PrintWriter printer = new PrintWriter(output);
        printer.write(response.toString());
        printer.flush();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("browser output: " + response.toString().replaceAll("\\n", ""));
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Memento fcm = new Memento(this.extPerspectiveSessions);
        serializedData.put(this.id, fcm);
        out.writeObject(this.id);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String serializedId = (String)in.readObject();
        Memento serializedState = serializedData.remove(serializedId);
        this.initialize();
        if (serializedState != null) {
            this.extPerspectiveSessions.putAll(serializedState.perspectiveSessions);
        }
        this.id = serializedId;
    }

    public HttpResourceManager getResourceManager() {
        return this.getInternalResourceManager();
    }

    public void handleLoginAuthenticateError(IHttpRequestDescriptor requestDesc, OutputStream output) {
        PrintWriter writer = new PrintWriter(output);
        String escapeHtml = StringEscapeUtils.escapeHtml((String)requestDesc.getParameter("errorMessage").toString());
        StringBuilder sb = new StringBuilder();
        if (ExtIOProcessor.isScreenRequest((IRequestDescriptor)requestDesc)) {
            sb.append("this.loginResponse = {");
            sb.append("\"success\":false,");
            sb.append("\"title\" : \"");
            sb.append(StringEscapeUtils.escapeHtml((String)"Erro Cr\u00edtico"));
            sb.append("\", \"message\" : \"");
            sb.append(escapeHtml);
            sb.append("\", \"stackTrace\" : \"\" };");
            writer.append(sb.toString());
            writer.flush();
        } else {
            String scriptCSSDynamic = ExtIOProcessor.generateLoginPageCSS(false);
            sb.append(scriptCSSDynamic);
            sb.append("var btnLogin = Ext.getCmp('login');");
            sb.append("btnLogin.setMessageHint('");
            sb.append(requestDesc.getParameter("errorMessage").toString());
            sb.append("', true);");
            sb.append("btnLogin.setMessageVisible(true);");
            String loginPage = LoginPageGenerator.build(requestDesc.getParametersMap(), ExtResourceManager.FINGERPRINT, this.getInternalResourceManager().getThemeFingerprint(), sb.toString(), false, null);
            writer.write(loginPage);
            writer.flush();
        }
    }

    public boolean handleLoginStepFinish(IHttpRequestDescriptor requestDesc, OutputStream output) {
        boolean isScreen;
        boolean bl = isScreen = ExtIOProcessor.isScreenRequest((IRequestDescriptor)requestDesc) || ExtIOProcessor.isSubstituteUserRequest(requestDesc);
        if (isScreen) {
            PrintWriter writer = new PrintWriter(output);
            writer.write("window.location.reload(); this.loginResponse = { success : true };");
            writer.flush();
        }
        return isScreen;
    }

    private static boolean isSubstituteUserRequest(IHttpRequestDescriptor requestDesc) {
        String isSubstituteRequest = (String)requestDesc.getParameter(AuthenticationKey.SUBSTITUTE_USER_REQUEST.getValue());
        boolean isScreen = isSubstituteRequest != null && Boolean.parseBoolean(isSubstituteRequest);
        return isScreen;
    }

    private static boolean isScreenRequest(IRequestDescriptor requestDesc) {
        String isScreenRequest = (String)requestDesc.getParameter(AuthenticationKey.SCREEN_REQUEST.getValue());
        boolean isScreen = isScreenRequest != null && Boolean.parseBoolean(isScreenRequest);
        return isScreen;
    }

    public void handleSubstituteUser(IHttpRequestDescriptor requestDesc, OutputStream output) {
        List substituteUserInfo = (List)requestDesc.getParameter(SubstituteUserKey.SUBSTITUTED_USER_LIST.getValue());
        if (!substituteUserInfo.isEmpty()) {
            String jsonSubstituteUserList;
            JSONUtility utility = JSONUtility.getInstance();
            try {
                try {
                    utility.array();
                    int userSize = substituteUserInfo.size();
                    int i = 0;
                    while (i < userSize) {
                        String name;
                        ISubstitutedUser substituteUser = (ISubstitutedUser)substituteUserInfo.get(i);
                        utility.object();
                        IUser user = substituteUser.getUser();
                        utility.key("id").value(user.getId());
                        if (i == 0 && (SubstituteUserType)requestDesc.getParameter(SubstituteUserKey.SUBSTITUTED_USER_TYPE.getValue()) == SubstituteUserType.SINGLE) {
                            name = "N\u00e3o substituir ningu\u00e9m";
                        } else {
                            name = user.getFullName();
                            name = StringUtils.isEmpty((String)name) ? user.getName() : name;
                            name = name.replaceAll("\"", "\\\"");
                            name = String.format("%s (Usu\u00e1rio: %s - Per\u00edodo: %s a %s)", name, user.getName(), substituteUser.getDateStart().toString("dd/MM/yyyy"), substituteUser.getDateEnd().toString("dd/MM/yyyy"));
                        }
                        utility.key("name").value(name);
                        utility.end();
                        ++i;
                    }
                    utility.end();
                    jsonSubstituteUserList = utility.toString();
                }
                catch (SecurityException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                JSONUtility.release(utility);
            }
            PrintWriter writer = new PrintWriter(output);
            SubstituteUserType substituteUserType = (SubstituteUserType)requestDesc.getParameter(SubstituteUserKey.SUBSTITUTED_USER_TYPE.getValue());
            String scriptCSSDynamic = ExtIOProcessor.generateLoginPageCSS(true);
            String substituteUserPage = SubstituteUserGenerator.build(requestDesc.getParametersMap(), ExtResourceManager.FINGERPRINT, this.getInternalResourceManager().getThemeFingerprint(), jsonSubstituteUserList, substituteUserType.toString(), scriptCSSDynamic);
            writer.write(substituteUserPage);
            writer.flush();
        }
    }

    public void handleQuestionForgottenPassword(IHttpRequestDescriptor requestDesc, OutputStream output) {
        String jsonQuestionsList;
        List questionsList = (List)requestDesc.getParameter(AuthenticationKey.QUESTIONS_LIST.getValue());
        JSONUtility utility = JSONUtility.getInstance();
        try {
            try {
                utility.array();
                int questionsSize = questionsList.size();
                int i = 0;
                while (i < questionsSize) {
                    utility.object();
                    utility.key("text").value(questionsList.get(i));
                    utility.end();
                    ++i;
                }
                utility.end();
                jsonQuestionsList = utility.toString();
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            JSONUtility.release(utility);
        }
        PrintWriter writer = new PrintWriter(output);
        String scriptCSSDynamic = ExtIOProcessor.generateLoginPageCSS(true);
        String questionPage = QuestionPageGenerator.build(requestDesc.getParametersMap(), ExtResourceManager.FINGERPRINT, this.getInternalResourceManager().getThemeFingerprint(), jsonQuestionsList, scriptCSSDynamic);
        writer.write(questionPage);
        writer.flush();
    }

    public void handleUploadRequest(IHttpRequestDescriptor requestDesc, OutputStream output) {
        requestDesc.getUpload();
    }

    static final class Memento {
        private final Map<String, ExtPerspectiveSession> perspectiveSessions;

        Memento(Map<String, ExtPerspectiveSession> perspectives) {
            this.perspectiveSessions = perspectives == null ? Collections.emptyMap() : new HashMap<String, ExtPerspectiveSession>(perspectives);
        }
    }
}

