/*
 * Decompiled with CFR 0.152.
 */
package com.senior.ui.ext;

import cesium.factory.ResourcesLoaderFactory;
import cesium.factory.ResourcesLoaderFactoryImpl;
import cesium.factory.ResourcesProcessorFactory;
import cesium.factory.ResourcesProcessorFactoryImpl;
import cesium.holder.ResourcesHolder;
import cesium.holder.ThemeParametersHolder;
import cesium.loader.ResourcesLoader;
import cesium.op.ExtJSRescaleOp;
import cesium.op.ForegroundShiftOp;
import cesium.processor.ResourcesProcessor;
import cesium.theme.settings.Gray33ThemeSettings;
import com.senior.classloader.SeniortoolsClassLoader;
import com.senior.ui.ext.ResourceColorChange;
import java.awt.RenderingHints;
import java.awt.image.BufferedImageOp;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;

public final class Ext3ResourceBuilder {
    private static final String TEMPLATE_ID = "template_id";
    private static final String TOOLSET_NAME = "gray";
    private static final String THEME_PATH = "resources/images/gray/";
    private static final String DEFAULT_PATH = "resources/images/default/";
    private static final String DRAWABLE_PATH = "com/senior/client/resources/ext3/images/drawable/";
    private static final String EXT_VERSION = "3.3";
    private static final Gray33ThemeSettings THEME_SETTINGS = new Gray33ThemeSettings();
    private static final RenderingHints renderingHints;
    private static final ResourcesProcessorFactory resourcesProcessorFactory;
    private static final ResourcesLoaderFactory resourcesLoaderFactory;

    static {
        HashMap<RenderingHints.Key, Object> hints = new HashMap<RenderingHints.Key, Object>();
        hints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        resourcesProcessorFactory = new ResourcesProcessorFactoryImpl();
        resourcesLoaderFactory = new ResourcesLoaderFactoryImpl();
        renderingHints = new RenderingHints(hints);
    }

    private Ext3ResourceBuilder() {
    }

    public static InputStream generateResource(String path, ResourceColorChange resourceColor) {
        String newColorString;
        String newHeaderFontColorString;
        String completePath = THEME_PATH.concat(path);
        ResourcesLoader resourcesLoader = resourcesLoaderFactory.getResourcesLoader(completePath);
        InputStream is = SeniortoolsClassLoader.getResourceAsStream((String)completePath);
        if (is == null) {
            completePath = DEFAULT_PATH.concat(path);
            resourcesLoader = resourcesLoaderFactory.getResourcesLoader(completePath);
            is = SeniortoolsClassLoader.getResourceAsStream((String)completePath);
        }
        if (is == null) {
            throw new IllegalArgumentException(String.format("Resource not found: %s", completePath));
        }
        ResourcesHolder holder = resourcesLoader.loadResources(is, completePath, THEME_SETTINGS);
        completePath = DRAWABLE_PATH.concat(path);
        is = SeniortoolsClassLoader.getResourceAsStream((String)completePath);
        ResourcesHolder drawableHolder = null;
        if (is != null) {
            drawableHolder = resourcesLoader.loadResources(is, completePath, THEME_SETTINGS);
        }
        ResourcesProcessor processor = resourcesProcessorFactory.getResourcesProcessor(holder);
        int originalColor = Integer.parseInt(resourceColor.getOriginalColor(), 16);
        int newColor = Integer.parseInt(resourceColor.getColor(), 16);
        float redDiff = Ext3ResourceBuilder.getRedDiff(newColor, originalColor);
        float greenDiff = Ext3ResourceBuilder.getGreenDiff(newColor, originalColor);
        float blueDiff = Ext3ResourceBuilder.getBlueDiff(newColor, originalColor);
        float[] offsets = new float[]{redDiff, greenDiff, blueDiff, 0.0f};
        float[] scaleFactors = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        ExtJSRescaleOp brightenOp = new ExtJSRescaleOp(scaleFactors, offsets, renderingHints);
        ExtJSRescaleOp headerOp = new ExtJSRescaleOp(scaleFactors, offsets, renderingHints);
        ExtJSRescaleOp liteOp = new ExtJSRescaleOp(scaleFactors, offsets, renderingHints);
        ExtJSRescaleOp bgOp = new ExtJSRescaleOp(scaleFactors, offsets, renderingHints);
        ExtJSRescaleOp fontOp = new ExtJSRescaleOp(scaleFactors, offsets, renderingHints);
        ExtJSRescaleOp headerFontOp = new ExtJSRescaleOp(scaleFactors, offsets, renderingHints);
        int originalBorderColor = Integer.parseInt(resourceColor.getOriginalBorderColor(), 16);
        int newBorderColor = Integer.parseInt(resourceColor.getBorderColor(), 16);
        float borderRedDiff = Ext3ResourceBuilder.getRedDiff(newBorderColor, originalBorderColor);
        float borderGreenDiff = Ext3ResourceBuilder.getGreenDiff(newBorderColor, originalBorderColor);
        float borderBlueDiff = Ext3ResourceBuilder.getBlueDiff(newBorderColor, originalBorderColor);
        float[] offsetsBorder = new float[]{borderRedDiff, borderGreenDiff, borderBlueDiff, 0.0f};
        ExtJSRescaleOp borderOp = new ExtJSRescaleOp(scaleFactors, offsetsBorder, renderingHints);
        BufferedImageOp shadowTransparencyOp = null;
        ForegroundShiftOp foregroundOp = new ForegroundShiftOp(newColor >> 16 & 0xFF, newColor >> 8 & 0xFF, newColor & 0xFF);
        String newFontColorString = newHeaderFontColorString = (newColorString = String.valueOf(newColor));
        String weightFont = "";
        String weightHeaderFont = "";
        String sizeHeaderFontString = "";
        String sizeFontString = "";
        String familyFont = "";
        String familyHeaderFont = "";
        ThemeParametersHolder themeParametersHolder = new ThemeParametersHolder(TEMPLATE_ID, newColorString, newColorString, newColorString, newFontColorString, newHeaderFontColorString, familyHeaderFont, weightHeaderFont, sizeHeaderFontString, familyFont, weightFont, sizeFontString, newColorString, "", TOOLSET_NAME, EXT_VERSION);
        ResourcesHolder outputHolder = processor.process(holder, themeParametersHolder, brightenOp, foregroundOp, liteOp, bgOp, fontOp, null, borderOp, null, headerFontOp, shadowTransparencyOp, headerOp, holder, TOOLSET_NAME, familyHeaderFont, weightHeaderFont, (byte)0, familyFont, weightFont, (byte)0, drawableHolder);
        return new ByteArrayInputStream((byte[])outputHolder.getContent());
    }

    public static String generateColor(String baseColor, String originalColor, String destinationColor) {
        int base = Integer.parseInt(baseColor, 16);
        int original = Integer.parseInt(originalColor, 16);
        int destination = Integer.parseInt(destinationColor, 16);
        float redDiff = Ext3ResourceBuilder.getRedDiff(destination, base);
        float greenDiff = Ext3ResourceBuilder.getGreenDiff(destination, base);
        float blueDiff = Ext3ResourceBuilder.getBlueDiff(destination, base);
        float[] offsets = new float[]{redDiff, greenDiff, blueDiff, 0.0f};
        float[] scaleFactors = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        ExtJSRescaleOp changeColorOp = new ExtJSRescaleOp(scaleFactors, offsets, renderingHints);
        byte[] bytesR = new byte[]{(byte)(original >> 16 & 0xFF)};
        byte[] bytesG = new byte[]{(byte)(original >> 8 & 0xFF)};
        byte[] bytesB = new byte[]{(byte)(original & 0xFF)};
        changeColorOp.rescale(bytesR, bytesG, bytesB, null, scaleFactors, offsets, null, null);
        StringBuilder sb = new StringBuilder("#");
        String color = Integer.toString(bytesR[0] & 0xFF, 16);
        if (color.length() == 1) {
            sb.append("0");
        }
        sb.append(color);
        color = Integer.toString(bytesG[0] & 0xFF, 16);
        if (color.length() == 1) {
            sb.append("0");
        }
        sb.append(color);
        color = Integer.toString(bytesB[0] & 0xFF, 16);
        if (color.length() == 1) {
            sb.append("0");
        }
        sb.append(color);
        return sb.toString();
    }

    private static float getRedDiff(int color1, int color2) {
        int red1 = color1 >> 16 & 0xFF;
        int red2 = color2 >> 16 & 0xFF;
        return red1 - red2;
    }

    private static float getGreenDiff(int color1, int color2) {
        int green1 = color1 >> 8 & 0xFF;
        int green2 = color2 >> 8 & 0xFF;
        return green1 - green2;
    }

    private static float getBlueDiff(int color1, int color2) {
        int blue1 = color1 & 0xFF;
        int blue2 = color2 & 0xFF;
        return blue1 - blue2;
    }
}

