/*
 * Decompiled with CFR 0.152.
 */
package com.senior.ui.ext;

import com.senior.ui.core.theme.StyleEntry;
import com.senior.ui.core.theme.StyleProperty;
import com.senior.ui.core.theme.StyleScope;
import com.senior.ui.core.theme.ThemeManager;
import com.senior.ui.ext.Ext3ResourceBuilder;
import com.senior.ui.ext.ExtImageInfo;
import com.senior.ui.ext.ResourceColorChange;
import com.senior.ui.ext.ResourceCreatorManager;
import com.senior.ui.ext.style.CSSProperty;
import com.senior.ui.ext.style.CSSUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.map.MultiKeyMap;
import org.apache.commons.lang.StringUtils;

public final class CSSBuilder {
    private static final Map<StyleProperty, String> styleProperty = new HashMap<StyleProperty, String>();
    private static final Map<StyleEntry, PropertiesBuilder> specializedPropertiesBuilder = new HashMap<StyleEntry, PropertiesBuilder>();
    private static final Map<StyleScope, GroupedPropertiesBuilder> specializedGroupedPropertiesBuilder = new HashMap<StyleScope, GroupedPropertiesBuilder>();
    private static final MultiKeyMap specializedStyleProperty = new MultiKeyMap();

    static {
        styleProperty.put(StyleProperty.BACKGROUND, "background-color");
        styleProperty.put(StyleProperty.BACKGROUND_IMAGE, "background-image");
        styleProperty.put(StyleProperty.BACKGROUND_POSITION, "background-position");
        styleProperty.put(StyleProperty.BACKGROUND_REPEAT, "background-repeat");
        styleProperty.put(StyleProperty.BACKGROUND_ATTACHMENT, "background-attachment");
        styleProperty.put(StyleProperty.BORDER_COLOR, "border-color");
        styleProperty.put(StyleProperty.BORDER_TYPE, "border-style");
        styleProperty.put(StyleProperty.BORDER_SIZE, "border-width");
        styleProperty.put(StyleProperty.BORDER_COLOR, "border-color");
        styleProperty.put(StyleProperty.CALENDAR_NEXT_MONTH_ICON, "background-image");
        styleProperty.put(StyleProperty.CALENDAR_NEXT_YEAR_ICON, "background-image");
        styleProperty.put(StyleProperty.CALENDAR_PREVIOUS_MONTH_ICON, "background-image");
        styleProperty.put(StyleProperty.CALENDAR_PREVIOUS_YEAR_ICON, "background-image");
        styleProperty.put(StyleProperty.COMBO_ICON, "background-image");
        styleProperty.put(StyleProperty.DATE_ICON, "background-image");
        styleProperty.put(StyleProperty.FONT_COLOR, "color");
        styleProperty.put(StyleProperty.FONT_FAMILY, "font-family");
        styleProperty.put(StyleProperty.FONT_SIZE, "font-size");
        styleProperty.put(StyleProperty.FONT_STYLE, "font-style");
        styleProperty.put(StyleProperty.HEIGHT, "height");
        styleProperty.put(StyleProperty.MARGIN, "margin");
        styleProperty.put(StyleProperty.PADDING, "padding");
        styleProperty.put(StyleProperty.ROW1_BACKGROUND_COLOR, "background-color");
        styleProperty.put(StyleProperty.ROW2_BACKGROUND_COLOR, "background-color");
        styleProperty.put(StyleProperty.SEARCH_ICON, "background-image");
        styleProperty.put(StyleProperty.TREE_NODE_COLLAPSED_ICON, "background-image");
        styleProperty.put(StyleProperty.TREE_NODE_EXPANDED_ICON, "background-image");
        styleProperty.put(StyleProperty.TREE_NODE_LEAF_ICON, "background-image");
        styleProperty.put(StyleProperty.WIDTH, "width");
        styleProperty.put(StyleProperty.TRANSITION, "transition");
        styleProperty.put(StyleProperty.ICON, "background-image");
        specializedStyleProperty.put((Object)StyleScope.CHECKBOX, (Object)StyleProperty.BORDER_COLOR, (Object)"outline-color");
        specializedStyleProperty.put((Object)StyleScope.CHECKBOX, (Object)StyleProperty.BORDER_SIZE, (Object)"outline-width");
        specializedStyleProperty.put((Object)StyleScope.CHECKBOX, (Object)StyleProperty.BORDER_TYPE, (Object)"outline-style");
        specializedPropertiesBuilder.put(new StyleEntry(StyleScope.EDITBOX, StyleProperty.BACKGROUND, ""), new CompositePropertiesBuilder(new ImagePropertiesBuilder("form/text-bg.gif", "F0F3F3"), new ColorPropertiesBuilder("F0F3F3", "FFFFFF")));
        specializedPropertiesBuilder.put(new StyleEntry(StyleScope.COMBO, StyleProperty.BACKGROUND, ""), new CompositePropertiesBuilder(new ImagePropertiesBuilder("form/text-bg.gif", "F0F3F3"), new ColorPropertiesBuilder("F0F3F3", "FFFFFF")));
        specializedPropertiesBuilder.put(new StyleEntry(StyleScope.TEXT_AREA, StyleProperty.BACKGROUND, ""), new CompositePropertiesBuilder(new ImagePropertiesBuilder("form/text-bg.gif", "F0F3F3"), new ColorPropertiesBuilder("F0F3F3", "FFFFFF")));
        specializedPropertiesBuilder.put(new StyleEntry(StyleScope.CALENDAR_FOOTER, StyleProperty.BACKGROUND, ""), new ImagePropertiesBuilder("panel/white-top-bottom.gif", "EDEDED"));
        specializedPropertiesBuilder.put(new StyleEntry(StyleScope.CALENDAR_HEADER, StyleProperty.BACKGROUND, ""), new ImagePropertiesBuilder("panel/white-top-bottom.gif", "EDEDED"));
        specializedGroupedPropertiesBuilder.put(StyleScope.PANEL_HEADER, new ImageGroupedPropertiesBuilder(true, new ExtImageInfo("EDEDED", "panel/white-top-bottom.gif"), new ExtImageInfo("F1F1F1", "panel/tool-sprites.gif"), new ExtImageInfo("F1F1F1", "panel/tool-sprites.gif")));
        ExtImageInfo buttonImageInfo = new ExtImageInfo("F1F1F1", "BBBBBB", "button/btn.gif");
        specializedGroupedPropertiesBuilder.put(StyleScope.BUTTON, new ImageGroupedPropertiesBuilder(false, buttonImageInfo));
        specializedGroupedPropertiesBuilder.put(StyleScope.FILE_BUTTON, new ImageGroupedPropertiesBuilder(false, buttonImageInfo));
        specializedGroupedPropertiesBuilder.put(StyleScope.TABGROUP_HEADER, new ImageGroupedPropertiesBuilder(true, new ExtImageInfo("E7E7E7", "AEAEAE", "tabs/tabs-sprite.gif"), new ExtImageInfo("EAEAEA", "AEAEAE", "tabs/tab-btm-inactive-right-bg.gif"), new ExtImageInfo("EAEAEA", "AEAEAE", "tabs/tab-btm-inactive-left-bg.gif")));
        specializedGroupedPropertiesBuilder.put(StyleScope.TABGROUP_HEADER_ACTIVE, new ImageGroupedPropertiesBuilder(true, new ExtImageInfo("EAEAEA", "AEAEAE", "tabs/tabs-sprite.gif"), new ExtImageInfo("EAEAEA", "AEAEAE", "tabs/tab-btm-right-bg.gif"), new ExtImageInfo("EAEAEA", "AEAEAE", "tabs/tab-btm-left-bg.gif")));
    }

    private CSSBuilder() {
    }

    public static CSSUtility generateCSSClass(String className, String value, StyleEntry entry) {
        CSSProperty[] properties;
        CSSUtility css = new CSSUtility(className);
        PropertiesBuilder propertiesBuilder = CSSBuilder.getPropertiesBuilder(entry);
        CSSProperty[] cSSPropertyArray = properties = propertiesBuilder.generateCSSProperties(value, entry);
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            CSSProperty a = cSSPropertyArray[n2];
            css.addProperty(a, true);
            ++n2;
        }
        return css;
    }

    public static CSSUtility[] generateCssClassesOfGroupedProperties(String baseClassName, StyleEntry[] entries, String[] values) {
        assert (entries.length == values.length);
        GroupedPropertiesBuilder groupedPropertiesBuilder = specializedGroupedPropertiesBuilder.get(entries[0].getScope());
        List<CSSUtility> cssClasses = Collections.emptyList();
        if (groupedPropertiesBuilder != null) {
            CSSProperty[] cssProperties = groupedPropertiesBuilder.generateCSSProperties(entries, values);
            cssClasses = new ArrayList(cssProperties.length);
            int i = 0;
            while (i < cssProperties.length) {
                CSSUtility css = new CSSUtility(baseClassName.concat("-" + i));
                css.addProperty(cssProperties[i], true);
                cssClasses.add(css);
                ++i;
            }
        }
        return cssClasses.toArray(new CSSUtility[cssClasses.size()]);
    }

    public static String mergeCSSClasses(String[] classes, String className) {
        if (classes == null) {
            throw new IllegalArgumentException("Classes cannot be null");
        }
        Pattern pattern = Pattern.compile("\\..*\\{(.*)\\}");
        StringBuilder mergedClass = new StringBuilder();
        Matcher matcher = null;
        String[] stringArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            String cssClass = stringArray[n2];
            matcher = pattern.matcher(cssClass);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Invalid css format: " + cssClass);
            }
            if (mergedClass.length() == 0) {
                mergedClass.append('.').append(className).append(" {");
            }
            String entry = matcher.group(1);
            mergedClass.append(entry);
            if (!entry.endsWith(";")) {
                mergedClass.append(';');
            }
            ++n2;
        }
        mergedClass.append('}');
        return mergedClass.toString();
    }

    private static PropertiesBuilder getPropertiesBuilder(StyleEntry entry) {
        PropertiesBuilder builder = specializedPropertiesBuilder.get(entry);
        if (builder != null) {
            return builder;
        }
        if (entry.getProperty() == StyleProperty.FONT_STYLE) {
            return FontStylePropertiesBuilder.SINGLETON;
        }
        return BasicPropertiesBuilder.SINGLETON;
    }

    private static class BasicPropertiesBuilder
    implements PropertiesBuilder {
        static final BasicPropertiesBuilder SINGLETON = new BasicPropertiesBuilder();

        private BasicPropertiesBuilder() {
        }

        @Override
        public CSSProperty[] generateCSSProperties(String value, StyleEntry entry) {
            CSSProperty[] properties = new CSSProperty[1];
            String property = (String)specializedStyleProperty.get((Object)entry.getScope(), (Object)entry.getProperty());
            if (property == null) {
                property = (String)styleProperty.get(entry.getProperty());
            }
            properties[0] = new CSSProperty(property, value);
            return properties;
        }
    }

    private static class ColorPropertiesBuilder
    implements PropertiesBuilder {
        private final String baseColor;
        private final String originalColor;

        ColorPropertiesBuilder(String baseColor, String originalColor) {
            this.baseColor = baseColor;
            this.originalColor = originalColor;
        }

        @Override
        public CSSProperty[] generateCSSProperties(String value, StyleEntry entry) {
            CSSProperty[] properties = new CSSProperty[1];
            String property = (String)specializedStyleProperty.get((Object)entry.getScope(), (Object)entry.getProperty());
            if (property == null) {
                property = (String)styleProperty.get(entry.getProperty());
            }
            String color = Ext3ResourceBuilder.generateColor(this.baseColor, this.originalColor, value.replace("#", ""));
            properties[0] = new CSSProperty(property, color);
            return properties;
        }
    }

    private static class CompositePropertiesBuilder
    implements PropertiesBuilder {
        private final PropertiesBuilder propertiesBuilder;
        private final PropertiesBuilder[] compositePropertiesBuilders;

        CompositePropertiesBuilder(PropertiesBuilder propertiesBuilder, PropertiesBuilder ... compositeProperties) {
            this.propertiesBuilder = propertiesBuilder;
            this.compositePropertiesBuilders = compositeProperties;
        }

        @Override
        public CSSProperty[] generateCSSProperties(String value, StyleEntry entry) {
            ArrayList<CSSProperty> properties = new ArrayList<CSSProperty>();
            Object[] objectArray = this.propertiesBuilder.generateCSSProperties(value, entry);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                CSSProperty cssAttribute = objectArray[n2];
                properties.add(cssAttribute);
                ++n2;
            }
            objectArray = this.compositePropertiesBuilders;
            n = this.compositePropertiesBuilders.length;
            n2 = 0;
            while (n2 < n) {
                Object pB = objectArray[n2];
                CSSProperty[] cSSPropertyArray = pB.generateCSSProperties(value, entry);
                int n3 = cSSPropertyArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    CSSProperty cssAttribute = cSSPropertyArray[n4];
                    properties.add(cssAttribute);
                    ++n4;
                }
                ++n2;
            }
            return properties.toArray(new CSSProperty[properties.size()]);
        }
    }

    private static class FontStylePropertiesBuilder
    implements PropertiesBuilder {
        static final FontStylePropertiesBuilder SINGLETON = new FontStylePropertiesBuilder();

        private FontStylePropertiesBuilder() {
        }

        @Override
        public CSSProperty[] generateCSSProperties(String value, StyleEntry entry) {
            CSSProperty[] properties = new CSSProperty[3];
            String[] fontStyles = StringUtils.isEmpty((String)value) ? new String[]{} : value.split(" ");
            boolean italic = false;
            boolean bold = false;
            String lineStyle = "none";
            String[] stringArray = fontStyles;
            int n = fontStyles.length;
            int n2 = 0;
            while (n2 < n) {
                String fontStyle = stringArray[n2];
                if ("bold".equals(fontStyle = fontStyle.trim())) {
                    bold = true;
                } else if ("italic".equals(fontStyle)) {
                    italic = true;
                } else if (fontStyle.equals("underline") || fontStyle.equals("overline") || fontStyle.equals("line-through")) {
                    lineStyle = fontStyle;
                }
                ++n2;
            }
            properties[0] = new CSSProperty("font-weight", bold ? "bold" : "normal");
            properties[1] = new CSSProperty("font-style", italic ? "italic" : "normal");
            properties[2] = new CSSProperty("text-decoration", lineStyle);
            return properties;
        }
    }

    private static interface GroupedPropertiesBuilder {
        public CSSProperty[] generateCSSProperties(StyleEntry[] var1, String[] var2);
    }

    private static class ImageGroupedPropertiesBuilder
    implements GroupedPropertiesBuilder {
        private final ExtImageInfo[] originalImages;
        private final boolean needColorProperties;

        ImageGroupedPropertiesBuilder(boolean needColorProperties, ExtImageInfo ... images) {
            this.originalImages = images;
            this.needColorProperties = needColorProperties;
        }

        @Override
        public CSSProperty[] generateCSSProperties(StyleEntry[] entries, String[] values) {
            ArrayList<CSSProperty> properties = new ArrayList<CSSProperty>(this.originalImages.length);
            String background = null;
            String borderColor = null;
            int idx = 0;
            while (idx < entries.length) {
                if (entries[idx].getProperty() == StyleProperty.BACKGROUND) {
                    background = values[idx];
                } else if (entries[idx].getProperty() == StyleProperty.BORDER_COLOR) {
                    borderColor = values[idx];
                }
                ++idx;
            }
            ExtImageInfo[] extImageInfoArray = this.originalImages;
            int n = this.originalImages.length;
            int n2 = 0;
            while (n2 < n) {
                ExtImageInfo image = extImageInfoArray[n2];
                if (background == null && (background = ThemeManager.getInstance().getCurrentTheme().styleFor(entries[0].getScope(), StyleProperty.BACKGROUND)) == null) {
                    background = image.getBackgroundColor();
                }
                if (borderColor == null && image.hasBorder()) {
                    borderColor = ThemeManager.getInstance().getCurrentTheme().styleFor(entries[0].getScope(), StyleProperty.BORDER_COLOR);
                }
                if (borderColor == null) {
                    borderColor = image.getBorderColor();
                }
                background = background.replace("#", "");
                borderColor = borderColor != null ? borderColor.replace("#", "") : background;
                String imageUrl = ResourceCreatorManager.getResourceCreator().createImage(entries[0].getScope(), entries[0].getProperty(), image.getImagePath(), new ResourceColorChange(background, image.getBackgroundColor(), borderColor, image.getBorderColor()), null);
                properties.add(new CSSProperty("background-image", imageUrl));
                ++n2;
            }
            if (this.needColorProperties) {
                properties.add(new CSSProperty("background-color", "#".concat(background)));
                properties.add(new CSSProperty("border-color", "#".concat(background)));
                properties.add(new CSSProperty("border-color", "#".concat(borderColor)));
            }
            return properties.toArray(new CSSProperty[properties.size()]);
        }
    }

    private static class ImagePropertiesBuilder
    implements PropertiesBuilder {
        private final String originalImage;
        private final String originalColor;

        ImagePropertiesBuilder(String originalImage, String originalColor) {
            this.originalImage = originalImage;
            this.originalColor = originalColor;
        }

        @Override
        public CSSProperty[] generateCSSProperties(String value, StyleEntry entry) {
            CSSProperty[] properties = new CSSProperty[]{new CSSProperty("background-image", ResourceCreatorManager.getResourceCreator().createImage(entry.getScope(), entry.getProperty(), this.originalImage, new ResourceColorChange(value.replace("#", ""), this.originalColor), null))};
            return properties;
        }
    }

    private static interface PropertiesBuilder {
        public CSSProperty[] generateCSSProperties(String var1, StyleEntry var2);
    }
}

