/*
 * Decompiled with CFR 0.152.
 */
package com.senior.ui;

import com.senior.ui.core.FragmentDescriptor;
import com.senior.ui.core.IPerspectiveSessionListener;
import com.senior.ui.core.IRenderer;
import com.senior.ui.core.PerspectiveDescriptor;
import com.senior.ui.core.PerspectiveManager;
import com.senior.ui.core.PerspectiveSession;
import com.senior.ui.core.message.Message;
import com.senior.ui.core.message.MessageStatus;
import com.senior.ui.core.message.RenderMessage;
import com.senior.ui.core.message.SynchronizableMessage;
import com.senior.ui.ext.RequestProperties;
import com.senior.ui.ext.action.ExtActionCommand;
import com.senior.ui.ext.action.ExtActionCommandFactory;
import com.senior.ui.ext.renderer.Ext3Renderer;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExtPerspectiveSession
implements IPerspectiveSessionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ExtPerspectiveSession.class.getName());
    private final List<ExtActionCommand> initActions = new ArrayList<ExtActionCommand>();
    private final List<ExtActionCommand> afterActions;
    private final List<ExtActionCommand> beforeActions = new ArrayList<ExtActionCommand>();
    private final List<ExtActionCommand> servletActions;
    private final PerspectiveSession perspectiveSession;

    public ExtPerspectiveSession(String perspectiveId) {
        this.afterActions = new ArrayList<ExtActionCommand>();
        this.servletActions = new ArrayList<ExtActionCommand>();
        PerspectiveManager manager = PerspectiveManager.getInstance();
        this.perspectiveSession = manager.createPerspectiveSession(perspectiveId, (IPerspectiveSessionListener)this);
        this.perspectiveSession.requestSessionStart();
        this.createInitActions();
    }

    public ExtPerspectiveSession(String perspectiveURL, Map<String, Object> parameters) {
        this.afterActions = new ArrayList<ExtActionCommand>();
        this.servletActions = new ArrayList<ExtActionCommand>();
        PerspectiveManager manager = PerspectiveManager.getInstance();
        this.perspectiveSession = manager.createPerspectiveSessionByURL(perspectiveURL, (IPerspectiveSessionListener)this);
        manager.startPerspective(this.perspectiveSession.getPerspectiveId(), parameters);
        this.perspectiveSession.requestSessionStart();
        this.createInitActions();
    }

    private void createInitActions() {
        PerspectiveDescriptor perspectiveDescriptor = this.perspectiveSession.getPerspectiveDescriptor();
        LOGGER.debug("\n\nPerspective id = " + perspectiveDescriptor.getId() + "\n");
        ExtActionCommand registerAction = ExtActionCommandFactory.getInstance(ExtActionCommand.ExtActionType.REGISTER_PERSPECTIVE);
        registerAction.setProperty("perspectiveId", perspectiveDescriptor.getId());
        this.initActions.add(registerAction);
        this.afterActions.add(ExtActionCommandFactory.getInstance(ExtActionCommand.ExtActionType.AFTER_RENDER));
    }

    public PerspectiveDescriptor getPerspectiveDescriptor() {
        return this.perspectiveSession.getPerspectiveDescriptor();
    }

    public void postMessage(Message message) {
        this.perspectiveSession.postMessage(message);
    }

    public void postAndWaitMessage(SynchronizableMessage message) {
        this.perspectiveSession.postMessageAndWait(message);
    }

    public void destroy() {
        this.perspectiveSession.removeSessionListener((IPerspectiveSessionListener)this);
        PerspectiveManager manager = PerspectiveManager.getInstance();
        manager.destroyPerspectiveSession(this.perspectiveSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void errorOccurred(Throwable throwable) {
        LOGGER.warn("Erro durante a inicializa\u00e7\u00e3o da perspectiva", throwable);
        ExtActionCommand action = ExtActionCommandFactory.getInstance(ExtActionCommand.ExtActionType.REDIRECT);
        action.setProperty("url", "./error/?message=".concat(throwable.getMessage()));
        List<ExtActionCommand> list = this.servletActions;
        synchronized (list) {
            this.servletActions.add(action);
        }
    }

    public void perspectiveSessionStarted(String perspectiveId) {
        ExtActionCommand cmd = ExtActionCommandFactory.getInstance(ExtActionCommand.ExtActionType.RENDER_CONTEXT);
        PerspectiveDescriptor descriptor = this.perspectiveSession.getPerspectiveDescriptor();
        cmd.setProperty("perspective-id", descriptor.getId());
        cmd.setProperty("component-id", descriptor.getComponentId());
        this.initActions.add(cmd);
        FragmentDescriptor[] fragmentDescriptorArray = descriptor.getFragments();
        int n = fragmentDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            FragmentDescriptor desc = fragmentDescriptorArray[n2];
            cmd = ExtActionCommandFactory.getInstance(ExtActionCommand.ExtActionType.RENDER_CONTEXT);
            cmd.setProperty("perspective-id", descriptor.getId());
            cmd.setProperty("fragment-id", desc.getId());
            cmd.setProperty("component-id", desc.getComponentId());
            this.initActions.add(cmd);
            ++n2;
        }
    }

    public void fragmentCreated(FragmentDescriptor desc) {
        ExtActionCommand cmd = ExtActionCommandFactory.getInstance(ExtActionCommand.ExtActionType.RENDER_CONTEXT);
        cmd.setProperty("perspective-id", desc.getPerspectiveDescriptor().getId());
        cmd.setProperty("fragment-id", desc.getId());
        cmd.setProperty("component-id", desc.getComponentId());
        this.beforeActions.add(cmd);
    }

    public void perspectiveOpened(String perspectiveURL, String vision) {
        ExtActionCommand openUrlAction = ExtActionCommandFactory.getInstance(ExtActionCommand.ExtActionType.OPEN_URL);
        HashMap<String, String> parameters = new HashMap<String, String>(2, 1.0f);
        parameters.put(RequestProperties.PERSPECTIVE.getValue(), perspectiveURL);
        if (vision != null) {
            parameters.put(RequestProperties.PERSPECTIVE_LAYOUT.getValue(), vision);
        }
        openUrlAction.setProperty("parameters", parameters);
        openUrlAction.setProperty("url", "");
        openUrlAction.setProperty("name", String.valueOf(new UID().toString()));
        this.afterActions.add(openUrlAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestRender(Ext3Renderer renderer, StringBuilder output) {
        ExtActionCommand cmd;
        boolean isIdle;
        RenderMessage message = this.perspectiveSession.createRenderMessage((IRenderer)renderer, (Object)new StringBuilder());
        this.perspectiveSession.postMessageAndWait((SynchronizableMessage)message);
        if (message.getStatus() == MessageStatus.ERROR) {
            Throwable error = (Throwable)message.getData().get("exception");
            if (error == null) {
                error = new Exception("Ocorreu um erro inesperado, contate o administrador.");
            }
            throw new RuntimeException(error);
        }
        output.append((CharSequence)message.getBuffer());
        boolean bl = isIdle = message.getStatus() == MessageStatus.DONE && (Boolean)message.getData().get("IsIdle") != false;
        if (!isIdle) {
            cmd = ExtActionCommandFactory.getInstance(ExtActionCommand.ExtActionType.ASK_LATER);
            cmd.setProperty("perspectiveId", this.perspectiveSession.getPerspectiveDescriptor().getId());
        } else {
            cmd = ExtActionCommandFactory.getInstance(ExtActionCommand.ExtActionType.WAIT_SERVER_IDLE);
        }
        ArrayList<ExtActionCommand> actionsTemp = new ArrayList<ExtActionCommand>();
        actionsTemp.add(cmd);
        List<ExtActionCommand> list = this.servletActions;
        synchronized (list) {
            if (!this.servletActions.isEmpty()) {
                actionsTemp.addAll(this.servletActions);
                this.servletActions.clear();
            }
        }
        renderer.renderExtActions(actionsTemp, output);
    }

    public void perspectiveSessionStoped(String perspectiveId) {
    }

    public void afterRender(IRenderer<?> renderer, Object output) {
        ((Ext3Renderer)renderer).renderExtActions(this.afterActions, (StringBuilder)output);
        this.afterActions.clear();
    }

    public void beforeRender(IRenderer<?> renderer, Object output) {
        ((Ext3Renderer)renderer).renderExtActions(this.initActions, (StringBuilder)output);
        ((Ext3Renderer)renderer).renderExtActions(this.beforeActions, (StringBuilder)output);
        this.initActions.clear();
        this.beforeActions.clear();
    }
}

