/*
 * Decompiled with CFR 0.152.
 */
package com.senior.client;

import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.JSSourceFile;
import com.senior.client.JavascriptImportUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.joda.time.LocalDate;

public class JavascriptOptimizer {
    private static final String JAVASCRIPTS_SOURCE_PATH = "src/main/resources/com/senior/client/resources/ext3/";
    private static final String SENIOR_ALL_FILE = "js/senior-all.js";
    private static final String CHARSET = "ISO-8859-1";

    private static JSSourceFile[] getJSSourceFileArray(List<String> files) {
        JSSourceFile[] array = new JSSourceFile[files.size()];
        int index = 0;
        while (index < array.length) {
            array[index] = JSSourceFile.fromFile((String)(JAVASCRIPTS_SOURCE_PATH + files.get(index)), (Charset)Charset.forName(CHARSET));
            ++index;
        }
        return array;
    }

    private static void optimizeJavascripts() throws IOException {
        int debugLevel = 1;
        boolean selenium = false;
        JSSourceFile[] externalFiles = new JSSourceFile[]{};
        JSSourceFile[] seniorFiles = JavascriptOptimizer.getJSSourceFileArray(JavascriptImportUtils.getSeniorJavascripts(debugLevel, selenium));
        CompilerOptions options = new CompilerOptions();
        CompilationLevel.WHITESPACE_ONLY.setOptionsForCompilationLevel(options);
        options.lineLengthThreshold(0);
        options.setOutputCharset(CHARSET);
        Compiler compiler = new Compiler();
        compiler.compile(externalFiles, seniorFiles, options);
        if (compiler.hasErrors()) {
            throw new RuntimeException("Errors were found when compiling the javascripts. See more details on console.");
        }
        String optimized = compiler.toSource();
        if (JavascriptOptimizer.isModified(optimized)) {
            Throwable throwable = null;
            Object var8_9 = null;
            try (FileWriter outputFile = new FileWriter(JAVASCRIPTS_SOURCE_PATH.concat(SENIOR_ALL_FILE));){
                outputFile.write(JavascriptOptimizer.getSeniorCopyright());
                outputFile.write(optimized);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isModified(String newScript) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            FileReader fileReader = new FileReader(JAVASCRIPTS_SOURCE_PATH.concat(SENIOR_ALL_FILE));
            try {
                boolean bl;
                block16: {
                    BufferedReader fileBuffer = new BufferedReader(fileReader);
                    try {
                        String lastLine = null;
                        while (true) {
                            String line;
                            if ((line = fileBuffer.readLine()) == null) {
                                if (!newScript.equals(lastLine)) break;
                                bl = false;
                            }
                            lastLine = line;
                        }
                        bl = true;
                        return bl;
                    }
                    finally {
                        if (fileBuffer == null) break block16;
                        fileBuffer.close();
                    }
                }
                if (fileReader != null) {
                    fileReader.close();
                }
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (fileReader == null) throw throwable;
                fileReader.close();
                throw throwable;
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    private static String getSeniorCopyright() {
        LocalDate date = new LocalDate();
        StringBuilder sb = new StringBuilder("/*\n *");
        sb.append(" Created on ").append(date.toString("dd/MM/yyyy")).append("\n *\n *");
        sb.append(" Copyright ").append(date.toString("yyyy")).append(" Senior Sistemas Ltda. All rights reserved.\n */\n");
        return sb.toString();
    }

    public static void main(String[] args) throws IOException {
        JavascriptOptimizer.optimizeJavascripts();
    }
}

