/*
 * Decompiled with CFR 0.152.
 */
package cesium.processor;

import cesium.processor.AbstractResourcesProcessor;
import cesium.utils.ExtJSPixelGrabber;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.Raster;

public abstract class AbstractImageProcessor
extends AbstractResourcesProcessor {
    protected ColorModel getColorModel(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            return bimage.getColorModel();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {}
        ColorModel cm = pg.getColorModel();
        return cm;
    }

    public static BufferedImage convertType(BufferedImage image, int type) {
        BufferedImage result;
        if (image.getType() == type) {
            return image;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        ExtJSPixelGrabber pixelGrabber = new ExtJSPixelGrabber(image);
        pixelGrabber.grabPixels();
        Object pixels = pixelGrabber.getPixels();
        if (type != 13) {
            result = new BufferedImage(width, height, type);
            int y = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    int pixel = ((int[])pixels)[x + y * width];
                    int newA = pixelGrabber.getAlpha(pixel);
                    int newR = pixelGrabber.getRed(pixel);
                    int newG = pixelGrabber.getGreen(pixel);
                    int newB = pixelGrabber.getBlue(pixel);
                    int rgb = newA << 24 & 0xFF000000 | newR << 16 & 0xFF0000 | newG << 8 & 0xFF00 | newB & 0xFF;
                    result.setRGB(x, y, rgb);
                    ++x;
                }
                ++y;
            }
        } else if (image.getColorModel() instanceof ComponentColorModel) {
            int size = width * height;
            byte[] r = new byte[size];
            byte[] g = new byte[size];
            byte[] b = new byte[size];
            byte[] a = new byte[size];
            Raster raster = image.getData();
            DataBuffer dataBuffer = raster.getDataBuffer();
            int y = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    int pixel = x + y * width;
                    int index = 4 * pixel;
                    r[pixel] = (byte)dataBuffer.getElem(index);
                    g[pixel] = (byte)dataBuffer.getElem(index + 1);
                    b[pixel] = (byte)dataBuffer.getElem(index + 2);
                    a[pixel] = (byte)dataBuffer.getElem(index + 3);
                    ++x;
                }
                ++y;
            }
            IndexColorModel indexColorModel = new IndexColorModel(8, size, r, g, b, a);
            result = new BufferedImage(width, height, type, indexColorModel);
        } else {
            int size = width * height;
            byte[] r = new byte[size];
            byte[] g = new byte[size];
            byte[] b = new byte[size];
            byte[] a = new byte[size];
            int y = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    int pixel = ((int[])pixels)[x + y * width];
                    a[pixel] = (byte)pixelGrabber.getAlpha(pixel);
                    r[pixel] = (byte)pixelGrabber.getRed(pixel);
                    g[pixel] = (byte)pixelGrabber.getGreen(pixel);
                    b[pixel] = (byte)pixelGrabber.getBlue(pixel);
                    ++x;
                }
                ++y;
            }
            IndexColorModel indexColorModel = new IndexColorModel(8, size, r, g, b, a);
            result = new BufferedImage(width, height, type, indexColorModel);
        }
        return result;
    }
}

