/*
 * Decompiled with CFR 0.152.
 */
package cesium.pool;

import java.util.Enumeration;
import java.util.Hashtable;

public abstract class ObjectPool<T> {
    private final long expirationTime;
    private final Hashtable<T, Long> locked;
    private final Hashtable<T, Long> unlocked;

    protected ObjectPool(long expirationTime) {
        this.expirationTime = expirationTime;
        this.locked = new Hashtable();
        this.unlocked = new Hashtable();
    }

    protected abstract T create();

    public abstract boolean validate(T var1);

    public abstract void expire(T var1);

    public synchronized T checkOut() {
        T t;
        long now = System.currentTimeMillis();
        if (!this.unlocked.isEmpty()) {
            Enumeration<T> e = this.unlocked.keys();
            while (e.hasMoreElements()) {
                t = e.nextElement();
                Long time = this.unlocked.get(t);
                if (time > 0L && now - time > this.expirationTime) {
                    this.unlocked.remove(t);
                    this.expire(t);
                    t = null;
                    continue;
                }
                if (this.validate(t)) {
                    Long aLong = this.unlocked.remove(t);
                    this.locked.put(t, aLong);
                    return t;
                }
                this.unlocked.remove(t);
                this.expire(t);
                t = null;
            }
        }
        t = this.create();
        this.locked.put(t, now);
        return t;
    }

    public synchronized void checkIn(T t) {
        Long aLong = this.locked.remove(t);
        this.unlocked.put(t, aLong != null ? aLong : 0L);
    }

    public synchronized int getCapacity() {
        int result = 0;
        result += this.locked != null ? this.locked.size() : 0;
        return result += this.unlocked != null ? this.unlocked.size() : 0;
    }
}

