/*
 * Decompiled with CFR 0.152.
 */
package cesium.loader;

import cesium.holder.PNGHolderImpl;
import cesium.holder.ResourcesHolder;
import cesium.loader.AbstractResourcesLoader;
import cesium.theme.settings.BorderSet;
import cesium.theme.settings.ThemeSettings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class PNGResourceLoaderImpl
extends AbstractResourcesLoader {
    public PNGResourceLoaderImpl() {
    }

    public PNGResourceLoaderImpl(String resourcesPath) {
        this.setResourcesPath(resourcesPath);
    }

    @Override
    public ResourcesHolder loadResources(InputStream resource, String resourcePath, ThemeSettings themeSettings) {
        String path2resource = resourcePath;
        boolean isProcessingNotNeeded = themeSettings.isProcessingNotNeededPNG(resourcePath);
        boolean isForeground = themeSettings.isForegroundPNG(resourcePath);
        boolean isDrawable = themeSettings.isDrawablePNG(resourcePath);
        boolean isHeader = themeSettings.isHeaderPNG(resourcePath);
        BorderSet borderSet = themeSettings.getBorderSetPNG(resourcePath);
        boolean isBorder = borderSet.isBorder();
        int[] borderColor = borderSet.getBorderColor();
        boolean isWindow = false;
        isWindow = themeSettings.isWindowPNG(resourcePath);
        boolean isShadow = themeSettings.isShadowPNG(resourcePath);
        boolean isToolset = themeSettings.isToolsetPNG(resourcePath);
        byte[] data = null;
        try {
            data = new byte[resource.available()];
            resource.read(data);
            resource.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Arrays.sort(borderColor);
        return new PNGHolderImpl(data, path2resource, isBorder, borderColor, isWindow, isShadow, isForeground, isHeader, isToolset, isProcessingNotNeeded, isDrawable);
    }
}

