/*
 * Decompiled with CFR 0.152.
 */
package cesium.loader;

import cesium.holder.GIFHolderImpl;
import cesium.holder.ResourcesHolder;
import cesium.loader.AbstractResourcesLoader;
import cesium.theme.settings.BorderSet;
import cesium.theme.settings.ThemeSettings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class GIFResourceLoaderImpl
extends AbstractResourcesLoader {
    public GIFResourceLoaderImpl() {
    }

    public GIFResourceLoaderImpl(String resourcesPath) {
        this.setResourcesPath(resourcesPath);
    }

    @Override
    public ResourcesHolder loadResources(InputStream resource, String resourcePath, ThemeSettings themeSettings) {
        boolean isProcessingNotNeeded = themeSettings.isProcessingNotNeededGIF(resourcePath);
        boolean isForeground = themeSettings.isForegroundGIF(resourcePath);
        boolean isWhitable = themeSettings.isWhitableGIF(resourcePath);
        boolean isDrawable = themeSettings.isDrawableGIF(resourcePath);
        boolean isDrawableColorIndependent = themeSettings.isDrawableColorIndependentGIF(resourcePath);
        boolean isHeader = themeSettings.isHeaderGIF(resourcePath);
        boolean isBackground = themeSettings.isBackgroundGIF(resourcePath);
        BorderSet borderSet = themeSettings.getBorderSetGIF(resourcePath);
        boolean isBorder = borderSet.isBorder();
        int[] borderColor = borderSet.getBorderColor();
        boolean isToolset = themeSettings.isToolsetGIF(resourcePath);
        String path2resource = resourcePath;
        byte[] data = null;
        try {
            data = new byte[resource.available()];
            resource.read(data);
            resource.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Arrays.sort(borderColor);
        return new GIFHolderImpl(data, path2resource, isForeground, isBackground, isBorder, borderColor, isHeader, isToolset, isProcessingNotNeeded, isWhitable, isDrawable, isDrawableColorIndependent);
    }
}

