/*
 * Decompiled with CFR 0.152.
 */
package cesium.holder;

import cesium.holder.ResourcesHolder;
import cesium.holder.SchemaResourcesHolder;
import cesium.holder.ThemeParametersHolder;
import java.rmi.server.UID;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Set;

public abstract class AbstractResourcesHolder
extends LinkedHashMap
implements ResourcesHolder {
    protected UID ouid = new UID();
    private String resourcesPath;
    private int resourcesPathHashCode;
    private boolean isForeground;
    private boolean isWhitable;
    private boolean isDrawable;
    private boolean isDrawableColorIndependent;
    private boolean isHeader;
    private boolean isBackground;
    private boolean isFontColor;
    private boolean isBorderColor;
    private int[] borderColor;
    private boolean isToolset;
    private boolean isProcessingNotNeeded;
    private ThemeParametersHolder themeParametersHolder;

    @Override
    public void setThemeParametersHolder(ThemeParametersHolder themeParametersHolder) {
        this.themeParametersHolder = themeParametersHolder;
    }

    @Override
    public ThemeParametersHolder getThemeParametersHolder() {
        return this.themeParametersHolder;
    }

    @Override
    public boolean isDrawableColorIndependent() {
        return this.isDrawableColorIndependent;
    }

    public void setDrawableColorIndependent(boolean drawableColorIndependent) {
        this.isDrawableColorIndependent = drawableColorIndependent;
    }

    @Override
    public boolean isDrawable() {
        return this.isDrawable;
    }

    public void setDrawable(boolean drawable) {
        this.isDrawable = drawable;
    }

    public boolean isWhitable() {
        return this.isWhitable;
    }

    public void setWhitable(boolean whitable) {
        this.isWhitable = whitable;
    }

    @Override
    public boolean isProcessingNotNeeded() {
        return this.isProcessingNotNeeded;
    }

    public void setProcessingNotNeeded(boolean processingNotNeeded) {
        this.isProcessingNotNeeded = processingNotNeeded;
    }

    public boolean isToolset() {
        return this.isToolset;
    }

    public void setToolset(boolean toolset) {
        this.isToolset = toolset;
    }

    public boolean isHeader() {
        return this.isHeader;
    }

    public void setHeader(boolean header) {
        this.isHeader = header;
    }

    public int[] getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(int[] borderColor) {
        this.borderColor = borderColor;
    }

    public boolean isBorderColor() {
        return this.isBorderColor;
    }

    public void setBorderColor(boolean borderColor) {
        this.isBorderColor = borderColor;
    }

    public boolean isFontColor() {
        return this.isFontColor;
    }

    public void setFontColor(boolean fontColor) {
        this.isFontColor = fontColor;
    }

    public boolean isBackground() {
        return this.isBackground;
    }

    public void setBackground(boolean background) {
        this.isBackground = background;
    }

    public boolean isForeground() {
        return this.isForeground;
    }

    public void setForeground(boolean foreground) {
        this.isForeground = foreground;
    }

    @Override
    public String getResourcesPath() {
        return this.resourcesPath;
    }

    @Override
    public void setResourcesPath(String resourcesPath) {
        this.resourcesPath = resourcesPath;
        this.resourcesPathHashCode = resourcesPath != null ? resourcesPath.hashCode() : 0;
    }

    @Override
    public ResourcesHolder findResourceByPath(String resourcePath) {
        ResourcesHolder result = null;
        if (resourcePath != null && resourcePath.equalsIgnoreCase(this.getResourcesPath())) {
            return this;
        }
        Object resObj = this.get(resourcePath);
        if (resObj != null) {
            result = (ResourcesHolder)resObj;
        } else {
            Set set = this.keySet();
            for (Object key : set) {
                ResourcesHolder holder = (ResourcesHolder)this.get(key);
                if (holder != null && (result = holder.findResourceByPath(resourcePath)) != null) break;
            }
        }
        return result;
    }

    @Override
    public ResourcesHolder findResourceByPathHashCode(Integer hashCode) {
        ResourcesHolder result = null;
        int pathHashCode = this.getResourcesPathHashCode();
        if (hashCode != null && pathHashCode != 0 && hashCode == pathHashCode) {
            return this;
        }
        Object resObj = this.get(hashCode);
        if (resObj != null) {
            result = (ResourcesHolder)resObj;
        } else if (this instanceof SchemaResourcesHolder) {
            Set set = this.keySet();
            for (Object key : set) {
                ResourcesHolder holder = (ResourcesHolder)this.get(key);
                if (holder != null && (result = holder.findResourceByPathHashCode(hashCode)) != null) break;
            }
        }
        return result;
    }

    @Override
    public ResourcesHolder findResourceByFileEnds(String fileName) {
        ResourcesHolder result = null;
        if (fileName != null && this.getResourcesPath().endsWith(fileName)) {
            return this;
        }
        ResourcesHolder resObj = null;
        for (Object objKey : this.keySet()) {
            if (objKey instanceof String) {
                String key = (String)objKey;
                if (!key.endsWith(fileName)) continue;
                resObj = (ResourcesHolder)this.get(key);
                break;
            }
            ResourcesHolder resourcesHolder = (ResourcesHolder)this.get(objKey);
            String path = resourcesHolder.getResourcesPath();
            if (!path.endsWith(fileName)) continue;
            resObj = resourcesHolder;
            break;
        }
        if (resObj != null) {
            result = resObj;
        } else {
            Set set = this.keySet();
            for (String key : set) {
                ResourcesHolder holder = (ResourcesHolder)this.get(key);
                if (holder != null && (result = holder.findResourceByFileEnds(fileName)) != null) break;
            }
        }
        return result;
    }

    @Override
    public int getResourcesPathHashCode() {
        return this.resourcesPathHashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractResourcesHolder that = (AbstractResourcesHolder)o;
        if (this.isBackground != that.isBackground) {
            return false;
        }
        if (this.isBorderColor != that.isBorderColor) {
            return false;
        }
        if (this.isFontColor != that.isFontColor) {
            return false;
        }
        if (this.isForeground != that.isForeground) {
            return false;
        }
        if (!Arrays.equals(this.borderColor, that.borderColor)) {
            return false;
        }
        if (!this.ouid.equals(that.ouid)) {
            return false;
        }
        return !(this.resourcesPath != null ? !this.resourcesPath.equals(that.resourcesPath) : that.resourcesPath != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.ouid.hashCode();
        result = 31 * result + (this.resourcesPath != null ? this.resourcesPath.hashCode() : 0);
        result = 31 * result + (this.isForeground ? 1 : 0);
        result = 31 * result + (this.isBackground ? 1 : 0);
        result = 31 * result + (this.isFontColor ? 1 : 0);
        result = 31 * result + (this.isBorderColor ? 1 : 0);
        result = 31 * result + (this.borderColor != null ? Arrays.hashCode(this.borderColor) : 0);
        return result;
    }
}

