/*
 * Decompiled with CFR 0.152.
 */
package com.senior.ui.ext.style;

import com.senior.ui.ext.style.CSSProperty;

public class CSSUtility {
    private final String name;
    private StringBuilder definition;

    public CSSUtility(String name) {
        this.name = name;
        this.initCss();
    }

    private void initCss() {
        this.definition = new StringBuilder(".");
        this.definition.append(this.name);
        this.definition.append("{");
    }

    public void addProperty(CSSProperty cssProperty, boolean important) {
        if (cssProperty == null) {
            throw new IllegalArgumentException("Css property is null.");
        }
        if (this.definition.indexOf("}") > -1) {
            this.definition.deleteCharAt(this.definition.length() - 1);
        }
        this.definition.append(cssProperty.getPropertyName());
        this.definition.append(":");
        this.definition.append(cssProperty.getValue());
        if (important) {
            this.definition.append(" !important");
        }
        this.definition.append(";");
        this.definition.append("}");
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.definition.toString();
    }
}

