/*
 * Decompiled with CFR 0.152.
 */
package com.senior.ui.ext.renderer;

import com.senior.ui.components.ComponentProperty;
import com.senior.ui.components.VComponent;
import com.senior.ui.components.VTabGroup;
import com.senior.ui.components.VTabSheet;
import com.senior.ui.core.ChangeNode;
import com.senior.ui.ext.renderer.AbstractRender;
import com.senior.ui.ext.renderer.ComponentRenderUtility;
import com.senior.ui.ext.renderer.IComponentRenderer;
import com.senior.ui.ext.renderer.JSONUtility;
import com.senior.ui.ext.renderer.JsUtility;
import com.senior.ui.ext.style.CSSUtility;
import com.senior.ui.ext.style.DynamicCssGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class TabGroupRender
extends AbstractRender {
    public TabGroupRender() {
        this.properties.put(ComponentProperty.ACTIVE_TAB, "activeTab");
        this.methods.put(ComponentProperty.ACTIVE_TAB, "setActiveTabServer");
    }

    @Override
    protected Object getComponentPropertyToRender(VComponent component, ComponentProperty property) {
        if (property == ComponentProperty.ACTIVE_TAB) {
            VTabGroup tabGroup = (VTabGroup)component;
            return tabGroup.getActiveTabId();
        }
        return super.getComponentPropertyToRender(component, property);
    }

    @Override
    protected void render(ChangeNode node, JSONUtility util, IComponentRenderer renderer) {
        VTabGroup tabGroup = (VTabGroup)node.getComponent();
        ComponentRenderUtility.setDefaultSizeWhereUndefined((VComponent)tabGroup);
        util.key("border").value(tabGroup.isShowBorder());
        util.key("showHeader").value(tabGroup.isShowHeader());
        util.key("tabPosition").value(TabGroupRender.getExtTabsPosition(tabGroup));
        util.addPlugin("containerfocusplugin");
        if (node.hasPropertyChange(ComponentProperty.STYLE)) {
            node.clearPropertyChange(ComponentProperty.STYLE);
            TabGroupRender.renderStyle((VTabGroup)node.getComponent(), util);
        }
        if (node.hasPropertyChange(ComponentProperty.HAS_ERROR)) {
            node.clearPropertyChange(ComponentProperty.HAS_ERROR);
            util.key("incorrectChildren").value(TabGroupRender.getIncorrectChildren(tabGroup));
        }
        util.addPlugin("layoutplugin");
    }

    private static String getExtTabsPosition(VTabGroup tabGroup) {
        switch (tabGroup.getTabsPosition()) {
            case BOTTOM: {
                return "bottom";
            }
            case TOP: {
                return "top";
            }
        }
        throw new IllegalStateException("Unknow tab position: " + tabGroup.getTabsPosition());
    }

    @Override
    protected void update(ChangeNode node, JsUtility util, IComponentRenderer renderer) {
        VTabGroup tabgroup = (VTabGroup)node.getComponent();
        ComponentRenderUtility.setDefaultSizeWhereUndefined((VComponent)tabgroup);
        if (node.hasPropertyChange(ComponentProperty.STYLE)) {
            node.clearPropertyChange(ComponentProperty.STYLE);
            TabGroupRender.updateStyle(tabgroup, util);
        }
        if (node.hasPropertyChange(ComponentProperty.HAS_ERROR)) {
            node.clearPropertyChange(ComponentProperty.HAS_ERROR);
            util.method("setIncorrectChildren", TabGroupRender.getIncorrectChildren(tabgroup));
        }
    }

    private static void renderStyle(VTabGroup tabGroup, JSONUtility utility) {
        JSONUtility generateCss = JSONUtility.getInstance();
        TabGroupRender.generateCSSClasses(tabGroup, utility.getBeforeScripts(), generateCss);
        utility.key("tabStyle").value(generateCss.toString());
        JSONUtility.release(generateCss);
    }

    private static void updateStyle(VTabGroup tabGroup, JsUtility utility) {
        JSONUtility generateCss = JSONUtility.getInstance();
        TabGroupRender.generateCSSClasses(tabGroup, utility, generateCss);
        utility.method("setTabStyle", generateCss.toString());
        JSONUtility.release(generateCss);
    }

    private static void generateCSSClasses(VTabGroup tabGroup, JsUtility utility, JSONUtility generateCssJson) {
        int childCount = tabGroup.getChildCount();
        generateCssJson.array();
        int i = 0;
        while (i < childCount) {
            String[] tabStyle = tabGroup.getStyle(i);
            Map<String, CSSUtility[]> generatedCssClasses = DynamicCssGenerator.generateCss(tabStyle, tabGroup.getClass().getName());
            TabGroupRender.renderCSSClasses(generatedCssClasses, i, utility, generateCssJson);
            ++i;
        }
        generateCssJson.end();
    }

    private static void renderCSSClasses(Map<String, CSSUtility[]> cssClasses, int indexTab, JsUtility utility, JSONUtility css) {
        for (Map.Entry<String, CSSUtility[]> entry : cssClasses.entrySet()) {
            String[] generatedClassesNames = new String[entry.getValue().length];
            int i = 0;
            while (i < entry.getValue().length) {
                CSSUtility cssClass = entry.getValue()[i];
                utility.addDynamicCSS(cssClass.toString());
                generatedClassesNames[i] = cssClass.getName();
                ++i;
            }
            css.object();
            css.key("scope").value(entry.getKey());
            css.key("cls").value(generatedClassesNames);
            css.key("index").value(indexTab);
            css.end();
        }
    }

    private static List<String> getIncorrectChildren(VTabGroup tabgroup) {
        List tabs = tabgroup.getChildren();
        ArrayList<String> incorrectChildren = new ArrayList<String>();
        for (VTabSheet tab : tabs) {
            if (!tab.hasIncorrectChildren()) continue;
            incorrectChildren.add(tab.getId());
        }
        return incorrectChildren;
    }
}

