/*
 * Decompiled with CFR 0.152.
 */
package com.senior.ui.ext.renderer;

import com.senior.ui.components.ComponentProperty;
import com.senior.ui.components.DataChanges;
import com.senior.ui.components.DataType;
import com.senior.ui.components.IFieldDataDescriptor;
import com.senior.ui.components.VComponent;
import com.senior.ui.core.ChangeNode;
import com.senior.ui.ext.renderer.AbstractRender;
import com.senior.ui.ext.renderer.IComponentRenderer;
import com.senior.ui.ext.renderer.JSONUtility;
import com.senior.ui.ext.renderer.JsUtility;
import java.util.ArrayList;
import java.util.Collection;

class StoreRender
extends AbstractRender {
    StoreRender() {
    }

    @Override
    protected void render(ChangeNode node, JSONUtility jsonUtil, IComponentRenderer renderer) {
        VComponent component = node.getComponent();
        JSONUtility storeJsonUtil = JSONUtility.getInstance().object();
        storeJsonUtil.key("xtype").value("seniorarraystore");
        storeJsonUtil.key("storeId").value(component.getId());
        storeJsonUtil.key("idIndex").objectValue(0);
        storeJsonUtil.key("autoSave").objectValue(Boolean.FALSE);
        StoreRender.renderStoreReader(storeJsonUtil);
        StoreRender.renderStoreWriter(storeJsonUtil);
        StoreRender.renderStoreFields(component, storeJsonUtil);
        DataChanges dataChanges = (DataChanges)component.get(ComponentProperty.DATA_CHANGED);
        Collection dataChangeEntries = dataChanges.getDataChangeEntries();
        StoreRender.renderStoreData(dataChanges, dataChangeEntries, storeJsonUtil);
        dataChanges.clearChanges();
        node.clearPropertyChange(ComponentProperty.DATA_CHANGED);
        storeJsonUtil.end();
        jsonUtil.getBeforeScripts().newScope("Ext.create", storeJsonUtil);
        Object storeVar = jsonUtil.getBeforeScripts().getCurrentVar();
        JSONUtility.release(storeJsonUtil);
        StoreRender.renderDataMarks(dataChangeEntries, jsonUtil.getBeforeScripts());
        jsonUtil.getBeforeScripts().closeScope();
        jsonUtil.key("store").value(storeVar);
    }

    private static void renderStoreData(DataChanges dataChanges, Collection<DataChanges.DataChangeEntry> dataEntries, JSONUtility jsonUtil) {
        jsonUtil.key("data").array();
        for (DataChanges.DataChangeEntry dataEntry : dataEntries) {
            assert (dataEntry.getType() == DataChanges.DataChangeType.ADD);
            jsonUtil.value(dataEntry.getData());
        }
        jsonUtil.end();
        jsonUtil.key("atBof").value(dataChanges.isAtBof());
        jsonUtil.key("atEof").value(dataChanges.isAtEof());
    }

    private static void renderDataMarks(Collection<DataChanges.DataChangeEntry> dataChangeEntries, JsUtility jsUtil) {
        for (DataChanges.DataChangeEntry dataChangeEntry : dataChangeEntries) {
            jsUtil.method("renderRecordMarks", dataChangeEntry.getIndex(), dataChangeEntry.isNew(), dataChangeEntry.isDirty(), dataChangeEntry.getDirtyFields(), dataChangeEntry.hasError(), dataChangeEntry.getErrorFields());
        }
    }

    private static void renderStoreFields(VComponent component, JSONUtility util) {
        JSONUtility fields = util.key("fields").array();
        fields.object().key("name").value("recordKey").end();
        Collection fieldsDescriptors = (Collection)component.get(ComponentProperty.DATA_DESCRIPTION);
        for (IFieldDataDescriptor fieldDescriptor : fieldsDescriptors) {
            fields.object();
            fields.key("name").value(fieldDescriptor.getFieldName());
            if (fieldDescriptor.getFieldType() == DataType.TYPE_BOOLEAN) {
                fields.key("type").value("boolean");
            }
            fields.end();
        }
        fields.end();
    }

    private static void renderStoreWriter(JSONUtility store) {
        store.key("writer").value(null);
    }

    private static void renderStoreReader(JSONUtility store) {
        JSONUtility reader = store.key("reader").instance("Ext.data.ArrayReader").object();
        reader.key("idProperty").value("recordKey");
        reader.end();
        reader.end();
    }

    @Override
    protected void update(ChangeNode node, JsUtility util, IComponentRenderer renderer) {
        if (node.hasPropertyChange(ComponentProperty.DATA_CHANGED)) {
            node.clearPropertyChange(ComponentProperty.DATA_CHANGED);
            VComponent component = node.getComponent();
            DataChanges dataChanges = (DataChanges)component.get(ComponentProperty.DATA_CHANGED);
            util.newScope("Ext.StoreMgr.get", component.getId());
            Collection dataChangeEntries = dataChanges.getDataChangeEntries();
            ArrayList<DataChanges.DataChangeEntry> allData = new ArrayList<DataChanges.DataChangeEntry>();
            ArrayList<DataChanges.DataChangeEntry> addedData = new ArrayList<DataChanges.DataChangeEntry>();
            ArrayList<DataChanges.DataChangeEntry> changedData = new ArrayList<DataChanges.DataChangeEntry>();
            ArrayList<DataChanges.DataChangeEntry> removedData = new ArrayList<DataChanges.DataChangeEntry>();
            ArrayList<DataChanges.DataChangeEntry> errorData = new ArrayList<DataChanges.DataChangeEntry>();
            for (DataChanges.DataChangeEntry dataChangeEntry : dataChangeEntries) {
                switch (dataChangeEntry.getType()) {
                    case ADD: {
                        addedData.add(dataChangeEntry);
                        allData.add(dataChangeEntry);
                        break;
                    }
                    case CHANGE: {
                        allData.add(dataChangeEntry);
                        changedData.add(dataChangeEntry);
                        break;
                    }
                    case REMOVE: {
                        removedData.add(dataChangeEntry);
                        break;
                    }
                    case ERROR: {
                        errorData.add(dataChangeEntry);
                    }
                }
            }
            util.method("setBof", dataChanges.isAtBof());
            util.method("setEof", dataChanges.isAtEof());
            boolean needRemoveAllRecords = dataChanges.needRemoveAllRecords();
            if (!needRemoveAllRecords) {
                for (DataChanges.DataChangeEntry entry : errorData) {
                    util.method("setErrorRecord", entry.getId(), entry.getIndex(), entry.hasError(), entry.getErrorFields());
                }
            }
            if (!needRemoveAllRecords && changedData.size() == 1 && addedData.isEmpty() && removedData.isEmpty()) {
                DataChanges.DataChangeEntry dataChangeEntry = (DataChanges.DataChangeEntry)changedData.get(0);
                int index = dataChangeEntry.getIndex();
                util.method("resetChanges", index);
                Collection fDDCollection = (Collection)component.get(ComponentProperty.DATA_DESCRIPTION);
                IFieldDataDescriptor[] fieldsDescriptors = fDDCollection.toArray(new IFieldDataDescriptor[fDDCollection.size()]);
                String[] fieldNames = new String[fieldsDescriptors.length];
                Object[] values = new Object[fieldsDescriptors.length];
                Object[] data = dataChangeEntry.getData();
                int i = 0;
                while (i < fieldsDescriptors.length) {
                    Object value = data[i + 1];
                    if (fieldsDescriptors[i].getFieldType() == DataType.TYPE_BOOLEAN) {
                        value = Boolean.valueOf(String.valueOf(value));
                    }
                    fieldNames[i] = fieldsDescriptors[i].getFieldName();
                    values[i] = value;
                    ++i;
                }
                util.method("updateRecord", dataChangeEntry.getId(), fieldNames, values, index, dataChangeEntry.isNew(), dataChangeEntry.isDirty(), dataChangeEntry.getDirtyFields(), dataChangeEntry.hasError(), dataChangeEntry.getErrorFields());
            } else if (!needRemoveAllRecords && addedData.size() + removedData.size() <= 2 && changedData.isEmpty()) {
                for (DataChanges.DataChangeEntry dataChangeEntry : removedData) {
                    util.method("removeById", dataChangeEntry.getId());
                }
                for (DataChanges.DataChangeEntry dataChangeEntry : addedData) {
                    Object[] data = dataChangeEntry.getData();
                    int index = dataChangeEntry.getIndex();
                    util.scopedSentenceVar("createRecord", new Object[]{new Object[]{data}});
                    Object recordVarName = util.getCurrentVar();
                    util.closeScope();
                    util.method("suspendEvents", new Object[0]);
                    util.method("insertRecord", index, recordVarName, dataChangeEntry.isNew(), dataChangeEntry.isDirty(), dataChangeEntry.getDirtyFields(), dataChangeEntry.hasError(), dataChangeEntry.getErrorFields());
                    util.method("resumeEvents", new Object[0]);
                    util.method("fireEvent", "add", util.getCurrentVar(), recordVarName, index);
                }
            } else {
                util.method("suspendEvents", new Object[0]);
                util.method("commitChanges", new Object[0]);
                if (needRemoveAllRecords) {
                    util.method("removeAll", true);
                } else {
                    removedData.addAll(changedData);
                    if (!removedData.isEmpty()) {
                        ArrayList<Integer> removedDataIds = new ArrayList<Integer>(removedData.size());
                        for (DataChanges.DataChangeEntry dataChangeEntry : dataChangeEntries) {
                            removedDataIds.add(dataChangeEntry.getId());
                        }
                        util.method("removeById", removedDataIds);
                    }
                }
                for (DataChanges.DataChangeEntry dataChangeEntry : allData) {
                    util.method("createAndInsertRecord", dataChangeEntry.getIndex(), new Object[]{dataChangeEntry.getData()}, dataChangeEntry.isNew(), dataChangeEntry.isDirty(), dataChangeEntry.getDirtyFields(), dataChangeEntry.hasError(), dataChangeEntry.getErrorFields());
                }
                util.method("resumeEvents", new Object[0]);
                util.method("fireEvent", "datachanged", util.getCurrentVar());
            }
            util.closeScope();
            dataChanges.clearChanges();
        }
    }
}

