/*
 * Decompiled with CFR 0.152.
 */
package com.senior.ui.ext.renderer;

import com.senior.ui.core.ChangeNode;
import com.senior.ui.ext.renderer.AbstractRender;
import com.senior.ui.ext.renderer.IComponentRenderer;
import com.senior.ui.ext.renderer.JSONUtility;
import com.senior.ui.ext.renderer.JsUtility;

final class RenderProcessor {
    private static final String XTYPE = "xtype";
    private static final String CONTAINER_STYLE = "ctCls";
    private final AbstractRender[] renders;
    private final String xtype;
    private final String cssStyle;

    public RenderProcessor(String xtype, String cssStyle, AbstractRender ... renders) {
        this.xtype = xtype;
        this.renders = renders;
        this.cssStyle = cssStyle;
    }

    public void render(ChangeNode node, JSONUtility json, IComponentRenderer renderer) {
        node.log();
        if (this.xtype != null) {
            json.key(XTYPE).value(this.xtype);
        }
        if (this.cssStyle != null) {
            json.key(CONTAINER_STYLE).value(this.cssStyle);
        }
        AbstractRender[] abstractRenderArray = this.renders;
        int n = this.renders.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractRender render = abstractRenderArray[n2];
            render.iRender(node, json, renderer);
            ++n2;
        }
        json.renderDependencies();
    }

    public void update(ChangeNode node, JsUtility js, IComponentRenderer renderer) {
        node.log();
        AbstractRender[] abstractRenderArray = this.renders;
        int n = this.renders.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractRender render = abstractRenderArray[n2];
            render.iUpdate(node, js, renderer);
            ++n2;
        }
    }
}

