/*
 * Decompiled with CFR 0.152.
 */
package com.senior.ui.ext.renderer;

import com.google.gson.Gson;
import com.senior.ui.ext.renderer.JSONUtility;
import java.util.Collection;
import java.util.Map;
import org.joda.time.DateTimeFieldType;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;

public class JsUtil {
    private static Gson gson = new Gson();

    public static String value(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof UnquotedValue) {
            return value.toString();
        }
        if (value instanceof String || value instanceof Character || value instanceof Number || value instanceof Boolean) {
            return gson.toJson(value);
        }
        if (value instanceof LocalDateTime || value instanceof LocalDate) {
            ReadablePartial date = (ReadablePartial)value;
            int year = date.get(DateTimeFieldType.year());
            int month = date.get(DateTimeFieldType.monthOfYear()) - 1;
            int day = date.get(DateTimeFieldType.dayOfMonth());
            return "new Date(".concat(String.valueOf(year)).concat(",").concat(String.valueOf(month)).concat(",").concat(String.valueOf(day)).concat(",01,00,00).clearTime()");
        }
        if (value instanceof Map) {
            return gson.toJson(value);
        }
        if (value instanceof Collection) {
            return gson.toJson(value);
        }
        if (value.getClass().isArray()) {
            return gson.toJson(value);
        }
        if (value instanceof JSONUtility) {
            return value.toString();
        }
        return JsUtil.value(value.toString());
    }

    public static Object unquotedValue(Object value) {
        return new UnquotedValue(value);
    }

    private static class UnquotedValue {
        final Object value;

        public UnquotedValue(Object value) {
            this.value = value;
        }

        public String toString() {
            return this.value.toString();
        }
    }
}

