/*
 * Decompiled with CFR 0.152.
 */
package com.senior.ui.ext.renderer;

import com.senior.ui.components.ComponentProperty;
import com.senior.ui.components.DataChanges;
import com.senior.ui.components.IFieldDataDescriptor;
import com.senior.ui.components.VComponent;
import com.senior.ui.components.VComposite;
import com.senior.ui.components.VEditable;
import com.senior.ui.components.VPanel;
import com.senior.ui.components.grid.GridSortField;
import com.senior.ui.components.grid.SortDirection;
import com.senior.ui.components.grid.VGridColumn;
import com.senior.ui.components.grid.VScrollGrid;
import com.senior.ui.core.ChangeNode;
import com.senior.ui.definition.GridColumnType;
import com.senior.ui.definition.MultiSelectStyle;
import com.senior.ui.definition.OverflowKind;
import com.senior.ui.definition.TextAlignment;
import com.senior.ui.ext.renderer.AbstractRender;
import com.senior.ui.ext.renderer.ComponentRenderUtility;
import com.senior.ui.ext.renderer.GridCustomizationRender;
import com.senior.ui.ext.renderer.IComponentRenderer;
import com.senior.ui.ext.renderer.JSONUtility;
import com.senior.ui.ext.renderer.JsUtil;
import com.senior.ui.ext.renderer.JsUtility;
import com.senior.ui.ext.renderer.RendererFlag;
import com.senior.ui.ext.renderer.StoreRender;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class GridRender
extends AbstractRender {
    private static final int INSERTED_INDEX = 0;
    private static final int MODIFIED_INDEX = 1;
    private static final int REMOVED_INDEX = 2;
    private static final int ERROR_INDEX = 3;
    private static final String STATUS_COLUMN_ID = "statuscolumn";
    private static final String DELETE_COLUMN_ID = "deletecolumn";
    private static final String SELECT_COLUMN_ID = "checker";
    private final StoreRender storeRender = new StoreRender();

    public GridRender() {
        this.properties.put(ComponentProperty.STRIPE_ROWS, "stripeRows");
        this.properties.put(ComponentProperty.AUTO_HEIGHT, "autoHeight");
        this.properties.put(ComponentProperty.SHOW_BORDER, "border");
        this.properties.put(ComponentProperty.HIGHLIGHT_FOCUSED, "highlightFocused");
        this.properties.put(ComponentProperty.ALWAYS_HIGHLIGHT_FOCUSED, "alwaysHighlightFocused");
        this.properties.put(ComponentProperty.ALLOW_DELETE, "allowDelete");
        this.properties.put(ComponentProperty.FORCE_FIT, "forceFit");
        this.methods.put(ComponentProperty.HIGHLIGHT_FOCUSED, "setHighlightFocused");
        this.methods.put(ComponentProperty.ALLOW_DELETE, "setAllowDelete");
    }

    @Override
    protected void render(ChangeNode node, JSONUtility util, IComponentRenderer renderer) {
        VScrollGrid grid = (VScrollGrid)node.getComponent();
        ComponentRenderUtility.setDefaultSizeWhereUndefined((VComponent)grid);
        GridRender.renderSelectionModel(util, grid);
        GridRender.renderGridView(util, grid, node);
        GridRender.renderStyles(util, grid, node);
        GridRender.renderColumnModel(util, node, renderer);
        util.key("allowDelete").value(grid.isAllowDelete());
        util.key("allowInsert").value(grid.isAllowInsert() && !grid.isReadOnly());
        util.key("columnsEditabilityFieldName").value(grid.getColumnsEditabilityField().getFieldName());
        util.key("cls").value("x-seletor");
        if (node.hasPropertyChange(ComponentProperty.SHOW_HEADER)) {
            node.clearPropertyChange(ComponentProperty.SHOW_HEADER);
            util.key("hideHeaders").value(!grid.isShowHeader());
        }
        if (!node.hasPropertyChange(ComponentProperty.HEIGHT)) {
            util.key("height").value(115);
        }
        boolean allowDrag = grid.isAllowDrag();
        boolean allowDrop = grid.isAllowDrop();
        if (allowDrag) {
            util.key("enableDragDrop").value(true);
            for (String g : grid.getDragGroups()) {
                util.key("ddGroup").value(g);
            }
            util.key("gridDragZone").value(true);
        }
        if (allowDrop) {
            util.key("gridDropZone").value(true);
            for (String g : grid.getDropGroups()) {
                util.key("ddGroup").value(g);
            }
        }
        DataChanges dataChanges = (DataChanges)grid.get(ComponentProperty.DATA_CHANGED);
        dataChanges.clearChanges();
        this.storeRender.render(node, util, null);
    }

    private static void renderSelectionModel(JSONUtility util, VScrollGrid grid) {
        boolean singleSelect = grid.getGridModel().isSingleSelection();
        if (singleSelect) {
            util.key("selModel").instance("Ext.ux.senior.grid.CellSelectionModel").object();
        } else {
            MultiSelectStyle style = grid.getMultiSelectStyle();
            switch (style) {
                case CHECKBOX: {
                    util.key("selModel").instance("Ext.ux.senior.grid.CheckboxSelectionModel").object();
                    break;
                }
                case KEYBOARD: {
                    util.key("selModel").instance("Ext.ux.senior.grid.MultiSelectionModel").object();
                    break;
                }
                default: {
                    throw new IllegalStateException("Style \"" + style + "\" isn't valid.");
                }
            }
        }
        util.end().end();
    }

    private static void renderGridView(JSONUtility util, VScrollGrid grid, ChangeNode gridNode) {
        if (grid.isAutoHeight()) {
            util.key("view").instance("Ext.ux.senior.grid.GridView").object();
        } else {
            util.key("view").instance("Ext.ux.senior.grid.FixedColumnView").object();
        }
        if (gridNode.hasPropertyChange(ComponentProperty.EMPTY_MESSAGE)) {
            gridNode.clearPropertyChange(ComponentProperty.EMPTY_MESSAGE);
            util.key("emptyText").value(grid.getEmptyMessage());
        }
        if (gridNode.hasPropertyChange(ComponentProperty.HIGHLIGHT_FOCUSED)) {
            gridNode.clearPropertyChange(ComponentProperty.HIGHLIGHT_FOCUSED);
            util.key("highlightFocused").value(grid.getHighlightFocused());
        }
        if (gridNode.hasPropertyChange(ComponentProperty.FORCE_FIT)) {
            util.key("forceFit").value(grid.isForceFit());
            gridNode.clearPropertyChange(ComponentProperty.FORCE_FIT);
        }
        util.key("deferEmptyText").objectValue(Boolean.FALSE);
        if (gridNode.hasPropertyChange(ComponentProperty.SORT_FIELDS)) {
            gridNode.clearPropertyChange(ComponentProperty.SORT_FIELDS);
            Collection sortFields = grid.getSortFields();
            util.key("sortFields").array();
            for (GridSortField sortField : sortFields) {
                util.object();
                util.key("field").value(sortField.getFieldName());
                util.key("direction").value(GridRender.getDirectionString(sortField.getSortDirection()));
                util.end();
            }
            util.end();
        }
        util.end().end();
    }

    private static String getDirectionString(SortDirection direction) {
        switch (direction) {
            case ASCENDING: {
                return "ASC";
            }
            case DESCENDING: {
                return "DESC";
            }
        }
        throw new IllegalArgumentException("Invalid direction: " + direction);
    }

    private static void renderStyle(JSONUtility util, String property, String style) {
        util.key(property).value(style);
    }

    private static void renderStyles(JSONUtility util, VScrollGrid grid, ChangeNode gridNode) {
        if (gridNode.hasPropertyChange(ComponentProperty.CELL_STYLE_NAMES)) {
            gridNode.clearPropertyChange(ComponentProperty.CELL_STYLE_NAMES);
            GridRender.renderStyle(util, "cellStyle", grid.getCellStyle());
        }
        if (gridNode.hasPropertyChange(ComponentProperty.SELECTED_LINE_STYLE_NAMES)) {
            gridNode.clearPropertyChange(ComponentProperty.SELECTED_LINE_STYLE_NAMES);
            GridRender.renderStyle(util, "selectedLineStyle", grid.getSelectedLineStyle());
        }
    }

    private static void renderColumnModel(JSONUtility util, ChangeNode gridNode, IComponentRenderer renderer) {
        MultiSelectStyle style;
        VScrollGrid grid = (VScrollGrid)gridNode.getComponent();
        util.key("cm");
        util.instance("Ext.ux.senior.grid.FixedColumnModel");
        util.object();
        util.key("columns").array();
        JSONUtility statusConfig = JSONUtility.getInstance();
        boolean hasFixedColumns = !grid.getFixedColumns().isEmpty();
        statusConfig.object().key("xtype").value(STATUS_COLUMN_ID);
        statusConfig.key("id").value(STATUS_COLUMN_ID);
        statusConfig.key("fixedColumn").objectValue(hasFixedColumns);
        statusConfig.key("hidden").objectValue(!GridRender.isStatusColumnVisible(grid));
        if (grid.getGridModel().hasChangedRecords()) {
            int[] changes = (int[])grid.get(ComponentProperty.RECORDS_CHANGES_STATUS);
            JSONUtility changesParam = JSONUtility.getInstance();
            changesParam.object();
            changesParam.key("inserted").value(changes[0]);
            changesParam.key("modified").value(changes[1]);
            changesParam.key("removed").value(changes[2]);
            changesParam.key("error").value(changes[3]);
            changesParam.end();
            statusConfig.key("changes").value(changesParam);
            JSONUtility.release(changesParam);
        }
        statusConfig.end();
        util.getBeforeScripts().newScope("Ext.create", statusConfig);
        Object statusColumnVar = util.getBeforeScripts().getCurrentVar();
        util.getBeforeScripts().closeScope();
        JSONUtility.release(statusConfig);
        util.addPlugin(statusColumnVar);
        util.value(statusColumnVar);
        JSONUtility deleteConfig = JSONUtility.getInstance();
        deleteConfig.object().key("xtype").value(DELETE_COLUMN_ID);
        deleteConfig.key("id").value(DELETE_COLUMN_ID);
        deleteConfig.key("fixedColumn").objectValue(hasFixedColumns);
        deleteConfig.key("hidden").objectValue(!GridRender.isDeleteColumnVisible(grid));
        deleteConfig.end();
        util.getBeforeScripts().newScope("Ext.create", deleteConfig);
        Object deleteColumnVar = util.getBeforeScripts().getCurrentVar();
        util.getBeforeScripts().closeScope();
        JSONUtility.release(deleteConfig);
        util.addPlugin(deleteColumnVar);
        util.value(deleteColumnVar);
        if (!grid.getGridModel().isSingleSelection() && MultiSelectStyle.CHECKBOX == (style = grid.getMultiSelectStyle())) {
            util.instance("Ext.ux.senior.grid.CheckboxSelectionModel");
            util.object().key("fixedColumn").value(hasFixedColumns).end();
            util.end();
        }
        ArrayList columnsAssocs = new ArrayList(gridNode.getMultipleAssociations(ComponentProperty.COLUMNS));
        Collections.sort(columnsAssocs, new Comparator<ChangeNode.ChangeNodeAssociation>(){

            @Override
            public int compare(ChangeNode.ChangeNodeAssociation o1, ChangeNode.ChangeNodeAssociation o2) {
                int pos2;
                VGridColumn col1 = (VGridColumn)o1.getReferencedNode().getComponent();
                VGridColumn col2 = (VGridColumn)o2.getReferencedNode().getComponent();
                int pos1 = col1.getColumnPosition();
                if (pos1 == (pos2 = col2.getColumnPosition()) || pos1 < 0 && pos2 < 0) {
                    return 0;
                }
                if (pos1 < pos2) {
                    return -1;
                }
                return 1;
            }
        });
        int i = 0;
        while (i < columnsAssocs.size()) {
            ChangeNode.ChangeNodeAssociation columnAssoc = (ChangeNode.ChangeNodeAssociation)columnsAssocs.get(i);
            GridRender.renderColumn(grid, columnAssoc, util, renderer);
            ++i;
        }
        util.end();
        util.end();
        util.end();
    }

    private static void renderColumn(VScrollGrid grid, ChangeNode.ChangeNodeAssociation columnAssoc, JSONUtility gridUtil, IComponentRenderer renderer) {
        ChangeNode columnNode = columnAssoc.getReferencedNode();
        GridRender.clearUselessColumnChanges(columnNode);
        VGridColumn column = (VGridColumn)columnNode.getComponent();
        JSONUtility columnUtil = gridUtil;
        boolean isPlugin = false;
        boolean renderEditor = true;
        boolean needToReleaseUtil = false;
        switch (column.getColumnType()) {
            case CHECKBOX: {
                columnUtil = JSONUtility.getInstance();
                columnUtil.object();
                GridRender.renderCheckBoxColumn(columnUtil, columnNode, column, renderer);
                isPlugin = true;
                renderEditor = false;
                needToReleaseUtil = true;
                break;
            }
            case IMAGE: {
                columnUtil.object();
                columnUtil.key("xtype").value("imagecolumn");
                break;
            }
            case CUSTOM: {
                isPlugin = true;
                columnUtil = JSONUtility.getInstance();
                GridRender.renderMixedColumn(grid, column, columnUtil, columnNode);
                needToReleaseUtil = true;
                break;
            }
            default: {
                columnUtil.object();
                columnUtil.key("xtype").value("seniorcolumn");
            }
        }
        columnUtil.key("id").value(GridRender.getColumnId(column));
        columnUtil.key("name").value(column.getName());
        columnUtil.key("showCheckBox").value(column.isShowCheckBox());
        columnUtil.key("headerChecked").value(column.isHeaderCheckBoxChecked());
        columnUtil.key("header").value(column.getText());
        columnNode.clearPropertyChange(ComponentProperty.TEXT);
        String alignmentValue = GridRender.getAlignmentValue(GridRender.getColumnAlignment(column));
        columnUtil.key("align").value(alignmentValue);
        columnNode.clearPropertyChange(ComponentProperty.ALIGNMENT);
        if (column.getFieldName() != null) {
            IFieldDataDescriptor fieldDescriptor = grid.getGridModel().getField(column.getFieldName());
            String fieldName = fieldDescriptor.getFieldName();
            columnUtil.key("dataIndex").value(fieldName);
            columnUtil.key("fixedColumn").value(grid.isFixedColumn(fieldName));
            columnUtil.key("sortable").objectValue(grid.isColumnSortable(column, fieldDescriptor));
            columnUtil.key("editable").objectValue(grid.isColumnEditable(column, fieldDescriptor));
        } else {
            columnUtil.key("dataIndex").value(column.getName());
            columnUtil.key("fixedColumn").value(false);
            columnUtil.key("sortable").value(false);
            columnUtil.key("editable").value(false);
            columnUtil.key("menuDisabled").value(true);
        }
        columnUtil.key("resizable").value(grid.isColumnResizable(column));
        if (!grid.isColumnResizable(column) && grid.isForceFit()) {
            columnUtil.key("fixed").value(true);
        }
        if (column.getWidth() != null) {
            columnUtil.key("width").value(GridRender.getColumnWidth(column.getWidth()));
            columnNode.clearPropertyChange(ComponentProperty.WIDTH);
        }
        columnUtil.key("hidden").value(!column.getVisibleState());
        columnNode.clearPropertyChange(ComponentProperty.VISIBLE_STATE);
        columnNode.clearPropertyChange(ComponentProperty.COLUMN_POSITION);
        columnNode.clearPropertyChange(ComponentProperty.EDITABLE);
        ChangeNode.ChangeNodeAssociation editorAssoc = columnNode.getSingleAssociation(ComponentProperty.GRID_EDITOR);
        if (renderEditor && editorAssoc != null) {
            ChangeNode editorNode = editorAssoc.getReferencedNode();
            editorNode.setPropertyChanges(editorNode.getComponent().getDefaultProperties());
            editorNode.clearPropertyChange(ComponentProperty.CHANGED);
            RendererFlag.IGNORE_FOCUS_PLUGIN.setFlag(editorNode);
            JSONUtility editorUtil = JSONUtility.getInstance();
            editorUtil.object();
            GridRender.renderComponent(editorUtil, editorNode, grid.getId(), renderer);
            JSONUtility supressEventsArray = editorUtil.key("supressEvents").array();
            supressEventsArray.value("change");
            supressEventsArray.end();
            editorUtil.end();
            editorAssoc.markAsRendered();
            columnUtil.key("editor").value(editorUtil);
            if (editorUtil.hasAfterScripts()) {
                gridUtil.getAfterScripts().append(editorUtil.getAfterScripts());
            }
            if (editorUtil.hasBeforeScripts()) {
                gridUtil.getBeforeScripts().append(editorUtil.getBeforeScripts());
            }
            JSONUtility.release(editorUtil);
        }
        columnUtil.end();
        if (isPlugin) {
            gridUtil.getBeforeScripts().newScope("Ext.create", columnUtil);
            Object pluginVar = gridUtil.getBeforeScripts().getCurrentVar();
            gridUtil.getBeforeScripts().closeScope();
            gridUtil.addPlugin(pluginVar);
            gridUtil.value(pluginVar);
        }
        if (needToReleaseUtil) {
            JSONUtility.release(columnUtil);
        }
        columnAssoc.markAsRendered();
    }

    private static String getAlignmentValue(TextAlignment alignment) {
        String alignmentValue = "";
        switch (alignment) {
            case CENTER: {
                alignmentValue = "center";
                break;
            }
            case LEFT: {
                alignmentValue = "left";
                break;
            }
            case RIGHT: {
                alignmentValue = "right";
                break;
            }
        }
        return alignmentValue;
    }

    private static TextAlignment getColumnAlignment(VGridColumn column) {
        TextAlignment alignment = column.getComponentAlign();
        if (alignment == null) {
            return TextAlignment.LEFT;
        }
        return alignment;
    }

    private static void renderComponent(JSONUtility util, ChangeNode cmpNode, String componentOwner, IComponentRenderer renderer) {
        RendererFlag.IGNORE_MASK_PLUGIN.setFlag(cmpNode);
        renderer.render(cmpNode, util);
        util.key("componentOwner").value(componentOwner);
    }

    private static void renderCheckBoxColumn(JSONUtility columnUtil, ChangeNode columnNode, VGridColumn column, IComponentRenderer renderer) {
        JSONUtility editorUtil = JSONUtility.getInstance().object();
        ChangeNode.ChangeNodeAssociation editorAssoc = columnNode.getSingleAssociation(ComponentProperty.GRID_EDITOR);
        assert (editorAssoc != null);
        ChangeNode editorNode = editorAssoc.getReferencedNode();
        VEditable editor = (VEditable)editorNode.getComponent();
        editorNode.clearPropertyChange(ComponentProperty.ID);
        editorUtil.key("eventTargetId").value(editor.getId());
        editorUtil.key("getEventTarget").objectValue("function() {return this.eventTargetId}");
        editorUtil.key("gridId").value(column.getGrid().getId());
        editorUtil.addPlugin("checkboxgridplugin");
        RendererFlag.IGNORE_FOCUS_PLUGIN.setFlag(editorNode);
        RendererFlag.IGNORE_MARKCHANGED_PLUGIN.setFlag(editorNode);
        GridRender.renderComponent(editorUtil, editorNode, column.getGrid().getId(), renderer);
        editorUtil.key("col").value("{col}");
        editorUtil.key("defaultParams").object();
        editorUtil.key("row").value("{recordKey}");
        editorUtil.end();
        editorUtil.key("checked").value("{value}");
        editorUtil.key("readOnly").value("{readOnly}");
        editorUtil.end();
        GridRender.renderJsonTemplateColumn(columnUtil, editorUtil);
        JSONUtility.release(editorUtil);
        editorAssoc.markAsRendered();
    }

    private static void renderMixedColumn(VScrollGrid grid, VGridColumn column, JSONUtility columnUtil, ChangeNode columnNode) {
        columnUtil.object();
        columnUtil.key("gridId").value(grid.getId());
        columnUtil.key("json").object();
        columnUtil.key("defaultParams").object();
        columnUtil.key("row").value("{row}");
        columnUtil.key("col").value("{col}");
        columnUtil.end();
        columnUtil.end();
        if (columnNode.hasPropertyChange(ComponentProperty.SHOW_ON_HOVER)) {
            columnNode.clearPropertyChange(ComponentProperty.SHOW_ON_HOVER);
            columnUtil.key("showOnHover").value(column.get(ComponentProperty.SHOW_ON_HOVER));
        }
        columnUtil.key("xtype").value("mixedcomponentcolumn");
    }

    private static void renderJsonTemplateColumn(JSONUtility util, JSONUtility jsonTemplateUtil) {
        util.key("xtype").value("jsontemplatecolumn");
        util.key("json").value(jsonTemplateUtil.toString());
    }

    private static String getColumnId(VGridColumn comp) {
        return String.format("%s_%s", comp.getGrid().getId(), comp.getId());
    }

    @Override
    protected void update(ChangeNode node, JsUtility util, IComponentRenderer renderer) {
        VComposite<?> container;
        VScrollGrid grid = (VScrollGrid)node.getComponent();
        ComponentRenderUtility.setDefaultSizeWhereUndefined((VComponent)grid);
        if (!(grid.getVisibleState() && grid.hasLoadedData() && node.hasChanges())) {
            return;
        }
        boolean needReconfigureColumns = false;
        boolean needRefresh = false;
        Collection columnsAssocs = node.getMultipleAssociations(ComponentProperty.COLUMNS);
        for (ChangeNode.ChangeNodeAssociation columnAssoc : columnsAssocs) {
            ChangeNode columnNode = columnAssoc.getReferencedNode();
            GridRender.clearUselessColumnChanges(columnNode);
            VGridColumn column = (VGridColumn)columnNode.getComponent();
            if (columnAssoc.getStatus() == ChangeNode.ChangeNodeAssociationStatus.ADDED || columnAssoc.getStatus() == ChangeNode.ChangeNodeAssociationStatus.REMOVED) {
                throw new IllegalStateException(String.format("Add or remove a column is not supported at runtime. Grid id = %s, column name = %s", grid.getId(), column.getFieldName()));
            }
            if (!columnNode.hasPropertyChanges()) continue;
            if (columnNode.hasPropertyChange(ComponentProperty.COLUMN_POSITION)) {
                columnNode.clearPropertyChange(ComponentProperty.COLUMN_POSITION);
                needReconfigureColumns = true;
            }
            if (!columnNode.hasPropertyChange(ComponentProperty.ALIGNMENT)) continue;
            columnNode.clearPropertyChange(ComponentProperty.ALIGNMENT);
            String alignment = GridRender.getAlignmentValue(GridRender.getColumnAlignment(column));
            util.method("setColumnAlignment", GridRender.getColumnId(column), alignment);
            needRefresh = true;
        }
        boolean willRepaintGrid = needReconfigureColumns || needRefresh;
        boolean needHeaderUpdate = false;
        boolean hasDataChanges = node.hasPropertyChange(ComponentProperty.DATA_CHANGED);
        needHeaderUpdate = GridRender.updateColumns(util, renderer, grid, needHeaderUpdate, columnsAssocs, willRepaintGrid, hasDataChanges);
        if (node.hasPropertyChange(ComponentProperty.STATUS_COLUMN)) {
            node.clearPropertyChange(ComponentProperty.STATUS_COLUMN);
            util.method("setColumnVisibility", STATUS_COLUMN_ID, GridRender.isStatusColumnVisible(grid), !willRepaintGrid);
        }
        node.clearPropertyChange(ComponentProperty.DELETE_COLUMN);
        if (node.hasPropertyChange(ComponentProperty.FIXED_COLUMNS)) {
            node.clearPropertyChange(ComponentProperty.FIXED_COLUMNS);
            for (ChangeNode.ChangeNodeAssociation columnAssoc : columnsAssocs) {
                VGridColumn column = (VGridColumn)columnAssoc.getReferencedNode().getComponent();
                if (column.getFieldName() == null) continue;
                String fieldName = column.getFieldName();
                util.method("setColumnFixed", fieldName, grid.isFixedColumn(fieldName));
            }
            boolean hasFixedColumns = !grid.getFixedColumns().isEmpty();
            util.scopedSentenceVar("getColumnModel", new Object[0]);
            util.method("setSpecialColumnsFixed", hasFixedColumns);
            util.closeScope();
            needRefresh = true;
        }
        if (needReconfigureColumns) {
            int STATIC_COLUMNS_LENGHT = !grid.getGridModel().isSingleSelection() && grid.getMultiSelectStyle() == MultiSelectStyle.CHECKBOX ? 3 : 2;
            List columns = grid.getColumns();
            Object[] columnsParams = new Object[columns.size() + STATIC_COLUMNS_LENGHT];
            columnsParams[0] = STATUS_COLUMN_ID;
            columnsParams[1] = DELETE_COLUMN_ID;
            if (STATIC_COLUMNS_LENGHT == 3) {
                columnsParams[2] = SELECT_COLUMN_ID;
            }
            int i = 0;
            while (i < columns.size()) {
                VGridColumn column = (VGridColumn)columns.get(i);
                columnsParams[i + STATIC_COLUMNS_LENGHT] = GridRender.getColumnId(column);
                ++i;
            }
            util.method("configureColumns", columnsParams);
            GridRender.updateSelectedRows(node, grid, util);
        } else if (needRefresh) {
            util.method("getView().refresh", true);
            GridRender.updateSelectedRows(node, grid, util);
        } else if (needHeaderUpdate) {
            util.method("getView().updateHeaders", true);
        }
        if (node.hasPropertyChange(ComponentProperty.SORT_FIELDS)) {
            node.clearPropertyChange(ComponentProperty.SORT_FIELDS);
            GridRender.updateSortFields(util, grid.getSortFields());
        }
        DataChanges dataChanges = (DataChanges)grid.get(ComponentProperty.DATA_CHANGED);
        boolean dataChanged = dataChanges.containsDataChangeEntries();
        if (grid.isAutoHeight() && (dataChanges.containsChangeType(DataChanges.DataChangeType.ADD) || dataChanges.containsChangeType(DataChanges.DataChangeType.REMOVE)) && (container = GridRender.getContainerToDoLayout((VComponent)grid)) != null) {
            util.objMethod("Ext.ux.senior.LayoutOrganizer", "enqueueLayout", container.getId(), JsUtil.unquotedValue("Ext.ux.senior.LayoutOrganizer.CHANGE_ITEM"));
        }
        this.storeRender.update(node, util, renderer);
        if (node.hasPropertyChange(ComponentProperty.FIRST_VISIBLE_ROW)) {
            node.clearPropertyChange(ComponentProperty.FIRST_VISIBLE_ROW);
            util.scopedSentenceVar("getView", new Object[0]);
            util.method("stopEvents", new Object[0]);
            util.method("showRecord", grid.getFirstVisibleIndex());
            util.method("resumeEvents", new Object[0]);
            util.closeScope();
        }
        if (node.hasPropertyChange(ComponentProperty.GRID_CUSTOMIZE)) {
            node.clearPropertyChange(ComponentProperty.GRID_CUSTOMIZE);
            GridRender.renderCustomizations(util, grid);
        }
        if (hasDataChanges && grid.isShowBufferStatus()) {
            GridRender.updateStatusColumn(grid, util);
        }
        if (node.hasPropertyChange(ComponentProperty.SELECTED_ROWS)) {
            GridRender.updateSelectedRows(node, grid, util);
        }
        if (node.hasPropertyChange(ComponentProperty.FOCUSED_ROW) || dataChanged) {
            GridRender.updateFocusedRow(node, grid, util);
        }
        if (node.hasPropertyChange(ComponentProperty.CURRENT_VISIBLE)) {
            node.clearPropertyChange(ComponentProperty.CURRENT_VISIBLE);
            util.method("showRecord", grid.getFocusedRow());
        }
        if (node.hasPropertyChange(ComponentProperty.GOTO_CELL)) {
            node.clearPropertyChange(ComponentProperty.GOTO_CELL);
            if (grid.getGridModel().isSingleSelection()) {
                VScrollGrid.FieldToFocusDescriptor fieldToFocusDesc = (VScrollGrid.FieldToFocusDescriptor)grid.get(ComponentProperty.GOTO_CELL);
                util.scopedSentenceVar("getSelectionModel", new Object[0]);
                util.method("focusCellByField", fieldToFocusDesc.fieldName, fieldToFocusDesc.activeEditor);
                util.closeScope();
            }
        }
    }

    private static VComposite<?> getContainerToDoLayout(VComponent component) {
        VComposite parent = component.getParent();
        while (parent != null) {
            if (parent instanceof VPanel) {
                VPanel panel = (VPanel)parent;
                if (panel.getOverflowKind() == OverflowKind.OVERFLOW_HIDDEN) {
                    if (panel.getHeight() != null) {
                        return null;
                    }
                } else {
                    return panel;
                }
            }
            parent = parent.getParent();
        }
        return null;
    }

    private static void renderCustomizations(JsUtility util, VScrollGrid grid) {
        GridCustomizationRender gridCustomization = new GridCustomizationRender(grid);
        gridCustomization.renderStyleClassesToCreate(util);
        JSONUtility customizations = gridCustomization.getCustomizations();
        JSONUtility focusCustomizations = gridCustomization.getFocusCustomizations();
        util.method("setCustomizations", customizations, focusCustomizations);
        JSONUtility.release(customizations);
        JSONUtility.release(focusCustomizations);
    }

    private static void updateMixedColumn(JsUtility gridUtil, VScrollGrid grid, ChangeNode columnNode, VGridColumn column, IComponentRenderer renderer) {
        Collection multipleAssociations = columnNode.getMultipleAssociations(ComponentProperty.GRID_CELL_COMPONENT);
        DataChanges dataChanges = (DataChanges)grid.get(ComponentProperty.DATA_CHANGED);
        Map cells = column.getCellComponents();
        JSONUtility addData = JSONUtility.getInstance().object();
        JSONUtility removeData = JSONUtility.getInstance().array();
        block4: for (DataChanges.DataChangeEntry entry : dataChanges.getDataChangeEntries()) {
            switch (entry.getType()) {
                case ADD: {
                    VComponent component = (VComponent)cells.get(entry.getId());
                    if (component == null) break;
                    for (ChangeNode.ChangeNodeAssociation nodeAss : multipleAssociations) {
                        ChangeNode referencedNode = nodeAss.getReferencedNode();
                        if (!component.getId().equals(referencedNode.getComponent().getId())) continue;
                        JSONUtility cellUtil = JSONUtility.getInstance();
                        cellUtil.object();
                        RendererFlag.IGNORE_FOCUS_PLUGIN.setFlag(referencedNode);
                        GridRender.renderComponent(cellUtil, referencedNode, grid.getId(), renderer);
                        cellUtil.key("scale").value("tiny");
                        cellUtil.end();
                        addData.key(String.valueOf(entry.getId())).value(cellUtil);
                        JSONUtility.release(cellUtil);
                    }
                    continue block4;
                }
                case REMOVE: {
                    removeData.value(String.valueOf(entry.getId()));
                    break;
                }
            }
        }
        addData.end();
        removeData.end();
        gridUtil.method("updateMixedComponents", GridRender.getColumnId(column), addData.toString(), removeData.toString());
        JSONUtility.release(addData);
        JSONUtility.release(removeData);
    }

    private static boolean updateColumns(JsUtility util, IComponentRenderer renderer, VScrollGrid grid, boolean needHeaderUpdate, Collection<ChangeNode.ChangeNodeAssociation> columnsAssocs, boolean willRepaintGrid, boolean hasDataChanges) {
        for (ChangeNode.ChangeNodeAssociation columnAssoc : columnsAssocs) {
            ChangeNode.ChangeNodeAssociation editorAssoc;
            ChangeNode columnNode = columnAssoc.getReferencedNode();
            if (!columnNode.hasChanges()) continue;
            VGridColumn column = (VGridColumn)columnNode.getComponent();
            String columnId = GridRender.getColumnId(column);
            String fieldName = column.getFieldName();
            if (fieldName != null) {
                IFieldDataDescriptor fieldDescriptor = grid.getGridModel().getField(column.getFieldName());
                if (columnNode.hasPropertyChange(ComponentProperty.SORTABLE)) {
                    columnNode.clearPropertyChange(ComponentProperty.SORTABLE);
                    util.method("setColumnSortable", fieldName, grid.isColumnSortable(column, fieldDescriptor));
                }
                if (columnNode.hasPropertyChange(ComponentProperty.HEADER_CHECKED)) {
                    columnNode.clearPropertyChange(ComponentProperty.HEADER_CHECKED);
                    util.method("setHeaderCheckBoxChecked", fieldName, column.isHeaderCheckBoxChecked());
                }
                if (columnNode.hasPropertyChange(ComponentProperty.RESIZABLE)) {
                    columnNode.clearPropertyChange(ComponentProperty.RESIZABLE);
                    util.method("setColumnResizable", fieldName, column.isResizable());
                }
                if (columnNode.hasPropertyChange(ComponentProperty.EDITABLE)) {
                    columnNode.clearPropertyChange(ComponentProperty.EDITABLE);
                    util.method("setColumnEditability", columnId, grid.isColumnEditable(column, fieldDescriptor));
                }
            }
            if (columnNode.hasPropertyChange(ComponentProperty.TEXT)) {
                columnNode.clearPropertyChange(ComponentProperty.TEXT);
                util.method("setColumnHeader", columnId, column.getText());
                needHeaderUpdate = true;
            }
            if (columnNode.hasPropertyChange(ComponentProperty.WIDTH)) {
                columnNode.clearPropertyChange(ComponentProperty.WIDTH);
                util.method("setColumnWidth", columnId, GridRender.getColumnWidth(column.getWidth()), !willRepaintGrid);
            }
            if (columnNode.hasPropertyChange(ComponentProperty.VISIBLE_STATE)) {
                columnNode.clearPropertyChange(ComponentProperty.VISIBLE_STATE);
                util.method("setColumnVisibility", columnId, column.getVisibleState(), !willRepaintGrid);
            }
            if (column.getColumnType() == GridColumnType.CUSTOM && hasDataChanges) {
                GridRender.updateMixedColumn(util, grid, columnNode, column, renderer);
            }
            if ((editorAssoc = columnNode.getSingleAssociation(ComponentProperty.GRID_EDITOR)) == null) continue;
            ChangeNode editorNode = editorAssoc.getReferencedNode();
            if (editorAssoc.getStatus() == ChangeNode.ChangeNodeAssociationStatus.ADDED || editorAssoc.getStatus() == ChangeNode.ChangeNodeAssociationStatus.REMOVED) {
                throw new IllegalStateException(String.format("Change the editor of a column is not supported at runtime. Grid id = %s, column name = %s, editor id = %s", grid.getId(), column.getFieldName(), editorNode.getComponent().getId()));
            }
            editorNode.clearPropertyChange(ComponentProperty.TEXT);
            if (column.getColumnType() != GridColumnType.CHECKBOX) {
                RendererFlag.IGNORE_MASK_PLUGIN.setFlag(editorNode);
                renderer.update(editorNode, util);
                continue;
            }
            editorNode.clearPropertyChange(ComponentProperty.CHANGED);
        }
        return needHeaderUpdate;
    }

    private static void updateStatusColumn(VScrollGrid grid, JsUtility util) {
        util.scopedSentenceVar("getColumnModel().getColumnById", STATUS_COLUMN_ID);
        if (!grid.getGridModel().hasChangedRecords()) {
            util.method("setChanges", false);
        } else {
            int[] changes = (int[])grid.get(ComponentProperty.RECORDS_CHANGES_STATUS);
            JSONUtility changesParam = JSONUtility.getInstance();
            changesParam.object();
            changesParam.key("inserted").value(changes[0]);
            changesParam.key("modified").value(changes[1]);
            changesParam.key("removed").value(changes[2]);
            changesParam.key("error").value(changes[3]);
            changesParam.end();
            util.method("setChanges", changesParam);
            JSONUtility.release(changesParam);
        }
        util.closeScope();
    }

    private static void updateSelectedRows(ChangeNode gridNode, VScrollGrid grid, JsUtility util) {
        gridNode.clearPropertyChange(ComponentProperty.SELECTED_ROWS);
        util.scopedSentenceVar("getSelectionModel", new Object[0]);
        if (grid.getGridModel().isSingleSelection()) {
            if (grid.getFocusedRow() >= 0) {
                util.method("serverSelect", grid.getFocusedRow(), gridNode.hasPropertyChange(ComponentProperty.FOCUSED_ROW));
            }
        } else {
            util.method("clearSelections", Boolean.FALSE);
            int[] selection = (int[])grid.get(ComponentProperty.SELECTED_ROWS);
            if (selection.length > 0) {
                util.method("selectRows", new Object[]{selection});
            }
        }
        util.closeScope();
    }

    private static void updateFocusedRow(ChangeNode gridNode, VScrollGrid grid, JsUtility util) {
        gridNode.clearPropertyChange(ComponentProperty.FOCUSED_ROW);
        if (!grid.getGridModel().isSingleSelection()) {
            util.method("focusRow", grid.getFocusedRow(), true);
        }
    }

    private static void updateSortFields(JsUtility util, Collection<GridSortField> sortFields) {
        ArrayList sorters = new ArrayList();
        for (GridSortField sortField : sortFields) {
            HashMap<String, String> sorter = new HashMap<String, String>();
            sorter.put("field", sortField.getFieldName());
            sorter.put("direction", GridRender.getDirectionString(sortField.getSortDirection()));
            sorters.add(sorter);
        }
        util.method("getView().updateSortFields", sorters);
    }

    private static Object getColumnWidth(String widthString) {
        if (!widthString.contains("%")) {
            return Integer.valueOf(widthString);
        }
        return widthString;
    }

    private static boolean isStatusColumnVisible(VScrollGrid grid) {
        return grid.isShowBufferStatus();
    }

    private static boolean isDeleteColumnVisible(VScrollGrid grid) {
        return grid.isDeleteColumnVisible();
    }

    private static void clearUselessColumnChanges(ChangeNode columnNode) {
        columnNode.clearPropertyChange(ComponentProperty.ALLOW_DROP);
        columnNode.clearPropertyChange(ComponentProperty.ALLOW_DRAG);
        columnNode.clearPropertyChange(ComponentProperty.ENABLED_STATE);
        columnNode.clearPropertyChange(ComponentProperty.ID);
        columnNode.clearPropertyChange(ComponentProperty.NAME);
        columnNode.clearPropertyChange(ComponentProperty.TAB_ORDER);
    }
}

