/*
 * Decompiled with CFR 0.152.
 */
package com.senior.ui.ext.renderer;

import com.senior.ui.components.ComponentProperty;
import com.senior.ui.components.VFile;
import com.senior.ui.components.VFileButton;
import com.senior.ui.core.ChangeNode;
import com.senior.ui.definition.ButtonKind;
import com.senior.ui.ext.renderer.AbstractRender;
import com.senior.ui.ext.renderer.IComponentRenderer;
import com.senior.ui.ext.renderer.JSONUtility;
import com.senior.ui.ext.renderer.JsUtility;
import com.senior.ui.ext.renderer.RendererFlag;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.ArrayUtils;

class FileRender
extends AbstractRender {
    public FileRender() {
        this.properties.put(ComponentProperty.SHOW_BORDER, "border");
    }

    @Override
    protected void render(ChangeNode node, JSONUtility util, IComponentRenderer renderer) {
        VFile file = (VFile)node.getComponent();
        util.key("id").value(file.getId());
        util.key((String)this.properties.get(ComponentProperty.SHOW_BORDER)).value(file.isShowBorder());
        Collection buttonsAssociation = node.getMultipleAssociations(ComponentProperty.BUTTONS);
        for (ChangeNode.ChangeNodeAssociation buttonAssociation : buttonsAssociation) {
            ChangeNode buttonNode = buttonAssociation.getReferencedNode();
            RendererFlag.IGNORE_FOCUS_PLUGIN.setFlag(buttonNode);
            RendererFlag.IGNORE_EVENTMANAGER_PLUGIN.setFlag(buttonNode);
            VFileButton button = (VFileButton)buttonNode.getComponent();
            util.key(button.getFileButtonType().toString().toLowerCase().concat("Config")).object();
            FileRender.configureButtonStyle(file, button);
            buttonNode.setPropertyChanges(button.getDefaultProperties());
            if (button.getName().contains("UPLOAD")) {
                util.key("id").value(String.valueOf(file.getId()) + "_uploadField");
                if (!button.isEnabled()) {
                    util.key("disabled").value(true);
                }
                util.key("buttonCfg").object();
                renderer.render(buttonNode, util);
                if (button.getKind() == ButtonKind.FLATBUTTON) {
                    util.key("flatCls").value("senior-file-btn-flat");
                }
                util.end();
            } else {
                renderer.render(buttonNode, util);
                if (button.getKind() == ButtonKind.FLATBUTTON) {
                    util.key("flatCls").value("senior-file-btn-flat");
                }
            }
            util.end();
            buttonAssociation.markAsRendered();
        }
        node.clearPropertyChange(ComponentProperty.READ_ONLY);
    }

    @Override
    protected void update(ChangeNode node, JsUtility util, IComponentRenderer renderer) {
        Collection buttonsAssociation = node.getMultipleAssociations(ComponentProperty.BUTTONS);
        for (ChangeNode.ChangeNodeAssociation buttonAssociation : buttonsAssociation) {
            ChangeNode buttonNode = buttonAssociation.getReferencedNode();
            FileRender.configureButtonStyle((VFile)node.getComponent(), (VFileButton)buttonNode.getComponent());
            renderer.update(buttonNode, util);
        }
        node.clearPropertyChange(ComponentProperty.READ_ONLY);
    }

    private static void configureButtonStyle(VFile file, VFileButton button) {
        Object[] btnStyle;
        Object[] fileStyle = file.getStyle();
        if (!Arrays.equals(fileStyle, btnStyle = button.getStyle())) {
            Object s;
            ArrayUtils.reverse((Object[])fileStyle);
            Object[] objectArray = btnStyle;
            int n = btnStyle.length;
            int n2 = 0;
            while (n2 < n) {
                s = objectArray[n2];
                button.removeStyle((String)s);
                ++n2;
            }
            objectArray = fileStyle;
            n = fileStyle.length;
            n2 = 0;
            while (n2 < n) {
                s = objectArray[n2];
                button.addStyle((String)s);
                ++n2;
            }
        }
    }
}

