/*
 * Decompiled with CFR 0.152.
 */
package com.senior.ui.ext.renderer;

import com.senior.ui.core.ActionCommand;
import com.senior.ui.core.ChangeNode;
import com.senior.ui.core.IRenderer;
import com.senior.ui.ext.action.ExtActionCommand;
import com.senior.ui.ext.renderer.IComponentRenderer;
import com.senior.ui.ext.renderer.JSONUtility;
import com.senior.ui.ext.renderer.JsUtility;
import com.senior.ui.ext.renderer.RenderFactory;
import com.senior.ui.ext.renderer.RendererFlag;
import com.senior.util.Context;
import java.util.List;

public final class Ext3Renderer
implements IRenderer<StringBuilder>,
IComponentRenderer {
    private static final String CONTEXT_KEY = String.valueOf(Ext3Renderer.class.getName()) + ".JsUtility";

    private static JsUtility getJsUtility(StringBuilder output) {
        JsUtility jsUtility = (JsUtility)Context.current().get(CONTEXT_KEY);
        if (jsUtility == null) {
            jsUtility = new JsUtility(output, null, null, new Object[0]);
            Context.current().put(CONTEXT_KEY, (Object)jsUtility);
        } else {
            jsUtility.setOutput(output);
        }
        return jsUtility;
    }

    public void renderComponent(ChangeNode componentNode, StringBuilder output) {
        JsUtility uUtil = Ext3Renderer.getJsUtility(output);
        if (!RendererFlag.RENDERED.hasFlag(componentNode)) {
            this.renderNewComponent(componentNode, uUtil);
        } else {
            this.update(componentNode, uUtil);
        }
        uUtil.objMethod("Ext.ux.senior.LayoutOrganizer", "applyChanges", new Object[0]);
        uUtil.generateCSSStyle();
        uUtil.finish();
    }

    public void destroyComponent(ChangeNode cmpNode, StringBuilder output) {
    }

    public void renderActions(List<ActionCommand> actions, StringBuilder output) {
        JsUtility uUtil = Ext3Renderer.getJsUtility(output);
        for (ActionCommand action : actions) {
            RenderFactory.getActionRender(action).processAction(uUtil, action);
        }
        uUtil.finish();
    }

    public void renderExtActions(List<ExtActionCommand> actions, StringBuilder output) {
        JsUtility uUtil = Ext3Renderer.getJsUtility(output);
        for (ExtActionCommand action : actions) {
            RenderFactory.getExtActionRender(action).processAction(uUtil, action);
        }
        uUtil.finish();
    }

    private void renderNewComponent(ChangeNode cmpNode, JsUtility jsUtil) {
        JSONUtility jsonUtility = JSONUtility.getInstance();
        jsonUtility.object();
        this.render(cmpNode, jsonUtility);
        jsonUtility.end();
        if (jsonUtility.hasBeforeScripts()) {
            jsUtil.append(jsonUtility.getBeforeScripts());
        }
        jsUtil.objMethod("Ext", "create", jsonUtility);
        if (jsonUtility.hasAfterScripts()) {
            jsUtil.append(jsonUtility.getAfterScripts());
        }
        JSONUtility.release(jsonUtility);
    }

    @Override
    public void render(ChangeNode cmpNode, JSONUtility jsonUtil) {
        RenderFactory.getRenderProcessor(cmpNode).render(cmpNode, jsonUtil, this);
        RendererFlag.RENDERED.setFlag(cmpNode);
    }

    @Override
    public void update(ChangeNode cmpNode, JsUtility jsUtil) {
        if (!cmpNode.hasChanges()) {
            return;
        }
        jsUtil.extCmp(cmpNode.getComponent().getId());
        RenderFactory.getRenderProcessor(cmpNode).update(cmpNode, jsUtil, this);
        jsUtil.closeScope();
    }

    public StringBuilder createOutputObject() {
        return new StringBuilder();
    }
}

