/*
 * Decompiled with CFR 0.152.
 */
package com.senior.ui.ext.renderer;

import com.senior.ui.components.ComponentProperty;
import com.senior.ui.components.DataType;
import com.senior.ui.components.VComponent;
import com.senior.ui.components.VEditBox;
import com.senior.ui.components.VEditable;
import com.senior.ui.components.VTextArea;
import com.senior.ui.core.ChangeNode;
import com.senior.ui.ext.renderer.AbstractRender;
import com.senior.ui.ext.renderer.IComponentRenderer;
import com.senior.ui.ext.renderer.JSONUtility;
import com.senior.ui.ext.renderer.JsUtility;
import com.senior.ui.ext.renderer.RendererFlag;
import org.apache.commons.lang.StringUtils;

public class EditableRender
extends AbstractRender {
    @Override
    protected void render(ChangeNode node, JSONUtility utility, IComponentRenderer renderer) {
        utility.addPlugin("fieldstyle");
        VEditable cmp = (VEditable)node.getComponent();
        if (!RendererFlag.IGNORE_MARKCHANGED_PLUGIN.hasFlag(node)) {
            utility.addPlugin("fieldstatus");
            if (node.hasPropertyChange(ComponentProperty.CHANGED)) {
                Object value = cmp.get(ComponentProperty.CHANGED);
                utility.key("changedMark").objectValue(value);
                node.clearPropertyChange(ComponentProperty.CHANGED);
            }
        }
        if (this.componentAcceptsMaskPlugin(cmp)) {
            this.addMaskPlugin(utility, (VComponent)cmp);
        }
        if (!this.hasMaskPlugin((VComponent)cmp, node) && node.hasPropertyChange(ComponentProperty.TEXT)) {
            node.clearPropertyChange(ComponentProperty.TEXT);
            String text = (String)cmp.get(ComponentProperty.TEXT);
            utility.key("value").value(StringUtils.isEmpty((String)text) ? "" : text);
        }
        if (node.hasPropertyChange(ComponentProperty.HAS_ERROR)) {
            utility.key("hasError").value(cmp.get(ComponentProperty.HAS_ERROR));
            node.clearPropertyChange(ComponentProperty.HAS_ERROR);
        }
    }

    private boolean componentAcceptsMaskPlugin(VEditable cmp) {
        return cmp instanceof VEditBox || cmp instanceof VTextArea;
    }

    @Override
    protected void update(ChangeNode node, JsUtility utility, IComponentRenderer renderer) {
        VEditBox editBox;
        VEditable cmp = (VEditable)node.getComponent();
        if (!node.hasPropertyChanges() || !cmp.getVisibleState()) {
            return;
        }
        if (node.hasPropertyChange(ComponentProperty.LABEL)) {
            node.clearPropertyChange(ComponentProperty.LABEL);
            utility.method("setLabel", cmp.getLabel().getText());
        }
        if ((node.hasPropertyChange(ComponentProperty.RAW_TEXT) || node.hasPropertyChange(ComponentProperty.TEXT)) && cmp instanceof VEditBox && (editBox = (VEditBox)cmp).getType() == DataType.TYPE_DATE) {
            node.clearPropertyChange(ComponentProperty.RAW_TEXT);
            node.clearPropertyChange(ComponentProperty.TEXT);
            utility.method("setValue", cmp.get(ComponentProperty.TEXT), true);
        }
        if (!this.hasMaskPlugin((VComponent)cmp, node) && node.hasPropertyChange(ComponentProperty.TEXT)) {
            node.clearPropertyChange(ComponentProperty.TEXT);
            utility.method("setValue", cmp.get(ComponentProperty.TEXT));
        }
        if (node.hasPropertyChange(ComponentProperty.HAS_ERROR)) {
            node.clearPropertyChange(ComponentProperty.HAS_ERROR);
            utility.method("setHasError", cmp.hasError());
        }
    }
}

